/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.preverify.internal.result;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IMethodErrorInformation;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

/**
 * Implementation of the IMethodErrorInformation interface
 * wrapped around a method node.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:52:02 $
 * <br>
 * @author Craig Setera
 */
public class MethodNodeErrorInformation implements IMethodErrorInformation {
	private IClassErrorInformation classErrorInformation;
	private MethodNode methodNode;

	/**
	 * Construct a new instance of method node error information.
	 * 
	 * @param classErrorInformation
	 * @param methodNode
	 */
	public MethodNodeErrorInformation(
		IClassErrorInformation classErrorInformation,
		MethodNode methodNode)
	{
		super();
		
		this.classErrorInformation = classErrorInformation;
		this.methodNode = methodNode;
	}

	/**
	 * @see eclipseme.preverifier.results.IMethodErrorInformation#getName()
	 */
	public String getName() {
		return methodNode.name;
	}

	/**
	 * @see eclipseme.preverifier.results.IMethodErrorInformation#getTypeDescription()
	 */
	public String getTypeDescription() {
		return methodNode.desc;
	}

	/**
	 * @see eclipseme.preverifier.results.IMethodErrorInformation#getClassInformation()
	 */
	public IClassErrorInformation getClassInformation() {
		return classErrorInformation;
	}
	
	/**
	 * Get the method based on the method information.
	 * 
	 * @param type
	 * @return
	 */
	public IMethod getTypeMethod(IType type) {
		Type[] argTypes = Type.getArgumentTypes(getTypeDescription());
		String[] argTypeStrings = new String[argTypes.length];
		for (int i = 0; i < argTypes.length; i++) {
			argTypeStrings[i] = argTypes[i].getInternalName();
		}
		
		return type.getMethod(getName(), argTypeStrings);
	}

}
