/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.preferences;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DeployController implements ICheckStateListener{
	private DeployComposite composite;

	private DeploymentProvider[] providers;
	
	private CheckboxTableViewer providerTableViewer;
	private CheckboxTableViewer deviceTableViewer;
	private Button editProviderButton;
	private Button editDeviceButton;
		
	public DeployController(DeployComposite composite) {
		this.composite = composite;

		this.deviceTableViewer = composite.getDeviceTableViewer();
		this.providerTableViewer = composite.getProviderTableViewer();
		this.editDeviceButton = composite.getEditDeviceButton();
		this.editProviderButton = composite.getEditProviderButton();
		editDeviceButton.setEnabled(false);
		editProviderButton.setEnabled(false);
		
		setProviderTable();
		setDeviceTable();
		addListeners();

		updateProvider();
	}
	
	private void updateProvider() {
		BasicEList list = new BasicEList();

		class LoadData  implements IRunnableWithProgress {
			private BasicEList list;
			
			public LoadData(BasicEList list) {
				this.list = list;
			}
			
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				monitor.beginTask(DeploymentManagementUIMessages.DeployController_LoadingDeploymentProviderData, 100);
				monitor.worked(50);

				MtjExtension[] extension = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
				list.setData(extension.length,extension);
				
				monitor.done();
			}
		}

		try {
			IRunnableWithProgress op = new LoadData(list);
			new ProgressMonitorDialog(composite.getShell()).run(false, false, op);
		} catch (Exception e) {
			e.printStackTrace();
			// TODO
		}
		
		providerTableViewer.setInput(list);
		deviceTableViewer.setInput(new Device[0]);
	}
	
	private void addListeners() {
		this.providerTableViewer.addCheckStateListener(this);
	}
	
	private void setProviderTable() {
		class cp implements IStructuredContentProvider 
		{
			public Object[] getElements(Object o) {
				if(o instanceof BasicEList) {
					return ((BasicEList)o).toArray();
				} else return null;
			}
			
			public void dispose() {}		
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		}

		class plp extends LabelProvider implements ITableLabelProvider {
			public Image getColumnImage(Object element, int columnIndex) {
				  return null;
			}
			
			public String getColumnText(Object element, int columnIndex) {
				if(element instanceof DeploymentProvider) {
					DeploymentProvider dp = (DeploymentProvider) element;
					if(columnIndex == 0) { return ""; } //$NON-NLS-1$
					else if(columnIndex == 1) { return dp.getName(); }
					else if(columnIndex == 2) { return dp.getVendor(); }
					else if(columnIndex == 3) { return dp.getVersion(); }
				}
				return null;
			}			
		}

		
		createTableColumn("", providerTableViewer.getTable(), 0, 20); //$NON-NLS-1$
		createTableColumn(DeploymentManagementUIMessages.DeployController_Name, providerTableViewer.getTable(), 1, 160);
		createTableColumn(DeploymentManagementUIMessages.DeployController_Vendor, providerTableViewer.getTable(), 2, 100);
		createTableColumn(DeploymentManagementUIMessages.DeployController_Version, providerTableViewer.getTable(), 3, 60);

		providerTableViewer.setContentProvider(new cp());
        providerTableViewer.setLabelProvider(new plp());		
	}		

	private void setDeviceTable() {
		class cp implements IStructuredContentProvider 
		{
			public Object[] getElements(Object o) {
				if(o instanceof Device[]) {
					return (Device[])o;
				} else return null;
			}
			
			public void dispose() {}		
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		}

		class plp extends LabelProvider implements ITableLabelProvider {
			public Image getColumnImage(Object element, int columnIndex) {
				  return null;
			}
			
			public String getColumnText(Object element, int columnIndex) {
				if(element instanceof Device) {
					Device d = (Device) element;
					if(columnIndex == 0) { return ""; } //$NON-NLS-1$
					else if(columnIndex == 1) { return d.getName(); }
					else if(columnIndex == 2) { return d.getVendor(); }
					else if(columnIndex == 3) { return d.getVersion(); }
				}
				return null;
			}			
		}
		
		createTableColumn("", deviceTableViewer.getTable(), 0, 20); //$NON-NLS-1$
		createTableColumn(DeploymentManagementUIMessages.DeployController_Name, deviceTableViewer.getTable(), 1, 160);
		createTableColumn(DeploymentManagementUIMessages.DeployController_Vendor, deviceTableViewer.getTable(), 2, 60);
		createTableColumn(DeploymentManagementUIMessages.DeployController_Version, deviceTableViewer.getTable(), 3, 60);		

		deviceTableViewer.setContentProvider(new cp());
        deviceTableViewer.setLabelProvider(new plp());
        	
        	
	}
	
	private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
		TableColumn tableColumn = new TableColumn(table, SWT.NONE, index);
		tableColumn.setResizable(true);
		tableColumn.setWidth(widthHint);
		tableColumn.setText(title);
		return tableColumn;
	}

	public void checkStateChanged(CheckStateChangedEvent event) {
		boolean checkState = event.getChecked();
		Object o = event.getElement();
		if(o instanceof DeploymentProvider) {
			DeploymentProvider dp = (DeploymentProvider) o;
			try {
				Device[] da = dp.getDevices();
				
				if(checkState) {
					deviceTableViewer.setInput(da);
				} else {
					deviceTableViewer.setInput(new Device[0]);					
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else if(o instanceof Device) {
			// TODO
						
			
		}
	}	
}
