/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.preferences;

import java.util.logging.Logger;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DeployPage extends PreferencePage implements IWorkbenchPreferencePage {
	private static Logger log = Logger.getLogger(DeployPage.class.getName());

	private DeployController controller;
	
	public DeployPage() {
		super();
		log.info(DeploymentManagementUIMessages.DeployPage_ConstructingDeployPreferencePage);
		setTitle(DeploymentManagementUIMessages.PreferencesDeployPage_Deploy);
		// setDescription("Create and modify Device Platforms");
		noDefaultAndApplyButton();
	}

	protected Control createContents(Composite parent) {
		DeployComposite composite = new DeployComposite(parent);
		controller = new DeployController(composite);
		return composite;
	}

	public void init(IWorkbench workbench) {
	}

	public boolean performOk() {
		return true;
	}	
}
