/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.util;

import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.exception.MtjException;

public class DevicesContentProvider implements ITreeContentProvider {

    public Object[] getChildren(Object parentElement) {
        
        if(parentElement instanceof DeploymentProvider){
            try {
                return (Object[])((DeploymentProvider)parentElement).getDevices();
            } catch (MtjException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        
        return null;
    }

    public Object getParent(Object element) {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean hasChildren(Object element) {
        if(element instanceof DeploymentProvider){
            
            DeploymentProvider provider = (DeploymentProvider)element;
            try {
                if(provider.getDevices() != null){
                    return true;
                }
                else{ 
                    return false;
                }
            } catch (MtjException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        else if(element instanceof Device){
            return true;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void dispose() {
        // TODO Auto-generated method stub

    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // TODO Auto-generated method stub

    }

}
