/*******************************************************************************
* Copyright (c) 2006 IBM.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.eclipse.javame;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.BuildProviderUtil;

public class JavaMePackaging {
	
	private IMtjProject mtjProject;
	private IFolder binaryFolder;
	private IFolder deploymentFolder;
	private IProgressMonitor monitor;
	
	/**
	 * @param monitor
	 */
	public JavaMePackaging(IMtjProject mtjProject, IProgressMonitor monitor) {
		super();
		this.mtjProject = mtjProject;
		this.monitor = monitor;
	}

	public void performPackaging(String natureId) throws MtjException, CoreException {
		DeploymentType dtype = BuildProviderUtil.getDeploymentType (mtjProject);
		PackagingProvider provider = BuildProviderUtil.getPackagingProvider (mtjProject, dtype);
			
		IResource[] outputResources = { getBinaryFolder(), null };
		
		provider.createDeployment(mtjProject.getProject().getName(), mtjProject.getProjectData(), 
				outputResources, getDeploymentFolder(), dtype, natureId, monitor);
		
		EclipseUtil.setResourcesAsDerived(getDeploymentFolder());
	}

	/**
	 * @return Returns the deploymentFolder.
	 * @throws CoreException 
	 */
	public IFolder getDeploymentFolder() throws CoreException {
		if (deploymentFolder == null)
		{
			deploymentFolder = mtjProject.getDeploymentFolder(monitor);
			if (deploymentFolder.exists())
				deploymentFolder.delete( true, monitor);
			deploymentFolder.create(true, true, monitor);
		}
		if (!deploymentFolder.exists())
			deploymentFolder.create(true, true, monitor);
		return deploymentFolder;
	}

	/**
	 * @param deploymentFolder The deploymentFolder to set.
	 * @throws CoreException 
	 */
	public void setDeploymentFolder(IFolder deploymentFolder) throws CoreException {
		if (deploymentFolder.exists())
			deploymentFolder.delete (true, monitor);
		deploymentFolder.create(true, true, monitor);

		this.deploymentFolder = deploymentFolder;
	}

	/**
	 * @return Returns the binaryFolder.
	 * @throws CoreException 
	 */
	public IFolder getBinaryFolder() throws CoreException {
		if (binaryFolder == null)
			binaryFolder = mtjProject.getClassesOutputFolder(monitor);

		return binaryFolder;
	}

	/**
	 * @param binaryFolder The binaryFolder to set.
	 * @throws CoreException 
	 */
	public void setBinaryFolder(IFolder outputFolder) {
		this.binaryFolder = outputFolder;
	}
}
