/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.eclipse.midp;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PreverificationProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.PreverificationException;

public class MidpPreverify {
	
	private IProgressMonitor monitor;
	private IMtjProject mtjProject;
	private IFolder preverifiedOutputDir = null; // This is the folder where files that are preverified will be output
	private IFolder classesDir = null; // This is the location where the .class files already exist
	
	/**
	 * @param project
	 * @param monitor
	 */
	public MidpPreverify(IMtjProject project, IProgressMonitor monitor) {
		super();
		// TODO Auto-generated constructor stub
		mtjProject = project;
		this.monitor = monitor;
	}



	public void performPreverify(RuntimePlatformDefinition targetPlatform) throws MtjException, CoreException {
		MtjExtension[] extensions = 
			MtjServices.getInstance().getImplementations(ExtensionType.PREVERIFICATION_PROVIDER_LITERAL, null, null,true);
		PreverificationProvider provider = extensions.length > 0 ? (PreverificationProvider)extensions[0] : null;
		if ( provider == null ) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.PREVERIFICATION_PROVIDER_NOT_FOUND_ERROR));
		} 
		
		IResource[] resource = new IResource[1];
		resource[0] = getClassesDir();
		
		PreverificationError[] preverificationError = provider.preverify(
				mtjProject,
				targetPlatform,
				resource, getOutputFolder(), 
				monitor);
		
		if (preverificationError.length > 0) {
			PreverificationException ex = new PreverificationException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERRORS_FOUND_IN_PREVERIFICATION));
			ex.setPreverificationError(preverificationError);
			throw ex;
		}
	}

	/**
	 * @return Returns the preverifiedOutputDir.
	 * @throws CoreException 
	 */
	public IFolder getOutputFolder() throws CoreException {
		if (preverifiedOutputDir == null)
		{
			preverifiedOutputDir = mtjProject.getVerifiedClassesOutputFolder(monitor);
			if (preverifiedOutputDir.exists())
				preverifiedOutputDir.delete (true, monitor);
			preverifiedOutputDir.create(true, true, monitor);

		}
		if (!preverifiedOutputDir.exists())
			preverifiedOutputDir.create(true, true, monitor);
		return preverifiedOutputDir;
	}

	/**
	 * @param preverifiedOutputDir The preverifiedOutputDir for verified classes.
	 * @throws CoreException 
	 */
	public void setOutputFolder(IFolder outputFolder) throws CoreException {
		if (outputFolder.exists())
			outputFolder.delete (true, monitor);
		outputFolder.create(true, true, monitor);

		this.preverifiedOutputDir = outputFolder;
	}

	/**
	 * @return Returns the classesDir.
	 * @throws CoreException 
	 */
	public IFolder getClassesDir() throws CoreException {
		if (classesDir == null)
			classesDir = mtjProject.getClassesOutputFolder(monitor);
		return classesDir;
	}

	/**
	 * @param classesDir The classesDir to set.
	 */
	public void setClassesDir(IFolder binaryFilesDir) {
		this.classesDir = binaryFilesDir;
	}
	

}
