/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.model;

import java.util.ArrayList;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;

public class ExtensionContentProvider implements IStructuredContentProvider {

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		MtjExtension[] list = MtjServices.getInstance().getAllImplementations(); 
    	if (list.length > 0) {
    		ArrayList arr = new ArrayList();
    		for (int i =0; i < list.length; i++) {
    			MtjExtension m = list[i];
    			ExtensionImplNode ein = new ExtensionImplNode(MtjServices.getInstance().capitalizeIdentifier( m.getType().toString() ), m);
    			arr.add(ein);
    		}
    		return arr.toArray();
    	} else {
    		Object[] o = {};
    		return o;
    	} //(list.length > 0)
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub

	}

}
