/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CoreUIStrings {
	private static final String BUNDLE_NAME = "org.eclipse.mtj.ui.CoreUIPluginResources"; //$NON-NLS-1$
	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getString(String key)
	{
		String result = key;
		try
		{
			result = RESOURCE_BUNDLE.getString(key).trim();
		}
		catch(MissingResourceException e)
		{
		}
		
		return(result);
	}
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.  Substitutions will be made if
	 * supplied.
	 * 
	 * @param key
	 * @param substitutions
	 * @return String
	 */
	public static String getString(String key, Object[] substitutions)
	{
		String result = '!' + key + '!';
		try
		{
			result = RESOURCE_BUNDLE.getString(key).trim();
		}
		catch(MissingResourceException e)
		{
		}
		
		return MessageFormat.format(result, substitutions);
	}
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or <code>null</code> if not found.
	 */
	public static String getBundleString(String key)
	{
		String result = null;
		try
		{
			result = RESOURCE_BUNDLE.getString(key).trim();
		}
		catch(MissingResourceException e)
		{
		}
		
		return(result);
	}
}

