/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.preferences;

import java.util.logging.Logger;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.MtjDeviceManagementPlugin;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListComposite;
import org.eclipse.mtj.extension.dm.ui.util.PreferenceUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DmPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
	private final static String NOKIA_IMPORT_PROVIDER = "org.eclipse.mtj.extension.dpp.nokia"; //$NON-NLS-1$
	private final static String UEI_IMPORT_PROVIDER = "org.eclipse.mtj.extension.dpp.uei"; //$NON-NLS-1$
	private static Logger log = Logger.getLogger(DmPreferencePage.class.getName());

	private DevicePlatformListComposite deviceComposite;
	private DevicePlatformListController deviceController;
	
	public DmPreferencePage() {
		super();
		log.info(Messages.DmPreferencePage_ConstructingDmPreferencePage);
		setTitle(Messages.DmPreferencePage_DevicePlatform);
		setDescription(Messages.DmPreferencePage_CreateAndModifyDevicePlatforms);
	}

	protected Control createContents(Composite parent) {
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				parent,	MtjDeviceManagementPlugin.getPluginId()+".mtjcore0000"); //$NON-NLS-1$
		deviceComposite = new DevicePlatformListComposite(parent);
		deviceController = new DevicePlatformListController(deviceComposite);
		return deviceComposite;
	}

	public void init(IWorkbench workbench) {
	}

	public void performDefaults() {
		MessageDialog dialog = new MessageDialog(
				this.getShell(),
				Messages.DevicePlatformListController_Confirm,null,
				Messages.DmPreferencePage_ConfirmDescription,
				MessageDialog.QUESTION, 
				new String[] {Messages.DevicePlatformListController_Ok,Messages.DevicePlatformListController_Cancel},0);
		if(dialog.open() == 0) {
			deviceController.setDefaults();
		} 
	}
	
	private boolean storeDevicePlatforms(DevicePlatform[] devicePlatforms) {
		boolean okToStore = MtjServiceHandler.setDevicePlatforms(devicePlatforms);
		log.info("DMPreferencePage OK Performed " +okToStore); //$NON-NLS-1$
		if (okToStore) {
			return super.performOk();
		} else {
			return okToStore;
		}		
	}
	
	public static DevicePlatformProvider getProvider(String id) {
		PreferenceUtils utils = new PreferenceUtils();
		DevicePlatformProvider[] dpps = utils.getToolkitSupporters();
		
		for(DevicePlatformProvider dpp: dpps) {
			if(dpp.getId().equals(id)) {
				return dpp;
			}		
		}	
		
		return null;
	}
	
	public boolean performOk() {
		DevicePlatform[] savePlatforms = deviceController.getDevicePlatforms() != null ? deviceController.getDevicePlatforms(): new DevicePlatform[0];
		// DevicePlatform[] existingPlatforms = MtjServiceHandler.getDevicePlatforms();

		// DevicePlatformProvider dpp = getProvider(NOKIA_IMPORT_PROVIDER);
		DevicePlatformProvider dpp = getProvider(UEI_IMPORT_PROVIDER);
		try {
			((ToolkitSupport)dpp).setDevicePlatforms(savePlatforms);
		} catch (MtjException e) {
			e.printStackTrace();
			return false;
		}
		
		/*
		// gathering toolkitMap for saving purposis
		Map<ToolkitSupport,List<DevicePlatform>> toolkitMap = new HashMap();
		for(DevicePlatform dp: savePlatforms) {
			ToolkitSupport tks = (ToolkitSupport)dp.getDevicePlatformProvider();
			if(toolkitMap.containsKey(tks)) {
				List<DevicePlatform> dpList = toolkitMap.get(tks);
				dpList.add(dp);
			} else {
				List<DevicePlatform> dpList = new ArrayList();
				dpList.add(dp);				
				toolkitMap.put(tks,dpList);
			}
		}
		*/
		
		return true;
	}
}


