/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import java.io.File;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * Preverification Provider is responsible of verifying application projects resources.
 * <p>
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:20 $
 * <br>
 */
public interface PreverificationProvider extends MtjExtension {

	/**
	 * Launch the preverification process on the specified
	 * resources.
	 */
	public PreverificationError[] preverify(
		IMtjProject project, 
		RuntimePlatformDefinition targetPlatform,
		IResource[] inResource,
		IFolder outputFolder,
		IProgressMonitor monitor) 
			throws MtjException;

	/**
	 * Launch the preverification process on the specified
	 * jar file.
	 */
	public PreverificationError[] preverifyJarFile(
		String projectName,
		RuntimePlatformDefinition targetPlatform,
		File jarFile,
		IFolder outputFolder,
		IProgressMonitor monitor) 
			throws MtjException;

}
