/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.core;

/**
 * Constant definitions for use throughout the plugin.
 */
public interface IEclipseMtjCoreConstants {
	// The plugin ID
	public static final String PLUGIN_ID = "org.eclipse.mtj.core.ui"; //$NON-NLS-1$

	// New project creation preferences
	public static final String PREF_USE_RESOURCES_DIR = "use_resources_dir"; //$NON-NLS-1$

	public static final String PREF_RESOURCES_DIR = "resources_dir"; //$NON-NLS-1$

	public static final String PREF_FORCE_JAVA11 = "force_java11"; //$NON-NLS-1$

	// Over the Air preferences
	public static final String PREF_OTA_SERVER_START_AT_START = "ota_start_at_start"; //$NON-NLS-1$

	public static final String PREF_OTA_PORT_DEFINED = "ota_port_defined"; //$NON-NLS-1$

	public static final String PREF_OTA_PORT = "ota_port"; //$NON-NLS-1$

	public static final String PREF_OTA_AUTODEPLOY = "ota_autodeploy"; //$NON-NLS-1$

	// Proguard obfuscation preferences
	public static final String PREF_OBFUSCATION_USE_PROJECT = "obfuscate_use_project"; //$NON-NLS-1$

	public static final String PREF_PROGUARD_DIR = "proguard_dir"; //$NON-NLS-1$

	public static final String PREF_PROGUARD_USE_SPECIFIED = "proguard_use_specified"; //$NON-NLS-1$

	public static final String PREF_PROGUARD_OPTIONS = "proguard_options"; //$NON-NLS-1$

	public static final String PREF_PROGUARD_KEEP = "proguard_keep"; //$NON-NLS-1$

	// Packaging related preferences
	public static final String PREF_PKG_USE_PROJECT = "pkg_use_project"; //$NON-NLS-1$

	public static final String PREF_PKG_AUTOVERSION = "pkg_autoversion"; //$NON-NLS-1$

	public static final String PREF_PKG_EXCLUDED_PROPS = "pkg_excluded_props"; //$NON-NLS-1$

	// Miscellaneous preferences
	public static final String PREF_RMTDBG_DELAY = "rmt_debug_delay"; //$NON-NLS-1$

	public static final String PREF_ANTENNA_JAR = "antenna_jar"; //$NON-NLS-1$

	// Debugging property keys
	// Key that uses "true" or "false" to control whether or not
	// to dump the launch command line for the emulator
	public static final String PROP_DUMP_LAUNCH = "eclipseme.dump.launch"; //$NON-NLS-1$

	// Key that uses "true" or "false" to control whether or not
	// to log the complete information that is returned from running the
	// preverifier executable
	public static final String PROP_LOG_PREVERIFICATION = "eclipseme.log.preverification"; //$NON-NLS-1$

	// The superclass of all midlets
	public static final String MIDLET_SUPERCLASS = "javax.microedition.midlet.MIDlet"; //$NON-NLS-1$

	// Miscellaenous
	public static final String PROGUARD_JAR = "proguard.jar"; //$NON-NLS-1$

	public static final String MTJ_PREVERIFIER_ID = PLUGIN_ID + ".preverifier"; //$NON-NLS-1$

	public static final String MTJ_PREPROCESSOR_ID = PLUGIN_ID
			+ ".preprocessor"; //$NON-NLS-1$

	public static final String MTJ_TOOLKIT_TYPES_ID = "wirelessToolkitTypes"; //$NON-NLS-1$

	public static final String MTJ_CONFIGURATIONS_ID = "configurations"; //$NON-NLS-1$

	public static final String MTJ_PROFILES_ID = "profiles"; //$NON-NLS-1$

	// ////////////////////////////////////////////////////////////////////
	// Error messages
	// ////////////////////////////////////////////////////////////////////
	/** No midlets defined during OTA launch */
	public static final int ERR_OTA_NO_MIDLETS = 100;

	/** Errors occurred during obfuscation */
	public static final int ERR_OBFUSCATION_ERRORS = 101;

	/** Error searching for jar executable */
	public static final int ERR_COULD_NOT_FIND_JAR_TOOL = 102;

	/** Need signature passwords (not really an error, but triggers a dialog) */
	public static final int INFO_NEED_SIGNATURE_PASSWORDS = 103;
}
