/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
 * Copyright (c) 2004 Kevin Hunter
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Nokia -  Partial implementation
 * Kevin Hunter - Initial API and implementation
 * 
*******************************************************************************/
package org.eclipse.mtj.core;

import java.text.MessageFormat;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import org.eclipse.mtj.core.IMtjCoreConstants;

public class MtjCoreErrors {

	/**
	 * This string represents the prefix used in looking up messages for
	 * error and warning codes.
	 */
	
	public static final String MESSAGE_PREFIX = "MTJCoreError."; //$NON-NLS-1$
	
	/*
	 * The constants below represent errors that the eclipseme.core plugin
	 * can generate.  Messages for these will be found in the EclipseMECoreStrings.properties
	 * file.
	 */
	public static final int ERROR_BASE_CORE            = 1000;
	public static final int ERROR_BASE_PACKAGING       = 2000;
	public static final int ERROR_BASE_BUILD           = 3000;
	public static final int ERROR_BASE_LAUNCH          = 4000;
	public static final int ERROR_BASE_PROJECT         = 5000;
	public static final int ERROR_BASE_DEVICE_PLATFORM = 6000;
	public static final int ERROR_BASE_SIGNING         = 7000;
	public static final int ERROR_BASE_PREVERIFICATION = 10000;
	public static final int ERROR_BASE_SECURITY		   = 20000;
	
	//
	// Core Errors
	//
	public static final int EMF_DATA_MODEL_ERROR							= ERROR_BASE_CORE + 1;
	
	//
	// Packaging Errors
	//
	public static final int PACKAGING_PROVIDER_NOT_FOUND_ERROR				= ERROR_BASE_PACKAGING + 1;
	public static final int PACKAGING_ERROR									= ERROR_BASE_PACKAGING + 2;
	
	//
	// Build Errors
	//
	public static final int BUILD_PROVIDER_NOT_FOUND_ERROR					= ERROR_BASE_BUILD + 1;
	
	//
	// Launch Errors
	//
	public static final int VM_CONNECT_TIMEOUT_ERROR						= ERROR_BASE_LAUNCH + 1;
	public static final int TARGET_DEVICE_ACCESS_ERROR						= ERROR_BASE_LAUNCH + 2;
	public static final int TARGET_PLATFORM_ACCESS_ERROR					= ERROR_BASE_LAUNCH + 3;
	public static final int MIDP_JAD_CREATION_ERROR							= ERROR_BASE_LAUNCH + 4;
	
	//
	// Project Errors
	//
	public static final int PROJECT_DEPLOYMENT_ACCESS_ERROR					= ERROR_BASE_PROJECT + 1;
	public static final int PROJECT_INSTANTIATION_ERROR					    = ERROR_BASE_PROJECT + 2;
	public static final int PROJECT_EXTENSION_DATA_ERROR					= ERROR_BASE_PROJECT + 3;
	
	//
	// Device Platform Errors
	//
	public static final int DEVICE_PLATFORM_PROVIDER_NOT_DEFINED_ERROR		= ERROR_BASE_DEVICE_PLATFORM + 1;
	public static final int DEVICE_PLATFORM_ROOT_ERROR						= ERROR_BASE_DEVICE_PLATFORM + 2;
		
	//
	// Signing Errors
	//
	public static final int SIGNING_BAD_KEYSTORE_OR_PASSWORD				= ERROR_BASE_SIGNING + 1;
	public static final int SIGNING_KEYSTORE_TYPE_NOT_AVAILABLE 			= ERROR_BASE_SIGNING + 2;
	public static final int SIGNING_PROVIDER_NOT_CONFIGURED					= ERROR_BASE_SIGNING + 3;
	public static final int SIGNING_MISSING_KEYSTORE_INTEGRITY_ALGORITHM	= ERROR_BASE_SIGNING + 4;
	public static final int SIGNING_COULDNT_LOAD_CERTIFICATE				= ERROR_BASE_SIGNING + 5;
	public static final int SIGNING_KEY_NOT_FOUND							= ERROR_BASE_SIGNING + 6;
	public static final int SIGNING_INVALID_KEY_PASSWORD					= ERROR_BASE_SIGNING + 7;
	public static final int SIGNING_BAD_KEY_TYPE							= ERROR_BASE_SIGNING + 8;
	public static final int SIGNING_INVALID_CERTIFICATE_CHAIN				= ERROR_BASE_SIGNING + 9;
	public static final int SIGNING_MISSING_CERTIFICATES					= ERROR_BASE_SIGNING + 10;
	public static final int SIGNING_INVALID_KEY								= ERROR_BASE_SIGNING + 11;
	public static final int SIGNING_NO_SUCH_ALGORITHM						= ERROR_BASE_SIGNING + 12;
	public static final int SIGNING_SIGNATURE_EXCEPTION						= ERROR_BASE_SIGNING + 13;
	public static final int SIGNING_CERTIFICATE_ENCODING					= ERROR_BASE_SIGNING + 14;
	public static final int SIGNING_DEPLOYMENT_NOT_SUPPORTED				= ERROR_BASE_SIGNING + 15;
	public static final int SIGNING_KEYSOTRE_NOT_FOUND						= ERROR_BASE_SIGNING + 16;
	
	//
	//Security Errors
	//
	
	public static final int SECURITY_BAD_KEYSTORE_OR_PASSWORD				= ERROR_BASE_SECURITY + 1;
	public static final int SECURITY_BAD_KEY_TYPE				 			= ERROR_BASE_SECURITY + 2;
	public static final int SECURITY_MANAGER_NOT_CONFIGURED					= ERROR_BASE_SECURITY + 3;
	public static final int SECURITY_ALIAS_DUPLICATE						= ERROR_BASE_SECURITY + 4;
	public static final int SECURITY_MALFORMED_PASSWORD						= ERROR_BASE_SECURITY + 5;
	
	//
	// PreVerification Errors
	//
	public static final int PREVERIFICATION_ERROR				             = ERROR_BASE_PREVERIFICATION + 1;
	public static final int PREVERIFICATION_PROVIDER_NOT_FOUND_ERROR	     = ERROR_BASE_PREVERIFICATION + 2;
	public static final int ERRORS_FOUND_IN_PREVERIFICATION	     			 = ERROR_BASE_PREVERIFICATION + 3;
	public static final int ERROR_WHILE_ADDING_PREVERIFICATION_ERRORS		 = ERROR_BASE_PREVERIFICATION + 4;
	
	/*
	 * The constants below represent warnings that the eclipseme.core plugin
	 * can generate.  Messages for these will be found in the EclipseMECoreStrings.properties
	 * file.
	 */
	public static final int CORE_WARNING_BASE = 20000;
	
	/*
	 * The constants below represent internal errors.  These indicate some kind of
	 * logic fault, as opposed to being something that could happen under normal
	 * conditions.  As such, these items do not have messages.  Instead, a "generic"
	 * message is generated.
	 */
	public static final int CORE_INTERNAL_BASE = 90000;
	public static final int SIGNING_INTERNAL_MISSING_KEYCHAINSET			= CORE_INTERNAL_BASE + 1;
	public static final int SIGNING_INTERNAL_UNABLE_TO_BUILD_KEYRING_URL	= CORE_INTERNAL_BASE + 2;
	
	/**
	 * This routine returns the message associated with a particular error code
	 * or warning.  If there's a specific text message in the resource bundle,
	 * associated with this code, that one is returned.  Otherwise, a default
	 * message is used.  In either case, the error code is optionally (based
	 * on the string contents) substituted into the message.
	 * 
	 * @param nCode		The error code.
	 * @return
	 */
	
	public static final String getErrorMessage(int nCode)
	{
		String strTemplate;
		
		strTemplate = MtjUIErrorResources.getString(MESSAGE_PREFIX + nCode);
		if (strTemplate == null)
		{
			if (nCode < CORE_INTERNAL_BASE)
			{
				strTemplate = MtjUIErrorResources.getString("MTJCoreError.Default"); //$NON-NLS-1$
			}
			else
			{
				strTemplate = MtjUIErrorResources.getString("MTJCoreError.InternalTemplate"); //$NON-NLS-1$
			}
		}
		
		String strMessage = MessageFormat.format(strTemplate, (Object[])new Integer[] { new Integer(nCode) });
		return(strMessage);
	}
	
	/**
	 * This routine throws a CoreException with a status code of
	 * "ERROR", the specified error code, and a message that is
	 * internationalized.
	 * 
	 * @param code
	 * @throws CoreException
	 */
	public static void throwCoreExceptionError(int code) throws CoreException
	{
		IStatus status = new Status(IStatus.ERROR,
									IMtjCoreConstants.PLUGIN_ID,
									code,
									MtjCoreErrors.getErrorMessage(code),
									null);
		throw new CoreException(status);
	}

	/**
	 * This routine throws a CoreException with a status code of
	 * "ERROR", the specified error code, and a message that is
	 * internationalized.
	 * 
	 * @param code
	 * @throws CoreException
	 */
	public static void throwCoreExceptionError(int code, Throwable e) throws CoreException
	{
		IStatus status = new Status(IStatus.ERROR,
									IMtjCoreConstants.PLUGIN_ID,
									code,
									MtjCoreErrors.getErrorMessage(code),
									e);
		throw new CoreException(status);
	}
}
