/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;

public class LaunchHelper {

	/**
	 * Return Device that is defined in the LaunchConfiguration
	 * 
	 * @param configuration
	 * @return
	 * @throws CoreException
	 */
	public static Device getTargetLaunchDevice(ILaunchConfiguration configuration) throws CoreException {
		
		String devicePlatformName = configuration.getAttribute(ILaunchConstants.EMULATION_PLATFORM_DEF, ""); //$NON-NLS-1$
		String deviceName = configuration.getAttribute(ILaunchConstants.EMULATED_DEVICE, ""); //$NON-NLS-1$
		if (!deviceName.equals("") && !devicePlatformName.equals("")) { //$NON-NLS-1$ //$NON-NLS-2$
			DeviceManagement dm = (DeviceManagement)
				MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
			try {
				return dm.getDevice(devicePlatformName, deviceName);
			} catch (MtjException e) {
				IStatus status = new Status(
						IStatus.ERROR, 
						IEclipseMtjCoreConstants.PLUGIN_ID, 
						MtjCoreErrors.TARGET_DEVICE_ACCESS_ERROR, 
						MtjCoreErrors.getErrorMessage(MtjCoreErrors.TARGET_DEVICE_ACCESS_ERROR), e);
				throw new CoreException(status);
			}
		}
		return null;
	}

	/**
	 * Return Device that is defined in the LaunchConfiguration
	 * 
	 * @param configuration
	 * @return
	 * @throws CoreException
	 */
	public static DevicePlatform getTargetLaunchDevicePlatform(ILaunchConfiguration configuration) throws CoreException {
		String devicePlatformName = configuration.getAttribute(ILaunchConstants.EMULATION_PLATFORM_DEF, ""); //$NON-NLS-1$
		if (!devicePlatformName.equals("")) { //$NON-NLS-1$
			DeviceManagement dm = (DeviceManagement)
				MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
			try {
				return dm.getDevicePlatformByName(devicePlatformName);
			} catch (MtjException e) {
				IStatus status = new Status(
						IStatus.ERROR, 
						IEclipseMtjCoreConstants.PLUGIN_ID, 
						MtjCoreErrors.TARGET_PLATFORM_ACCESS_ERROR, 
						MtjCoreErrors.getErrorMessage(MtjCoreErrors.TARGET_PLATFORM_ACCESS_ERROR), e);
				throw new CoreException(status);
			}
		}
		return null;
	}

	/**
	 * Return Device that is defined in the LaunchConfiguration
	 * 
	 * @param configuration
	 * @return
	 * @throws CoreException
	 */
	public static String getTargetApplication(ILaunchConfiguration configuration) throws CoreException {
		return configuration.getAttribute(ILaunchConstants.EXECUTABLE_CLASS, ""); //$NON-NLS-1$
	}

}
