/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.extension.dm.ui.util.PreferenceUtils;
import org.eclipse.swt.graphics.Image;


public class DevicePlatformListLabelProvider extends LabelProvider implements ITableLabelProvider {

	public Image getImage(Object obj) {
		if(obj instanceof DevicePlatform){
			return MtjCoreUiPlugin.getMtjImageRegistry().get("dpp_icon.gif"); //$NON-NLS-1$
		}
		else if(obj instanceof RuntimePlatformDefinition){
			return MtjCoreUiPlugin.getMtjImageRegistry().get("rpd_icon.gif"); //$NON-NLS-1$
		}
		else if(obj instanceof Device){
			return MtjCoreUiPlugin.getMtjImageRegistry().get("cellphone_icon.gif"); //$NON-NLS-1$
		}
		else if(obj instanceof TargetDevice){
		}
		else if(obj instanceof DeviceProfile){
		}
		else if(obj instanceof DeviceConfiguration){
		}
		else if(obj instanceof ServiceApi){
			return MtjCoreUiPlugin.getMtjImageRegistry().get("api_icon.gif"); //$NON-NLS-1$
		}
		else if(obj instanceof ImplementationRef){
		}
		else if(obj instanceof DevicePlatformProvider){
			return MtjCoreUiPlugin.getMtjImageRegistry().get("dpp_icon.gif"); //$NON-NLS-1$
		}
		return null;
	}

	public String getText(Object element) {

		String label = PreferenceUtils.getObjectName(element);
		if ( label == null ) {
			label = ""; //$NON-NLS-1$
		}
		
		return label;
		
//		if(element instanceof DevicePlatform){
//			
//			DevicePlatform dp = (DevicePlatform)element;
//			
//			StringBuffer sb = new StringBuffer();
//			sb.append(dp.getName());
//			/*sb.append(", version:");
//			sb.append(dp.getVersion());
//			sb.append(", ");
//			sb.append(dp.getVendor());*/
//			
//			label  = sb.toString();
//		}
//		else if(element instanceof Device){
//			
//			Device device = (Device)element; 
//			
//			StringBuffer sb = new StringBuffer();
//			sb.append(device.getName());
//			/*sb.append(", version");
//			sb.append(device.getVersion());
//			sb.append(", ");
//			sb.append(device.getVendor());*/
//			
//			label = sb.toString();
//		}
//		else if(element instanceof RuntimePlatformDefinition){
//			label = ((RuntimePlatformDefinition)element).getName();
//		}
///*		else if(element instanceof DeviceProfile){
//			label = ((DeviceProfile)element).getName();
//		}
//		else if(element instanceof DeviceConfiguration){
//			label = ((DeviceConfiguration)element).toString();
//		}
//		else if(element instanceof ServiceApi){
//			label = ((ServiceApi)element).getName();
//		}*/
//		else{
//			label = element.toString();
//		}
//		
//		return label;
	}
	

	public Image getColumnImage(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getColumnText(Object element, int index) {
		
		if (element instanceof DevicePlatform) {

			DevicePlatform juu = (DevicePlatform) element;
			switch (index) {
			//case 0:
			//return juu.getImportToMtjText();
			case 1:
				return juu.getType().toString();
			case 2:
				return juu.getName();
			case 3:
				return juu.getVersion();
			case 4:
				return juu.getVendor();
			default:
				return new String();
			}
		}
		return null;
	}

}
