/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public class TargetDeviceContentProvider implements ITreeContentProvider {
	
	private Viewer myViewer;
	private Object myInput;
	
	public TargetDeviceContentProvider(Viewer viewer){
		
		myViewer = viewer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {

		Object[] elements = null;
		
		if(inputElement instanceof TargetDevice[]){
			return (TargetDevice[])inputElement;
		}
		else if(inputElement instanceof EList){
			return (TargetDevice[])((EList)inputElement).toArray();
		}
		
		else if(inputElement instanceof TargetDevice){
			
			TargetDevice target = (TargetDevice)inputElement;
			
			elements = new Object[1];
			elements[0] = target.getRuntimePlatform();
		}
		else if(inputElement instanceof RuntimePlatformDefinition){
			
			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition) inputElement;
			
			elements = new Object[3];
			
			elements[0] = rpd.getDeviceProfiles().get(0);
			elements[1] = rpd.getDeviceConfigurations().get(0);
			elements[2] = (ServiceApi[])rpd.getServiceApis().toArray();
		}
		else if(inputElement instanceof DeviceConfiguration){
			
			DeviceConfiguration config = (DeviceConfiguration) inputElement;
			
			elements = new Object[1];
			elements[0] = config.getImplementation();
		}
		else if(inputElement instanceof DeviceProfile){
			
			DeviceProfile profile = (DeviceProfile) inputElement;
			
			elements = new Object[1];
			elements[0] = (ServiceApi[])profile.getServiceApis().toArray();
			
		}
		else if(inputElement instanceof ServiceApi){
			
			ServiceApi sapi = (ServiceApi) inputElement;
			
			elements = new Object[2];
			elements[0] = sapi.getDescription();
			elements[1] = sapi.getImplementation();
		}
		else if(inputElement instanceof ServiceApi[]){
			
			return (ServiceApi[])inputElement;
		}
		else if(inputElement instanceof ImplementationRef){
			
			ImplementationRef ref = (ImplementationRef)inputElement;
			
			elements = new Object[3];
			elements[0] = ref.getFileRef();
			elements[1] = ref.getSourceRef();
			elements[2] = ref.getJavadocRef();
		}
		else{
			elements = new Object[1];
			
			elements[0] = inputElement;
		}

		return elements;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

		myViewer = viewer;
		
		myInput = newInput;

	}
	
	public Object addVariable(Object inputElement, TargetDevice[] devices){
		
		if(inputElement instanceof TargetDevice[]){
			
			TargetDevice[] oldInput = (TargetDevice[])inputElement;
			
			TargetDevice[] newRpInput = new TargetDevice[oldInput.length + devices.length];
			for(int i = 0; i < oldInput.length; i++){
				newRpInput[i] = oldInput[i];
			}
			//for(int i = oldInput.length; i < newRpInput.length; i++){
			for(int i = 0; i < devices.length; i++){
				newRpInput[oldInput.length + i] = devices[i];
			}
			
			myInput = newRpInput;
		}
		else if(inputElement instanceof EList){
			
			EList list = (EList)inputElement;
			
			for(int i = 0; i < devices.length; i++){
				list.add(devices[i]);
			}
			
			TargetDevice[] newTargets = new TargetDevice[list.size()];
			
			myInput = (TargetDevice[])list.toArray(newTargets);
		}
		//Create list if no input
		else if (inputElement == null) {
			
			myInput = devices;
		}
		
		myViewer.setInput(myInput);
		
		return myInput;
	}
	
	public TargetDevice[] removeVariable(Object oldInputElement, TargetDevice selectedDevice){
		
		if(oldInputElement instanceof TargetDevice[]){

			TargetDevice[] oldInput = (TargetDevice[])oldInputElement;
			if(oldInput.length == 1){
				return null;
			}
			
			List list = new ArrayList();
			for(int i = 0; i < oldInput.length; i++){
				if(!oldInput[i].equals(selectedDevice)){
					list.add(oldInput[i]);
				}
			}
			
			TargetDevice[] newInput = new TargetDevice[list.size()];
			
			return (TargetDevice[])list.toArray(newInput);
		}
		else if(oldInputElement instanceof EList){
			
			EList list = (EList)oldInputElement;
			
			if(list.size() == 1){
				return null;
			}
			
			list.remove(selectedDevice);
			return (TargetDevice[]) list.toArray();
		}
		
		return null;
	}

	public Object[] getChildren(Object parentElement) {
		
		List l = new Vector();
		
		if(parentElement instanceof TargetDevice[]){
			
			TargetDevice[] targets = (TargetDevice[])parentElement;
			for(int i = 0; i < targets.length; i++){
				l.add(targets[i]);
			}
		}
		else if(parentElement instanceof TargetDevice){
			TargetDevice target = (TargetDevice)parentElement;
			l.add(target.getRuntimePlatform());
			
		}
		else if(parentElement instanceof RuntimePlatformDefinition){
			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
			l.addAll(rpd.getDeviceConfigurations());
			l.addAll(rpd.getDeviceProfiles());
			l.addAll(rpd.getServiceApis());
		}
		else if(parentElement instanceof DeviceConfiguration){
			DeviceConfiguration config = (DeviceConfiguration)parentElement;
			l.add(config.getImplementation());
		}
		else if(parentElement instanceof DeviceProfile){
			DeviceProfile profile = (DeviceProfile) parentElement;
			l.addAll(profile.getServiceApis());
		}
		else if(parentElement instanceof ServiceApi){
			ServiceApi sapi = (ServiceApi) parentElement;
			l.add(sapi.getDescription());
			l.add(sapi.getImplementation());
		}
		else if(parentElement instanceof ImplementationRef){
			ImplementationRef ref = (ImplementationRef)parentElement;
			//l.add(ref.getFileRef()); //already in parent
			l.add(ref.getSourceRef());
			l.add(ref.getJavadocRef());
		}
		
		return l.toArray();
	}

	public Object getParent(Object element) {
		
		return null;
	}

	public boolean hasChildren(Object parentElement) {
		
		if(parentElement instanceof TargetDevice[]){
			return true;
		}
		else if(parentElement instanceof TargetDevice){
			return true;
		}
		else if(parentElement instanceof RuntimePlatformDefinition){
			return true;
		}
		else if(parentElement instanceof DeviceConfiguration){
			return true;
		}
		else if(parentElement instanceof DeviceProfile){
			return true;
		}
		else if(parentElement instanceof ServiceApi){
			return true;
		}
		else if(parentElement instanceof ImplementationRef){
			
			ImplementationRef ref = (ImplementationRef) parentElement;
			String javadoc = ref.getJavadocRef();
			String source = ref.getSourceRef();
			if(javadoc != null && source != null){
				//check that either one has some content
				if(javadoc.length() > 1 || source.length() > 1){
					return true;
				}
				else{
					return false;
				}
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}
	}

}
