/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.project.javame;

import java.io.File;
import java.io.FilenameFilter;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.api.model.CdcDeployment;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.ui.util.MidletSearchScope;
import org.eclipse.mtj.core.util.CoreUtil;
import org.eclipse.mtj.core.version.Version;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.config.LibrarySpecification;

public class JavaMeProjectExtensionProvider implements ProjectExtensionProvider {

	private static final String DEPLOYMENT_DIRECTORY = "deployed"; //$NON-NLS-1$
	// TODO: How can we get this information.  Ths 
	private static final String LAUNCHABLE_CLASSES_FOLDER = "bin"; //$NON-NLS-1$
	private static final String LAUNCHABLE_LIBS_FOLDER = "lib"; //$NON-NLS-1$
	IMtjProject mtjProject = null;
	
	public ProjectType getProjectType() {
		return ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL;
	}

	public Deployment getDeployment(IMtjProject project, String launchableApplication) throws MtjException {
		mtjProject = project;
		File jar = findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jar"); //$NON-NLS-1$
		if (jar == null ) {
			throw new MtjException(Messages.JavaMeProjectExtensionProvider_JarNotFound);
		}
		
		File[] files = { jar };
		CdcDeployment midletDeployment = (CdcDeployment)
			CoreUtil.createDeployment(files, DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL);
		
		return midletDeployment;
	}

	public Deployment getDeployment(IMtjProject project) throws MtjException {
		return getDeployment (project, null);
	}
	
	private File findFile(IProject project, String folder2, String fileType) {
		String folder = project.getLocation().toString();
		
		final String fType = fileType;
		File f = new File(folder + "/" + folder2); //$NON-NLS-1$
		if ( f.exists() ) {
			String[] files = f.list(new FilenameFilter() {
				public boolean accept(File dir, String name) {
					return name.endsWith("."+fType); //$NON-NLS-1$
				}
			});
			if ( files != null && files.length > 0 ) {
				String fol = folder + "/" + folder2 + "/" + files[0]; //$NON-NLS-1$ //$NON-NLS-2$
				return new File(fol);
			}
		}
		
		return null;
	}
	
	public String getLaunchableClassesFolder(IProgressMonitor monitor) throws CoreException {
		if (mtjProject != null)
			return mtjProject.getClassesOutputFolder(monitor).getName();
		return LAUNCHABLE_CLASSES_FOLDER;
	}

	public String getDeploymentFolder(IProgressMonitor monitor) throws CoreException {
		return DEPLOYMENT_DIRECTORY;
	}

	public String getLaunchableLibsFolder(IProgressMonitor monitor) throws CoreException {
		return LAUNCHABLE_LIBS_FOLDER;
	}

	public class MtjFile extends org.eclipse.core.internal.resources.File {
		public MtjFile(IPath path, Workspace container) {
			super(path, container);
		}
		public IPath getLocation() {
			return getLocalManager().locationFor(this);
		}
	}
	
	/**
	 * Return DeploymentType that the ProjectExtensionProvider is supporting
	 * 
	 * @return
	 * @throws MtjException
	 */
	public DeploymentType getDeploymentType() throws MtjException {
		return DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL;
	}

	/**
	 * Return IJavaSearchScope object for searching classes that support the project's scope
	 * 
	 * @param javaProject
	 * @return
	 * @throws MtjException
	 */
	public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws MtjException {
		try {
			return new MidletSearchScope(javaProject);
		} catch (JavaModelException e) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.PROJECT_EXTENSION_DATA_ERROR), e);
		}
	}
	
	/**
	 * Returns PreverificationPolicy that the project supports
	 * 
	 * @param targetPlatform
	 * @return
	 */
	public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws MtjException {
		return null;
	}

	/**
	 * Method initialized new Java Project project with the extension type -specific features
	 * 
	 * @param javaProject
	 * @throws MtjException
	 */
	public void initializeNewProject(IJavaProject javaProject, IProgressMonitor monitor) throws MtjException {
	}
	
	private String getJarFileName(IJavaProject javaProject) {
		return getProjectNameWithoutSpaces(javaProject) + ".jar"; //$NON-NLS-1$
	}
	
	/**
	 * Get the project name, replacing spaces with underscores.
	 * 
	 * @return
	 */
	private String getProjectNameWithoutSpaces(IJavaProject javaProject)
	{
		String projectName = javaProject.getProject().getName();
//		return projectName.replace(' ', '_');
		return projectName;
	}

	private LibrarySpecification getCorrConfiguration(DeviceConfiguration dc) throws CoreException {
		LibrarySpecification[] lss = MtjDevIdePlugin.getConfigurationSpecifications();
		for (int i = 0; i < lss.length; i++) {
			Version v = new Version(dc.getVersion());
			if ( lss[i].getVersion().equals(v) ) {
				return lss[i];
			}
		}
		return null;
	}
	
	private LibrarySpecification getCorrProfile(DeviceProfile dp) throws CoreException {
		LibrarySpecification[] lss = MtjDevIdePlugin.getProfileSpecifications();
		for (int i = 0; i < lss.length; i++) {
			Version v = new Version(dp.getVersion());
			if ( lss[i].getVersion().equals(v) ) {
				return lss[i];
			}
		}
		return null;
	}
	
}
