/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *    Jani Hautakangas - Fix size problem on Ubuntu Linux
 *******************************************************************************/
package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.SigningDetail;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.api.signings.impl.SigningsFactoryImpl;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.utils.InputValidationDialog;
import org.eclipse.mtj.extension.devide.utils.SmgmtCache;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.mtj.extension.smgmt.ui.SecurityiPlugin;
import org.eclipse.mtj.extension.smgmt.ui.utils.SmgmtUtils;
import org.eclipse.mtj.extension.sp.ui.utils.SpUtils;
import org.eclipse.mtj.jad.util.ConvertNativeToUTF8;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MainDialog extends Dialog {
	
	private Button openButton = null;
	private Button changepwd = null;
	private Button createButton = null;
	private Button deleteButton = null;
	private Button generateButton = null;
	private Button importCertButton = null;
	private Button importCSRButton = null;
	private Button signButton = null;
	private Button unsignButton = null;
	private Button closeButton = null;
	private Button importToRootCert = null;
	private Button removeRootCert = null;
	private Text targetkeystore = null;
	private Text targetalias = null;
	private SigningProvider activeSigningProvider = null;
	private SecurityManagement activeSecurityManagementProvider = null;
	private IMtjProject fMtjProject;
	private Shell fShell = null;
	private List list;
	private Text projectname;
	private Text keystore;	
	private Text keydata;
	private String keyDataValue = ""; //$NON-NLS-1$
	private IProject[] _filteredProjects;
	private Button search = null;

	private String [] certs = null;
	
	private IFolder targetFolder = null;
	private MtjExtension[] signingList;
	private MtjExtension[] securityList;
	
	private String keystorelocfile = ""; //$NON-NLS-1$
	private String keyStorePasswd = ""; //$NON-NLS-1$
	private String[] keyaliases;

	boolean keyCreated;
	private int passlen = 0;
	
	CreateKeyDialog ck = new CreateKeyDialog(fShell);
 
	
	private List list2;
	private List list1;
	private List list3;
	
	private Button addcustom2 = null;
	private Button addcustom1 = null;
	private Button add1 = null;
	private Button add2 = null;
	private Button remove1 = null;
	private Button remove2 = null;
	private Button updateButton = null;
	private Image MTJImage = null;

	private Text LocationText = null;
	
	private final SmgmtCache keystoreCache = SmgmtCache.getSmgmtCache();
	
	/**
	 * MainDialog - Constructor for Security Management / Singing provider main dialog
	 * assigns active signing provider, and security manager for duration of this 
	 * security dialog session.
	 * @param arg0
	 * @param project
	 * @throws MtjException
	 */
	protected MainDialog(Shell arg0, IMtjProject project) throws MtjException {
		super(arg0);
		fMtjProject = project;
		fShell = arg0;
		MTJImage = MtjCoreUiPlugin.getIconImage("cellphone_icon.gif").createImage(); //$NON-NLS-1$
                
		//get all ACTIVE Signing providers
		try {
		signingList = (SigningProvider[])SpUtils.getSigningProvidersList();
		for(int i = 0; i < signingList.length; i++){
			if (((SigningProvider)signingList[i]).isActive()){
				activeSigningProvider = ((SigningProvider)signingList[i]);
				break;
			}
		}
		} catch (MtjNotFoundException e) {
			activeSigningProvider = null;
		}
	
		
		try{
		//Get all ACTIVE Security managers
		securityList = (SecurityManagement[])SmgmtUtils.getSecurityManagementProvidersList();
		
		for(int i = 0; i < securityList.length; i++){	
			if (((SecurityManagement)securityList[i]).isActive()){
				activeSecurityManagementProvider = (SecurityManagement)securityList[i];
				try {
					activeSecurityManagementProvider.setValidity("365");//$NON-NLS-1$
					break;
				} catch (MtjException e1) {}
			}
		}
		} catch (MtjNotFoundException e) {
			activeSecurityManagementProvider = null;
		}
		
		//if no SM and SP throw excption
		if (activeSigningProvider == null && activeSecurityManagementProvider == null){
			throw new MtjException(SecurityManagmentUIMessages.MainDialog_49);
		}
		//if no signing provider is active, warn user
		if (activeSigningProvider == null){
			MessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),SecurityManagmentUIMessages.MainDialog_33, SecurityManagmentUIMessages.MainDialog_34); 
		}
		//if no signing provider is active, warn user
		if (activeSecurityManagementProvider == null){
			MessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),SecurityManagmentUIMessages.MainDialog_35, SecurityManagmentUIMessages.MainDialog_36); 
		}
	}
	

	protected void createButtonsForButtonBar(final Composite parent) {
		        
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		parent.setLayout(gridLayout);
		
		signButton = new Button(parent, SWT.PUSH | SWT.MULTI);
		signButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Image buttonImage = SecurityiPlugin.getImageDescriptor("icons/sign_application_package.png").createImage(); //$NON-NLS-1$
        signButton.setImage(buttonImage);
		signButton.setText(SecurityManagmentUIMessages.BuildsDialog_Sign_3); 
		signButton.setEnabled (false);
		signButton.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {
				try {
					signBTNPressed(parent);
				} catch (CoreException e1) {
					e1.printStackTrace();
				} catch (InvocationTargetException e1) {
					e1.printStackTrace();
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				} catch (MtjException e1) {
					e1.printStackTrace();
				}
			}});
		
		unsignButton = new Button(parent, SWT.PUSH);
		unsignButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL)); 	
		buttonImage = SecurityiPlugin.getImageDescriptor("icons/unsign_application_package-red.png").createImage(); //$NON-NLS-1$
        unsignButton.setImage(buttonImage);
		unsignButton.setText(SecurityManagmentUIMessages.BuildsDialog_2); 
		unsignButton.setEnabled (false);

		if (activeSigningProvider != null && fMtjProject != null){
			//if no keypairs selected, see if we can enable the Unsign button 
			try {
				if (activeSigningProvider.isSigned(fMtjProject, targetFolder, null)){
					unsignButton.setEnabled(true);
				} else {
					unsignButton.setEnabled(false);
				}
			} catch (MtjException e1) {
				unsignButton.setEnabled(false);
			}
		}
		unsignButton.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {
				
				try {
					UnsignBTNPressed(parent);
				} 
				catch (CoreException e1) {				
					e1.printStackTrace();
				} catch (IOException e1) {				
					e1.printStackTrace();
				} 
				catch (Exception e1) {
					DisplayMessage(parent,
							SecurityManagmentUIMessages.BuildsDialog_7, 
							SecurityManagmentUIMessages.BuildsDialog_8, 
							MessageDialog.ERROR, 
							new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 });
				}
			}});
		
		
		closeButton = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.CLOSE_LABEL, true);
		closeButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		closeButton.setFocus();
	}
	
	/** createDialogArea - Generates the UI for the main Security Dialog
	 * Includes three tabs, three dialog buttons, and a project selection widget.
	 * 
	 **/
	protected Control createDialogArea(final Composite parent) {
		
		
		String title = SecurityManagmentUIMessages.MidpSecurity_Title; 
		parent.getShell().setText(title);
		
		parent.getShell().setImage(MTJImage);
		new Label(parent, SWT.NONE); // spacer
		
		Composite c1 =	new Composite(parent, SWT.NONE);
		GridLayout c1gridLayout = new GridLayout();
		c1gridLayout.numColumns = 4;
		c1gridLayout.makeColumnsEqualWidth = true;
		c1.setLayout(c1gridLayout);
		
		Label label1 = new Label(c1, SWT.NONE);
		String ptitle = SecurityManagmentUIMessages.MidpSecurity_ProjectTitle; 
		label1.setText(ptitle);
		projectname = new Text(c1, SWT.READ_ONLY | SWT.SINGLE | SWT.BORDER);
		GridData pname = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		pname.horizontalSpan = 2;
		projectname.setLayoutData(pname);
		
		Button browse =  new Button(c1, SWT.PUSH);
		browse.setLayoutData(new GridData());
		browse.setText(SecurityManagmentUIMessages.MainDialog_Browse____4); 
		if (activeSigningProvider == null)
		{
			browse.setEnabled(false);
		}
		browse.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				try {

					//Browse button displays the "filtered projects" dialog
					//returns the chosen project, could be null
					fMtjProject = browse();
					
					if (fMtjProject != null) {
						
						updatePermListsandButtons();
						
						projectname.setText(fMtjProject.getJavaProject().getElementName());
										
						targetFolder = fMtjProject.getDeploymentFolder(null);
											
						if (activeSigningProvider != null){
							boolean isSigned = activeSigningProvider.isSigned(fMtjProject, targetFolder, null);
							
							// if a keystore is already open, and we have a signign provider,
							// then enable the Sign App button
							if (list != null) {
								if (GetListSelection(list).length() > 0) {
										if (isSigned){
											signButton.setEnabled(false);
											unsignButton.setEnabled(true);
										} else {
											signButton.setEnabled(true);
											unsignButton.setEnabled(false);
										}

								} else {
									signButton.setEnabled(false);
									// if no keypairs selected, see if we can enable the Unsign button 
									if (isSigned){
										unsignButton.setEnabled(true);
									} else {
										unsignButton.setEnabled(false);
									}
								}
							} 							
						}//if (activeSigningProvider != null)
					}	
				} catch (MtjException e1) {
					e1.printStackTrace();
				} catch (CoreException e1) { 
					e1.printStackTrace();
				} 				
			}
		});		
		
		new Label(parent, SWT.NONE); // spacer
		
		TabFolder tabFolder = new TabFolder(parent, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.minimumWidth = 400;
		gd.minimumHeight = 400;
		
		tabFolder.setLayoutData(gd);

		{
			//Security manager provider tab:
			TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
			String KeyMgtitle = SecurityManagmentUIMessages.MidpSecurity_KeyManageTitle; 
			tabItem.setText(KeyMgtitle);
			{
				Composite cd =	new Composite(tabFolder, SWT.NONE);
				GridLayout gridLayout = new GridLayout();
				gridLayout.numColumns = 3;
				gridLayout.makeColumnsEqualWidth = true;
				cd.setLayout(gridLayout);
				
				tabItem.setControl(cd);
				
				GridData griddata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_BEGINNING);
				griddata.horizontalSpan = 1;
				
				Group grp1 = new Group(cd, SWT.None);
				GridLayout gl1 = new GridLayout();
				gl1.numColumns = 2;
				gl1.makeColumnsEqualWidth = true;
				grp1.setLayout(gl1);
				String KeyStoretitle = SecurityManagmentUIMessages.MidpSecurity_KeyStoreTitle; 
				grp1.setText(KeyStoretitle);
				
				griddata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL);
				griddata.horizontalSpan = 3;
				grp1.setLayoutData(griddata);

				Composite storepicandtext =	new Composite(grp1, SWT.NONE);
				GridLayout gridLayoutstorepicandtext = new GridLayout();
				gridLayoutstorepicandtext.numColumns = 2;
				
				griddata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL);
				griddata.horizontalSpan = 2;
				
				storepicandtext.setLayoutData(griddata);
				
				storepicandtext.setLayout(gridLayoutstorepicandtext);
				
				Label picture = new Label(storepicandtext, SWT.NONE);
		        Image image = SecurityiPlugin.getImageDescriptor("icons/keystore.png").createImage(); //$NON-NLS-1$
		        picture.setImage(image);

				Label Store = new Label(storepicandtext, SWT.NONE);
				String keyLocation = SecurityManagmentUIMessages.MidpSecurity_Location; 
				Store.setText(keyLocation);

				keystore = new Text(grp1, SWT.READ_ONLY | SWT.SINGLE | SWT.BORDER);
				GridData keyloc = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
				keyloc.horizontalSpan = 2;
				keystore.setLayoutData(keyloc);
				
				openButton = new Button(grp1, SWT.PUSH);
				openButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL)); 
				String OpenKeyStoretitle = SecurityManagmentUIMessages.MidpSecurity_OpenKeyStoreTitle; 
				openButton.setText(OpenKeyStoretitle);
				if (activeSecurityManagementProvider == null){
					openButton.setEnabled(false);
				}
				openButton.addSelectionListener(new SelectionAdapter (){
					public void widgetSelected(SelectionEvent e) {
						OpenKeyStore(parent);
					}});
				
				changepwd = new Button(grp1, SWT.PUSH);
				changepwd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				String pChangeKeyStorePassword = SecurityManagmentUIMessages.MidpSecurity_ChangeKeyStorePassword; 
				changepwd.setText(pChangeKeyStorePassword);
				changepwd.setEnabled(false);
				changepwd.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						ChangePassword(parent);
					}});
				
				Group grp2 = new Group(cd, SWT.None);
				GridLayout gl2 = new GridLayout();
				gl2.numColumns = 2;
				gl2.makeColumnsEqualWidth = true;
				grp2.setLayout(gl2);				
				grp2.setText("");  //$NON-NLS-1$
				griddata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL);
				griddata.horizontalSpan = 3;
				grp2.setLayoutData(griddata);
				
				Label aliases = new Label(grp2, SWT.NONE);
				aliases.setText(SecurityManagmentUIMessages.MainDialog_Key_Aliases__7); 
				aliases.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				
				new Label(grp2, SWT.NONE); // spacer
				
				list = new List(grp2, SWT.BORDER | SWT.V_SCROLL | SWT.SINGLE);
				list.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						deleteButton.setEnabled(true);
						generateButton.setEnabled(true);
						importCSRButton.setEnabled(true);
						String alias = GetListSelection(list);
						if (targetalias != null) {
							targetalias.setText(alias);
						}
						
						updateImportButton();
							
						try {
							activeSecurityManagementProvider.setAliaskey(alias);
							updateKeyData();
						} catch (MtjException e2) {
							e2.printStackTrace();
						}
						
						if (fMtjProject != null	&& activeSigningProvider != null) {
							try {
								if (activeSigningProvider.isSigned(fMtjProject, null,	null)) {
									signButton.setEnabled(false);
									unsignButton.setEnabled(true);
								} else {
									signButton.setEnabled(true);
									unsignButton.setEnabled(false);
								}
							} catch (MtjException e1) {
								e1.printStackTrace();
							}
						}
					}
				});
				
				GridData mt = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
				mt.horizontalSpan = 1;
				mt.heightHint = 150;
				list.setLayoutData(mt);
				
				Composite cf5 = new Composite(grp2, SWT.NONE);
				GridLayout test3 = new GridLayout();
				cf5.setLayout(test3);
				cf5.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END | GridData.VERTICAL_ALIGN_BEGINNING));
				
				createButton = new Button(cf5, SWT.PUSH);
				createButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				createButton.setText(SecurityManagmentUIMessages.MainDialog__Create_a_New_Key_Pair_8); 
				if (activeSecurityManagementProvider == null){
					createButton.setEnabled(false);
				}
				createButton.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						try {
							if ((activeSecurityManagementProvider.getKeyStoreNameLoc() == null) || (activeSecurityManagementProvider.getKeyStoreNameLoc().length()<= 0)) {
								CreateNewKeyStore(parent);
							} else {
								CreateNewKeyPair(parent);
							}
						} catch (MtjException e1) {
							e1.printStackTrace();
						}
					}});
				
				deleteButton = new Button(cf5, SWT.PUSH);
				deleteButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				deleteButton.setText(SecurityManagmentUIMessages.MainDialog__Delete_a_Key_Pair_9); 
				deleteButton.setEnabled(false);
				
				deleteButton.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						DeleteKey(parent);
						generateButton.setEnabled(false);
						importCSRButton.setEnabled(false);
					}});
				
				generateButton = new Button(cf5, SWT.PUSH);
				generateButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				generateButton.setText(SecurityManagmentUIMessages.MainDialog__Generate_CSR_10); 
				generateButton.setEnabled(false);
				generateButton.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						GenerateCSR(parent);
					}});
				
				importCertButton = new Button(cf5, SWT.PUSH);
				importCertButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				importCertButton.setText(SecurityManagmentUIMessages.MainDialog_Import_Certificate_1); 
				importCertButton.setEnabled(false);
				importCertButton.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						ImportSignedCertificate(parent,true);
					}});
				
				
				importCSRButton = new Button(cf5, SWT.PUSH);
				importCSRButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				importCSRButton.setText(SecurityManagmentUIMessages.MainDialog__Import_a_Signed_Certificate_11); 
				importCSRButton.setEnabled(false);
				importCSRButton.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						ImportSignedCertificate(parent, false);					
					}});
				
				//Fields for displaying key data
				Label Keydata = new Label(grp2, SWT.NONE);
				Keydata.setText(SecurityManagmentUIMessages.MidpSecurity_KeyDataValue); 
				new Label(grp2, SWT.NONE); // spacer
				
				keydata = new Text(grp2, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL | SWT.BORDER);
				GridData keydataloc = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
				keydataloc.horizontalSpan = 2;
				keydataloc.heightHint = 40;
				keydata.setLayoutData(keydataloc);
				keydata.setText(keyDataValue);
			}
		}
		{
			// Permissions tab:
			TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
			tabItem.setText(SecurityManagmentUIMessages.MainDialog_Permissions_18); 
			{
				Composite cf = new Composite(tabFolder, SWT.NONE);
				
				GridLayout gridLayout = new GridLayout();
				gridLayout.numColumns = 1;
				cf.setLayout(gridLayout);
				tabItem.setControl(cf);
				
				Group g1 = new Group(cf, SWT.NONE);
				GridLayout hg = new GridLayout();
				hg.numColumns = 4;
				hg.makeColumnsEqualWidth = true;
				hg.marginHeight = 10;
				g1.setLayout(hg);
				g1.setText(SecurityManagmentUIMessages.MainDialog_Critical_MIDlet_Permissions_19); 
				g1.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
				
				list1 = new List(g1, SWT.BORDER  | SWT.V_SCROLL | SWT.SINGLE);
				GridData tr = new GridData(GridData.FILL_BOTH);
				tr.heightHint = 100;
				tr.horizontalSpan = 3;
				list1.setLayoutData(tr);
				list1.addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e) {
					remove1.setEnabled(true);
				}});
				
				Composite cf1 = new Composite(g1, SWT.NONE);
				GridLayout test = new GridLayout();
				cf1.setLayout(test);
				cf1.setLayoutData(new GridData(GridData.FILL_BOTH));

				add1 = new Button(cf1, SWT.PUSH | SWT.CENTER);
				add1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				add1.setText(SecurityManagmentUIMessages.MainDialog__Add____20); 
				add1.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					TreeDialog permissiontree = new TreeDialog(parent.getShell());
					if (permissiontree.open() == Window.OK ){
						String sel1 = permissiontree.ValueSelected();
						AddPermissionToList(parent, list1, sel1);
					}
				}});

				addcustom1 = new Button(cf1, SWT.PUSH);
				addcustom1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				addcustom1.setText(SecurityManagmentUIMessages.MainDialog_Add__Custom_21); 
				addcustom1.addSelectionListener(new SelectionAdapter (){
					public void widgetSelected(SelectionEvent e) {
						String value1 = CustomDialog(parent.getShell());
						if (value1 != null) {
							AddPermissionToList(parent, list1, value1);
						}

				}});

				remove1 = new Button(cf1, SWT.PUSH);
				remove1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				remove1.setText(SecurityManagmentUIMessages.MainDialog__Remove_22); 
				remove1.setEnabled(false);
				remove1.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							int select1 = list1.getSelectionIndex();
							list1.remove(select1);
							updateButton.setEnabled(true);
							if ((list1.getItemCount() == 0)){
								remove1.setEnabled(false);
							}
							else{
								list1.select(0);
								remove1.setEnabled(true);
							}
						}
					});
				
				Group g2 = new Group(cf, SWT.NONE);
				GridLayout hg2 = new GridLayout();
				hg2.numColumns = 4;
				hg2.makeColumnsEqualWidth = true;
				hg2.marginHeight = 10;
				g2.setLayout(hg2);
				g2.setText(SecurityManagmentUIMessages.MainDialog_Optional_MIDlet_Permissions_23); 
				g2.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
				
				new Label(cf, SWT.NONE); // spacer
				
				updateButton = new Button(cf, SWT.PUSH);
				updateButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
				updateButton.setText(SecurityManagmentUIMessages.MainDialog__Update_the_MIDP_Application_24); 
				updateButton.setEnabled(false);
				updateButton.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							
						if (fMtjProject == null){
							DisplayMessage(	parent,
											SecurityManagmentUIMessages.MainDialog_Project_25, 
											SecurityManagmentUIMessages.MainDialog_Please_select_a_MIDP_2_0_Project_first_and_then_click_on_Update_the_MIDP_Application_button__26, 
											MessageDialog.ERROR,
											new String [] {SecurityManagmentUIMessages.MainDialog_OK_27});  

						}else{
							IFile JadFile = null;
							try {
								JadFile = getProjectjadIFile(fMtjProject);
							} catch (MtjException e1) {
								e1.printStackTrace();
							}
							
							try {
								if (JadFile != null){
									WritePermissions(JadFile);
									
									updateButton.setEnabled(false);
									DisplayMessage(	parent,
													SecurityManagmentUIMessages.MainDialog_MIDP_2_0_Project_Updated_4, 
													SecurityManagmentUIMessages.MainDialog_Your_MIDP2_0_application_project_has_been_updated_5, 
													MessageDialog.INFORMATION,
													new String [] {SecurityManagmentUIMessages.MainDialog_OK_27});  
									
								} else {
									DisplayMessage(	parent,
													SecurityManagmentUIMessages.MainDialog_37, 
													SecurityManagmentUIMessages.MainDialog_38, 
													MessageDialog.ERROR,
													new String [] {SecurityManagmentUIMessages.MainDialog_OK_27}); 
								}
							} catch (CoreException e3) {
								e3.printStackTrace();
							} catch (IOException e3) {
								e3.printStackTrace();
							}
							
						}
				}});

				list2 = new List(g2, SWT.BORDER | SWT.V_SCROLL | SWT.SINGLE);
				GridData tr2 = new GridData(GridData.FILL_BOTH);
				tr2.heightHint = 100;
				tr2.horizontalSpan = 3;
				list2.setLayoutData(tr2);
				list2.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
						remove2.setEnabled(true);
						}
				});
				
				Composite cf3 = new Composite(g2, SWT.NONE);
				GridLayout test2 = new GridLayout();
				cf3.setLayout(test2);
				cf3.setLayoutData(new GridData(GridData.FILL_BOTH));
				
				add2 = new Button(cf3, SWT.PUSH | SWT.CENTER);
				add2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				add2.setText(SecurityManagmentUIMessages.MainDialog_A_dd____54); 
				add2.addSelectionListener(new SelectionAdapter (){
					public void widgetSelected(SelectionEvent e) {
					TreeDialog permissiontree2 = new TreeDialog(parent.getShell());
					if (permissiontree2.open() == Window.OK ){
						String sel2 = permissiontree2.ValueSelected();
						AddPermissionToList(parent, list2, sel2);
					}		
				}});

				addcustom2 = new Button(cf3, SWT.PUSH);
				addcustom2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				addcustom2.setText(SecurityManagmentUIMessages.MainDialog_Add_Cus_tom_55); 
				addcustom2.addSelectionListener(new SelectionAdapter (){
				public void widgetSelected(SelectionEvent e) {
					String value2 = CustomDialog(parent.getShell());
					if (value2 != null) {
						AddPermissionToList(parent, list2, value2);
					}
				}});
				
				remove2 = new Button(cf3, SWT.PUSH);
				remove2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
				remove2.setText(SecurityManagmentUIMessages.MainDialog_Remo_ve_56); 
				remove2.setEnabled(false);
				remove2.addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						int select2 = list2.getSelectionIndex();
						list2.remove(select2);
						updateButton.setEnabled(true);
						if ((list2.getItemCount() == 0)){
							remove2.setEnabled(false);
						}
						else{
							list2.select(0);
							remove2.setEnabled(true);
						}
					}
				});
			}
		}
		{
			// Root Certificate Manager tab:
			TabItem tabItem3 = new TabItem(tabFolder, SWT.NONE);
			tabItem3.setText(SecurityManagmentUIMessages.MainDialog_39); 
			
			try {
					Composite cf = new Composite(tabFolder, SWT.NONE);
					
					GridLayout gridLayout = new GridLayout();
					gridLayout.numColumns = 1;
					cf.setLayout(gridLayout);
					tabItem3.setControl(cf);
									
					Group g1 = new Group(cf, SWT.NONE);
					GridLayout hg = new GridLayout();
					hg.numColumns = 4;
					hg.makeColumnsEqualWidth = true;
					hg.marginHeight = 10;
					g1.setLayout(hg);
					g1.setText(SecurityManagmentUIMessages.MainDialog_40);
					g1.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));

					GridData gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 3;
					LocationText = new Text(g1, SWT.SINGLE | SWT.BORDER);
					LocationText.setLayoutData(gd3);
					LocationText.setEnabled(false);

					LocationText.addModifyListener(new ModifyListener() {
						public void modifyText(ModifyEvent e) {	
						}
					});
					
					gd3 = new GridData(GridData.FILL_BOTH);
					search = new Button(g1,SWT.PUSH);
					search.setLayoutData(gd3);
					search.setText(SecurityManagmentUIMessages.MainDialog_41);
					if (activeSigningProvider == null){
						search.setEnabled(false);
					} else if (!activeSigningProvider.isRootCertToolAvailable()){
						search.setEnabled(false);
					}
					search.addSelectionListener(new SelectionAdapter (){
						public void widgetSelected(SelectionEvent e) {

							FileDialog newSecurityLocation = new FileDialog(getShell());
						
							newSecurityLocation.setFilterPath(LocationText.getText());

							newSecurityLocation.setText(SecurityManagmentUIMessages.MainDialog_42);
						
							String newSecurityLoc = newSecurityLocation.open();
							if (newSecurityLoc != null)
							{
								LocationText.setText(""); //$NON-NLS-1$
								try {
									removeRootCert.setEnabled(false);
									list3.removeAll();
									certs = activeSigningProvider.listrootcert(newSecurityLoc);
									if (certs != null && certs.length > 0) {
										LocationText.setText(newSecurityLoc);
										list3.setItems(certs);
									} 
									updateImportButton();
								
								} catch (MtjException e1) {
									updateImportButton();
									ErrorDialog.openError (	fShell	
											, SecurityManagmentUIMessages.MainDialog_44
											, SecurityManagmentUIMessages.MainDialog_45
											, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e1.toString(), e1)
											);
								}
							}
						}		
					});
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 4;
					Label targetRootCertContentLabel = new Label(g1, SWT.NONE);
					targetRootCertContentLabel.setText(SecurityManagmentUIMessages.MainDialog_Root_Certificate_Contents);
					targetRootCertContentLabel.setLayoutData(gd3);
					
					list3 = new List(g1, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.SINGLE);
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.heightHint = 100;
					gd3.horizontalSpan = 4;
					list3.setLayoutData(gd3);
					list3.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							removeRootCert.setEnabled(true);
						}});
					
					removeRootCert = new Button(g1,SWT.PUSH);
					removeRootCert.setLayoutData(new GridData(GridData.FILL_BOTH));
					removeRootCert.setText(SecurityManagmentUIMessages.MainDialog_46);
					removeRootCert.setEnabled(false);
					removeRootCert.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							try {
								activeSigningProvider.removeCertFromRoot(LocationText.getText() , list3.getSelectionIndex()+1);
							} catch (MtjException e1) {
								ErrorDialog.openError (	fShell	
										, SecurityManagmentUIMessages.MainDialog_47
										, SecurityManagmentUIMessages.MainDialog_48
										, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e1.toString(), e1)
										);
							}
							try {
								certs = activeSigningProvider.listrootcert(LocationText.getText());
							} catch (MtjException e1) {
								e1.printStackTrace();
							}
							list3.removeAll();
							list3.setItems(certs);
							updateImportButton();
						}});
					
					Group g2 = new Group(cf, SWT.NONE);
					GridLayout hg2 = new GridLayout();
					hg2.numColumns = 4;
					hg2.makeColumnsEqualWidth = true;
					hg2.marginHeight = 10;
					g2.setLayout(hg2);
					g2.setText(SecurityManagmentUIMessages.MainDialog_43);
					g2.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL));
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 1;
					
					Label targetkeystorelabel = new Label(g2, SWT.NONE);
					targetkeystorelabel.setText(SecurityManagmentUIMessages.MainDialog_Source_Keystore);
					targetkeystorelabel.setLayoutData(gd3);
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 3;
					
					targetkeystore = new Text(g2, SWT.SINGLE | SWT.BORDER);
					targetkeystore.setText(keystore.getText());
					targetkeystore.setEnabled(false);
					targetkeystore.setLayoutData(gd3);
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 1;
					
					Label targetalialabel = new Label(g2, SWT.NONE);
					targetalialabel.setText(SecurityManagmentUIMessages.MainDialog_Alias_to_import);
					targetalialabel.setLayoutData(gd3);
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 3;
					
					targetalias = new Text(g2, SWT.SINGLE | SWT.BORDER);
					targetalias.setEnabled(false);
					targetalias.setLayoutData(gd3);
					
					new Label(g2, SWT.NONE);
					
					gd3 = new GridData(GridData.FILL_BOTH);
					gd3.horizontalSpan = 3;
					
					importToRootCert = new Button(g2,SWT.PUSH);
					importToRootCert.setLayoutData(gd3);
					importToRootCert.setText(SecurityManagmentUIMessages.MainDialog_Import_Root_certificate);
					importToRootCert.setEnabled(false);
					importToRootCert.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
					
							//If importing to root cert is attempted, 
							//should disable the import button
							importToRootCert.setEnabled(false);
							try {
									activeSigningProvider.importToRootCert(LocationText.getText(), targetkeystore.getText(),targetalias.getText(),keyStorePasswd );
									certs = activeSigningProvider.listrootcert(LocationText.getText());
									list3.removeAll();
									list3.setItems(certs);
								} catch (MtjException e1) {
									ErrorDialog.openError (	fShell	
											, SecurityManagmentUIMessages.MainDialog_18
											, SecurityManagmentUIMessages.MainDialog_19
											, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e1.toString(), e1)
											);
								}	
						}});
			
			}//exception from activeSigningProvider.isRootCertToolAvailable() call
			 //do not display the root cert tab.
			catch (MtjException e1) {
				tabItem3.dispose();
			}
		}
				
		if (fMtjProject == null){
			//target project was not set, display empty project name
			projectname.setText(""); 	//$NON-NLS-1$	
			
			add1.setEnabled(false);
			addcustom1.setEnabled(false);
			add2.setEnabled(false);
			addcustom2.setEnabled(false);
			updateButton.setEnabled(false);
		}
		else
		{	//target project was set, display project name
			projectname.setText(fMtjProject.getJavaProject().getElementName());

			updatePermListsandButtons();
			
			try 
			{	//now get target deployment folder
				targetFolder = fMtjProject.getDeploymentFolder(null);
			}
			catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return parent;
	}
	
	
	protected void updateImportButton() {
		importToRootCert.setEnabled((list3 != null && list3.getItemCount() > 0) && (targetalias.getText() != null && targetalias.getText().length() > 0));
	}


	/**
	 * GetListSelection() - Alias key list current selection.
	 * @param list - the list from which the current selection is to be retrieved.
	 * @return - The string value of the current selected item in the list.
	 */
	protected String GetListSelection(List list){
		String itemSelected = ""; //$NON-NLS-1$
		
		int selection = list.getSelectionIndex();
		if (selection >=0) {
			itemSelected = list.getItem(selection);
		} 
		
		return itemSelected;
	}
	
	
	/**
	 * signBTNPressed() - process the "sign" button was pressed action
	 * @param parent composite
	 * @return - void
	 */
	protected void signBTNPressed(Composite parent) throws CoreException, InvocationTargetException, InterruptedException, MtjException {
		
		if ((activeSecurityManagementProvider.isKeyStoreSelected())) {
			activeSecurityManagementProvider.setAliaskey(GetListSelection(list));
			
			//This operation can be lengthy, need a progressmonitor
			//Kick off the signing
			new ProgressMonitorDialog(fShell).run(false, false, getSignMidletRunnable());
						
		} else {
			//inform user keystore must be selected
			DisplayMessage(
					parent,
					SecurityManagmentUIMessages.MainDialog_Error_15, 
					SecurityManagmentUIMessages.MainDialog_Please_open_a_Keystore_and_select_a_Key_Alias__16,
					MessageDialog.ERROR, new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 });
		}
	}
	
	/**
	 * ImportSignedCertificate - Logic for requesting, and handling an ImportSignedCertificate request
	 * @param parent
	 * @param show
	 */
	protected void ImportSignedCertificate(Composite parent, boolean show){
		Shell fShell = parent.getShell();
		FileDialog dialog = new FileDialog(fShell,SWT.OPEN);
		dialog.setText(SecurityManagmentUIMessages.MainDialog_Import_Certificate_12); 
		String CSRname = dialog.open();
		if (CSRname != null){
			try{
				if (show == true){
					InputDialog getAlias = new InputDialog(fShell, SecurityManagmentUIMessages.MainDialog_Enter_Alias_2, SecurityManagmentUIMessages.MainDialog_Please_enter_an_alias_for_the_importing_certificate__3, null, null); 
					getAlias.open();
					if (getAlias.getReturnCode() == OK){
						String prevSel = GetListSelection(list); //save the previous selection
						activeSecurityManagementProvider.setAliaskey(getAlias.getValue());
						if (activeSecurityManagementProvider.importSignedCert( CSRname, new NullProgressMonitor())) {
							list.add(getAlias.getValue());
							list.setSelection(list.getItemCount()- 1);						
						}
						else {
							activeSecurityManagementProvider.setAliaskey(prevSel);
						}
						updateKeyData( );
					}
				}
				else {
					activeSecurityManagementProvider.setAliaskey(GetListSelection(list));
					activeSecurityManagementProvider.importSignedCert( CSRname, new NullProgressMonitor());
					updateKeyData( );
				}
			}
			catch (MtjException e) {
				ErrorDialog.openError (	fShell	
						, SecurityManagmentUIMessages.MainDialog_18
						, SecurityManagmentUIMessages.MainDialog_19
						, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
						);
			}
		}//try
	}
	
	
	/**
	 * GenerateCSR - Logic for requesting and handling a GenerateCSR request.
	 * @param parent
	 */
	protected void GenerateCSR(Composite parent){
		Shell fShell = parent.getShell();
		FileDialog dialog = new FileDialog(fShell,SWT.SAVE);
		dialog.setText(SecurityManagmentUIMessages.MainDialog_Generate_Certificate_8); 
		String certFileloc = dialog.open();
		if 	(certFileloc != null){					
			try {
				activeSecurityManagementProvider.setAliaskey(GetListSelection(list));
				activeSecurityManagementProvider.generateCSR( certFileloc, new NullProgressMonitor());
			} catch (MtjException e) {
				ErrorDialog.openError (	fShell	
						, SecurityManagmentUIMessages.MainDialog_20
						, SecurityManagmentUIMessages.MainDialog_21
						, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
						);
			}
		}
	}
	
	/**
	 * DeleteKey - deletes the selected key
	 * @param parent
	 */
	protected void DeleteKey(Composite parent){
		String key = GetListSelection(list);
		try{
			activeSecurityManagementProvider.setAliaskey(key);
		
		if(activeSecurityManagementProvider.deleteKey(new NullProgressMonitor())){
			list.remove(key);
			deleteButton.setEnabled(false);
			activeSecurityManagementProvider.setAliaskey(""); //$NON-NLS-1$
			updateKeyData(); // reset keyalias value being displayed for key just deleted
			DisplayMessage(	parent,
					SecurityManagmentUIMessages.MainDialog_Delete_Key_11, 
					SecurityManagmentUIMessages.MainDialog_The_selected_key_alias_was_deleted_successfully__12, 
					MessageDialog.INFORMATION,
					new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
		}
		} catch (MtjException e) {
			ErrorDialog.openError (	fShell	
					,SecurityManagmentUIMessages.MainDialog_14
					, SecurityManagmentUIMessages.MainDialog_15
					, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
					);
		}
	}
	
	/**
	 * ChangePassword - promps user for new password
	 * 					and requests a password change for the chosen keystore
	 * @param parent
	 */
	protected void ChangePassword(Composite parent){
		passlen = 6;
		InputValidationDialog promptChangePassword = new InputValidationDialog(fShell,SecurityManagmentUIMessages.MainDialog_Change_Password_13,SecurityManagmentUIMessages.MainDialog_Please_enter_old_password__14, SecurityManagmentUIMessages.MainDialog_Please_enter_new_password__15, SecurityManagmentUIMessages.MainDialog_Please_confirm_password__16, new oldPasswordLengthValidator(), new newPasswordLengthValidator(), new newPasswordLengthValidator()); 
		if (promptChangePassword.open() == Window.OK ){ 
			//matching passwords??
			if(promptChangePassword.getPass1().compareTo(promptChangePassword.getPass2())==0) {
				try {
					//make the password change request
					if(activeSecurityManagementProvider.changeStorePassword(promptChangePassword.getPass1(), promptChangePassword.getPass(), new NullProgressMonitor())) {
						//password change request succeeded, set the password variable
						activeSecurityManagementProvider.setPassWrd(promptChangePassword.getPass1());
						if(keystoreCache.lookupSigningCertificate(activeSecurityManagementProvider.getKeyStoreNameLoc())){
							keystoreCache.unCacheSigningCertificate(activeSecurityManagementProvider.getKeyStoreNameLoc());
							keystoreCache.cacheSigningCertificate(createTargetSigningCertificate());
						}
						//display success dialog
						DisplayMessage(	parent,
								SecurityManagmentUIMessages.MainDialog_Change_Password_18, 
								SecurityManagmentUIMessages.MainDialog_The_keystore_password_had_been_changed_successfully__19, 
								MessageDialog.INFORMATION,
								new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
					}
				} catch (MtjException e) {
					ErrorDialog.openError (	fShell	
							,SecurityManagmentUIMessages.MainDialog_16
							, SecurityManagmentUIMessages.MainDialog_17
							, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
							);
					
					e.printStackTrace();
				}
			}
			else{
				//password mismatch
				DisplayMessage(	parent,
						SecurityManagmentUIMessages.MainDialog_Passwords_20, 
						SecurityManagmentUIMessages.MainDialog_The_new_password_and_the_confirm_password_entries_were_inconsistent__The_password_was_not_changed__21, 
						MessageDialog.ERROR,
						new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
			}
		}
	}
	
	/**
	 * OpenKeyStore - Opens the keystore, method called in response to Open button click
	 * It provides a browse dialog to choose a file (keystore) and then prompts for password.
	 * Saves the new keystore location and name, password if it is a valid input by user and
	 * updates the list box with the alias keys.
	 * @param parent
	 */
	protected void OpenKeyStore(Composite parent){
		Shell fShell = parent.getShell();
		FileDialog dialog = new FileDialog(fShell,SWT.OPEN);
		dialog.setText(SecurityManagmentUIMessages.MainDialog_Open_Keystore_6); 
		keystorelocfile = dialog.open();
		
		if ((keystorelocfile != null)&&(keystorelocfile.trim().length() > 0)){
			passlen = 1;

			keyStorePasswd = null;
			
			//see if this keystore has been previously accessed during this session
			if(keystoreCache.lookupSigningCertificate(keystorelocfile)){
				keyStorePasswd = keystoreCache.getSigningCertificate(keystorelocfile).getKeystorePassword();
				keyaliases = null;
			} else {
				InputValidationDialog promptPassword = new InputValidationDialog(fShell,SecurityManagmentUIMessages.MainDialog_Enter_Password_22,SecurityManagmentUIMessages.MainDialog_Please_enter_keystore_password__23, null, null, new oldPasswordLengthValidator(), null, null); 
				promptPassword.open();
				if (promptPassword.getReturnCode() == OK){
					keyStorePasswd = promptPassword.getPass();
					keyaliases = null;
				}
			}
			
			if (keyStorePasswd != null ){
				try {
						new ProgressMonitorDialog(fShell).run(false, false, getOpenKeyRunnable());
										
					if (keyaliases != null){
						activeSecurityManagementProvider.setKeyStoreNameLoc(keystorelocfile);
						activeSecurityManagementProvider.setPassWrd(keyStorePasswd); //Sri! 122891
						keystore.setText(keystorelocfile);
						if (targetkeystore != null) {
							targetkeystore.setText(keystorelocfile);
						}
						
						keystoreCache.cacheSigningCertificate(createTargetSigningCertificate());
						keystoreCache.lookupSigningCertificate(keystorelocfile);
						
						RefreshList(keyaliases);
						changepwd.setEnabled(true);
						importCertButton.setEnabled(true);
						activeSecurityManagementProvider.setAliaskey(""); //$NON-NLS-1$
						updateKeyData(); //update the alias key display info since there is no key selection yet
					}//if keyaliases
				} catch (InvocationTargetException e) {
					e.printStackTrace();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}catch (MtjException e) {
					e.printStackTrace();
				}//TRY
			}//if promptPassword
		}
	}//OpenKeyStore(...)
	
	
	
	/**
	 * CreateNewKeyStore logic for requesting an handling a create new keystore
	 * @param parent
	 */
	protected void CreateNewKeyStore(Composite parent){
		keyCreated = false;
		FileDialog newKeyStore = new FileDialog(fShell,SWT.SAVE);
		newKeyStore.setText(SecurityManagmentUIMessages.MainDialog_New_Keystore_25); 
		String keyStoreLocFile = newKeyStore.open();
		if 	(keyStoreLocFile != null){
			try {
				File testing = new File(keyStoreLocFile);
				if (testing.exists()){
					DisplayMessage(	parent,
							SecurityManagmentUIMessages.MainDialog_Error_26, 
							SecurityManagmentUIMessages.MainDialog_The_keystore_file_already_exists__27, 
							MessageDialog.ERROR,
							new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
					
					activeSecurityManagementProvider.setKeyStoreNameLoc(""); //$NON-NLS-1$
					return;
				}
				
				passlen = 6;
				InputValidationDialog promptNewPassword = new InputValidationDialog(fShell,SecurityManagmentUIMessages.MainDialog_Enter_Password_28,SecurityManagmentUIMessages.MainDialog_Please_enter_new_keystore_password__29, SecurityManagmentUIMessages.MainDialog_Please_confirm_new_keystore_password__30, null, new newPasswordLengthValidator(), new newPasswordLengthValidator(), null); 
				promptNewPassword.open();
				if (promptNewPassword.getReturnCode() == OK) {
					if (promptNewPassword.getPass().compareTo(promptNewPassword.getPass1())==0){
						activeSecurityManagementProvider.setPassWrd(promptNewPassword.getPass());
						ck = new CreateKeyDialog(parent.getShell());
						ck.open();
						if(ck.getReturnCode() == OK){							
							try {
								activeSecurityManagementProvider.setKeyStoreNameLoc(keyStoreLocFile);
								new ProgressMonitorDialog(fShell).run(false, false, getCreateNewKeyRunnable());
								//Cache this keystore/password pair
								keystoreCache.cacheSigningCertificate(createTargetSigningCertificate());
								
							} catch (InvocationTargetException e) {
								e.printStackTrace();
							} catch (InterruptedException e) {	
								e.printStackTrace();
							}
							if (keyCreated == true){
								activeSecurityManagementProvider.setKeyStoreNameLoc(keyStoreLocFile);
								keystore.setText(keyStoreLocFile);
								targetkeystore.setText(keyStoreLocFile);
								
								changepwd.setEnabled(true);
								list.add(ck.getFAlias());
								Object[] msgargs = new String[] {ck.getFAlias()};
								String msg = SecurityManagmentUIMessages.MainDialog_A_new_key_pair_with_key_alias__0__has_been_created_successfully__34; 
								String fMsg = MessageFormat.format(msg, msgargs);
								
								DisplayMessage(	parent,
										SecurityManagmentUIMessages.MainDialog_Create_New_Key_Pair_33, 
										fMsg,
										MessageDialog.INFORMATION,
										new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
							}
							else {
								activeSecurityManagementProvider.setKeyStoreNameLoc(""); //$NON-NLS-1$
								DisplayMessage(parent, SecurityManagmentUIMessages.MainDialog_10, 
												SecurityManagmentUIMessages.MainDialog_11,  
												MessageDialog.ERROR, 
												new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 }); 
							}
						} else {
							activeSecurityManagementProvider.setKeyStoreNameLoc(""); //$NON-NLS-1$
						}
					}else  {
						activeSecurityManagementProvider.setKeyStoreNameLoc(""); //$NON-NLS-1$
						DisplayMessage(	parent,
								SecurityManagmentUIMessages.MainDialog_Passwords_35, 
								SecurityManagmentUIMessages.MainDialog_The_new_password_and_the_confirm_password_entries_were_inconsistent__The_keystore_was_not_created__36, 
								MessageDialog.ERROR,
								new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
					} 
				} else {
					activeSecurityManagementProvider.setKeyStoreNameLoc(""); //$NON-NLS-1$
				}
			} catch (MtjException e) {
				e.printStackTrace();
			} 
		}
	}
	
	/**
	 * getOpenKeyRunnable - creates a runnable with progress from opening a key
	 * @return
	 */
	public IRunnableWithProgress getOpenKeyRunnable(){
		return new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				if (monitor == null) {
					monitor = new NullProgressMonitor();
				}
				
				try {
					keyaliases = activeSecurityManagementProvider.openKeyStore(keystorelocfile, keyStorePasswd, monitor);
					//TODO MIGHT HAVE TO CACHE EACH ONE OF THESE IN THE FUTURE
				} catch (MtjException e) {
					ErrorDialog.openError (	fShell	
							, SecurityManagmentUIMessages.MainDialog_22
							, SecurityManagmentUIMessages.MainDialog_23
							, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
							);
					e.printStackTrace();
				}
			}
		};
	}
	
	/**
	 * getCreateNewKeyRunnable - creates runnablewithprogress, requests and monitors the
	 * create new key command
	 * @return
	 */
	public IRunnableWithProgress getCreateNewKeyRunnable() {
		return new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				if (monitor == null) {
					monitor = new NullProgressMonitor();
				}
					monitorCreateNewKey(monitor);
			}
		};
	}
	
	/**
	 * monitorCreateNewKey - monitors the create new key command.
	 * @param monitor
	 */
	public void  monitorCreateNewKey (IProgressMonitor monitor) {
		try {
			if(activeSecurityManagementProvider.createNewKey(ck.getFAlias(), ck.getFCommonName(), ck.getFOrgUnit(),ck.getFOrgName(),ck.getFLocalName(), ck.getFStateName(),ck.getFCountry(), monitor)){ 
				keyCreated = true;									
			}
		} catch (MtjException e) {
			ErrorDialog.openError (	fShell
					, SecurityManagmentUIMessages.MainDialog_12
					, SecurityManagmentUIMessages.MainDialog_13
					, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
					);	
		}
	}
	
	
	/**
	 * CreateNewKeyPair - Creates monitor dialog, and requests a "create new key" command 
	 * @param parent
	 */
	protected void CreateNewKeyPair(Composite parent){		
		keyCreated = false;
		ck.open();
		if(ck.getReturnCode() == OK){
			
			try {
				new ProgressMonitorDialog(fShell).run(false, false, getCreateNewKeyRunnable());
				if (keyCreated == true){
					list.add(ck.getFAlias());
					activeSecurityManagementProvider.setAliaskey(ck.getFAlias());
					list.setSelection(list.getItemCount()- 1);
					updateKeyData();
					Object[] msgargs = new String[] {ck.getFAlias()};
					String msg = SecurityManagmentUIMessages.MainDialog_A_new_key_pair_with_key_alias__0__has_been_created_successfully__34; 
					String fMsg = MessageFormat.format(msg, msgargs);
					DisplayMessage(	parent,
							SecurityManagmentUIMessages.MainDialog_Create_New_Key_Pair_33, 
							fMsg,
							MessageDialog.INFORMATION,
							new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
				}
			} 
			catch (InvocationTargetException e) {
				e.printStackTrace();
			}
			catch (InterruptedException e) {
				e.printStackTrace();
			}
			catch (MtjException e) {
				e.printStackTrace();
			}
		}		
	}
	
	/**
	 * updateKeyData - gets the value associated with the key alias and displays it in 
	 * the KeyData field.
	 * @param keyAlias - keyalias whose data needs to be displayed to user in the
	 * keyData field.
	 * @throws MtjException 
	 * @throws MtjException 
	 */
	public void updateKeyData( ) throws MtjException{				
		
		try {
			keyDataValue = activeSecurityManagementProvider.getCertificateInfo(new NullProgressMonitor());
		} catch (MtjException e) {
			list.remove(list.getSelectionIndex());
			throw new MtjException(SecurityManagmentUIMessages.MainDialog_24, e); 
		}  		
		if (keyDataValue != null) {
			keydata.setText(keyDataValue);		
		}
		else {
			keydata.setText(""); //$NON-NLS-1$
			keydata.setEnabled(false);
		}
	}
	
	/**
	 * RefreshList - updates key list in key management tab with 
	 * key alia list
	 * @param aliases
	 */
	protected void RefreshList(String[] aliases){
		list.setItems(aliases);		
	}
	
	
	/**
	 * checkBlankChars - look for blank chars in string
	 * @param text
	 * @return
	 */
	public boolean checkBlankChars(String text) {
		
		if (text.indexOf(" ") != -1){ //$NON-NLS-1$
			return true;
		}
		return false;
	}
	
	/**
	 * 
	 * @author Rod
	 *
	 */
	public class oldPasswordLengthValidator implements IInputValidator {
		public String isValid(String arg0) {
			if (checkBlankChars(arg0)){
				return SecurityManagmentUIMessages.MainDialog_The_passwords_do_not_allow_blank_characters__40; 
			}
			if (arg0.length() < 1){
				return SecurityManagmentUIMessages.MainDialog_Please_enter_password_41;   
			}
			return null;
		}
	}
	
	/**
	 * newPasswordLengthValidator - validates password input
	 * @author Rod
	 *
	 */
	public class newPasswordLengthValidator implements IInputValidator {
		public String isValid(String arg0) {
			if (checkBlankChars(arg0)){
				return SecurityManagmentUIMessages.MainDialog_The_passwords_do_not_allow_blank_characters__42; 
			}
			if (arg0.length() < passlen){
				return SecurityManagmentUIMessages.MainDialog_Keystore_password_should_have_at_least__43 + passlen + SecurityManagmentUIMessages.MainDialog__characters__44;   
			}
			return null;
		}
	}
	
	/**
	 * DisplayMessage - Creates A MessageDialog w/ the MTJ Image
	 * @param parent
	 * @param title
	 * @param msg
	 * @param type
	 * @param labels
	 */
	private void DisplayMessage (Composite parent, String title, String msg, int type, String[] labels){
		MessageDialog updated = 
			new MessageDialog(parent.getShell(),
					title, 
					MTJImage,
					msg,
					type,
					labels,
					1);
		updated.open();
	}
	
	/**
	 * browse() - Displayes a dialog with a list of eligible projects 
	 * which can be digitally signed 
	 * @return
	 * @throws MtjException
	 */
	public IMtjProject browse() throws MtjException {
		
		IProject[] filteredProjects = getFilteredProjects();		
		
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(getShell(), new WorkbenchLabelProvider() );
		dialog.setTitle(SecurityManagmentUIMessages.Launch_Project_Selection_13); 
		dialog.setImage(MTJImage);
		dialog.setMessage(SecurityManagmentUIMessages.MainDialog_26); 

		dialog.setElements(filteredProjects);
		
		if (dialog.open() == Window.OK) {			
			return MtjProject.getMtjProject((new JavaProject((IProject)dialog.getFirstResult(), null)));			
		}
		else{
			return null;
		}
	}
	
	/**
	 * getFilteredProjects() - Returns array of MTJ projects in the workspace, 
	 * filtered by current signing provider's supported type 
	 * 
	 * @return
	 */
	private IProject[] getFilteredProjects() {
		
		DeploymentType[] dt;  // list of deployment types supported by the current signer
		
		if (_filteredProjects == null) {
			IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()
			.getProjects();
			java.util.List<IProject> filteredProjects = new ArrayList<IProject>();
			
			try {
				dt = activeSigningProvider.getSupportedTypes();
			} catch (MtjException e1) {
				//Signer supported deployment types not found
				return null;
			}
			
			for (int i = 0; i < projects.length; i++) {
				try {
					//only MTJ projecs
					if (MtjNature.hasMtjNature(projects[i])) {
						if (activeSigningProvider != null){
							//Only list projects supported by current signing provider
							for (int j = 0; j < dt.length; j++)
							{
								try {
									if (dt[j] == MtjProject.getMtjProject(projects[i]).getDeployment().getType()){
										filteredProjects.add(projects[i]);
									}								
								} catch (CoreException e) {// keep iterating... and looking for a project 
								}
							}
						}
					}
				} 
				catch (CoreException e) {}	
				catch (MtjException e) {}
			}
			_filteredProjects = (IProject[]) filteredProjects.toArray(new IProject[filteredProjects.size()]);
		}
		return _filteredProjects;
	}
	
	
	/**
	 * UnsignBTNPressed(Composite parent) - handles Unsign button pressed action
	 * @param parent
	 * @throws CoreException
	 * @throws IOException
	 * @throws MtjException
	 */
	protected void UnsignBTNPressed(Composite parent) throws CoreException,
	IOException, MtjException {
		
		if (UnsignMIDletBuild(fMtjProject) == true) {
			DisplayMessage(parent,			
					SecurityManagmentUIMessages.BuildsDialog_4, 
					SecurityManagmentUIMessages.BuildsDialog_5, 
					MessageDialog.INFORMATION, 
					new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 }); 
					
			unsignButton.setEnabled(false);
			if (list != null) {
				if (GetListSelection(list).length() > 0) {
					signButton.setEnabled(true);
				}
			}
			
		} else {
			DisplayMessage(parent, SecurityManagmentUIMessages.BuildsDialog_7, 
					SecurityManagmentUIMessages.BuildsDialog_8, 
					MessageDialog.ERROR, new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 });
		}
	}
	
	/**
	 * UnsignMIDletBuild() - Unsign MIDlet build.
	 * @param  fProject - Unsign the build on specified  project
	 * @return - True if build is unsigned.
	 * @throws MtjException 
	 */
	public boolean UnsignMIDletBuild(IMtjProject fProject) throws CoreException, IOException, MtjException {
				
		boolean unsigned = false;
		Project data = fMtjProject.getProjectData();
		
		//need to remove signing detail from build
		if (data != null){			
			//Remove signing information from target device
			TargetDevice targetDevice = data.getDefaultTargetDevice();
			if ( targetDevice != null){
				EList i =  targetDevice.getSigningDetails();
				if (i != null){
					i.clear();
					unsigned = true;
				}
				fMtjProject.setProjectData(data);
			}
		} 
		if (!unsigned){
			System.err.println(SecurityManagmentUIMessages.MainDialog_32); 
		}
		
		return activeSigningProvider.unsign(fMtjProject,targetFolder, new NullProgressMonitor());
	}
	
	/**
	 * creates runnable with progress to do signing
	 * @return
	 */
	public IRunnableWithProgress getSignMidletRunnable() {
		return new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				if (monitor == null) {
					monitor = new NullProgressMonitor();
				}
				monitorSignMidlet(monitor);
			}
		};
	}
	
	/**
	 * Monitored worker thread to perform signing 
	 * @param monitor
	 */
	@SuppressWarnings("unchecked") //$NON-NLS-1$
	public void  monitorSignMidlet (IProgressMonitor monitor) {
		
		try {	
			SigningCertificate sc = createTargetSigningCertificate();
			SigningDetail sd = ProjectFactory.eINSTANCE.createSigningDetail();
			sd.setAlias(sc.getAliasName());
			sd.setKeystore(sc.getKeystore());
			
			Project data = fMtjProject.getProjectData();
			
			if (data != null){
				//Add signing information to target device
				TargetDevice targetDevice = data.getDefaultTargetDevice();
				if ( targetDevice != null){
					//EList i = targetDevice.getSigningDetails();
					java.util.List<SigningDetail> i =  targetDevice.getSigningDetails(); 
					if (i.size() > 0) {
						i.clear();
					}
					i.add(sd);
					fMtjProject.setProjectData(data);
				}
			}

			if (activeSigningProvider.sign(fMtjProject,targetFolder,sc,monitor)) {
				//if signing process succeeded...
				DisplayMessage(	fShell,
						SecurityManagmentUIMessages.MainDialog_27, 
						SecurityManagmentUIMessages.MainDialog_28, 
						MessageDialog.INFORMATION,
						new String[] { SecurityManagmentUIMessages.MainDialog_OK_17 }); 
								
				//update sing/unsign buttons
				signButton.setEnabled(false);
				unsignButton.setEnabled(true);
				
			}
		} catch (MtjException e) {
			ErrorDialog.openError (	fShell//MtjCorePlugin.getActiveShell()	
					,SecurityManagmentUIMessages.MainDialog_29
					,SecurityManagmentUIMessages.MainDialog_30
					, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
					);			
		}
	}	
	
	/**
	 * creates a SigningCertificate to be used in the signing feature
	 * created from the information already set in the currently active 
	 * security management provider.
	 * @return
	 */
	private SigningCertificate createTargetSigningCertificate(){
		
		SigningCertificate sc = SigningsFactoryImpl.eINSTANCE.createSigningCertificate();

		try {
			sc.setAliasName(activeSecurityManagementProvider.getAliaskey());
			sc.setKeystore(activeSecurityManagementProvider.getKeyStoreNameLoc());
			sc.setCertificatePassword(activeSecurityManagementProvider.getPassWrd());
			sc.setKeystorePassword(activeSecurityManagementProvider.getPassWrd());
			
		} catch (MtjException e) {
			System.err.println(SecurityManagmentUIMessages.MainDialog_25); 
			e.printStackTrace();
		}
		return sc;
	}
		
	
	/**
	 * Adds permission to the list in the permissions page.
	 * @param parent
	 * @param list
	 * @param permission
	 */
	public void AddPermissionToList (Composite parent, List list, String permission){
		boolean dup = false;
				
		for (int i=0; i < list.getItemCount(); i++){
			if (permission.compareTo(list.getItem(i)) == 0){
				dup = true;
			}
		}
		if (dup == false){
			list.add(permission);
			updateButton.setEnabled(true);
		}
		else{
			DisplayMessage(	parent,
							SecurityManagmentUIMessages.MainDialog_Duplicate_Permission_45, 
							SecurityManagmentUIMessages.MainDialog_The_permission_API_you_selected_is_already_defined__46, 
							MessageDialog.INFORMATION,
							new String [] {SecurityManagmentUIMessages.MainDialog_OK_17}); 
		}
		
	}
	
	/**
	 * Writes permissions to a JAD file 
	 * @param JadFile
	 * @throws IOException
	 * @throws CoreException
	 */
	public void WritePermissions(IFile JadFile) throws IOException, CoreException{
	
		String all [] = list1.getItems();
		String allopt [] = list2.getItems();
		String pop = ""; //$NON-NLS-1$
		String popopt = ""; //$NON-NLS-1$
		
		JadFileDescriptor descriptor1;
		
		descriptor1 = JadFileDescriptor.getDescriptor(JadFile);		
		
		for (int h=0; h < allopt.length; h++){
			if (allopt.length > 1){
				if (h == allopt.length - 1){
					popopt = popopt + allopt[h];
				}
				else{
					popopt = popopt + allopt[h] + ","; //$NON-NLS-1$
				}
			}
			else{
				popopt = popopt + allopt[h];
			}
		}
		descriptor1.setProperty(JadFileDescriptor.PERMISSIONS_OPT, popopt);
		
		for (int g=0; g < all.length; g++){
			if (all.length > 1){
				if (g == all.length - 1){
					pop = pop + all[g];
				}
				else{
					pop = pop + all[g] + ","; //$NON-NLS-1$
				}
			}
			else{
				pop = pop + all[g];
			}
		}
		descriptor1.setProperty(JadFileDescriptor.PERMISSIONS, pop);
		
		//run the descriptor content through a native->latin-1+escapes filter								
		JadFile.setContents(ConvertNativeToUTF8.convertNativeToUTF8(descriptor1.serialize()), true,true, null);
	
	}
	
	/**
	 * General purpose CustomDialog with validators.
	 * @param shell
	 * @return
	 */
	protected String CustomDialog(Shell shell) {
		InputValidationDialog cust = new InputValidationDialog(shell, SecurityManagmentUIMessages.MainDialog_Add_Custom_Permission_58, SecurityManagmentUIMessages.MainDialog_Enter_custom_permission_to_add__59, null, null, new nameValidator(), null, null); 
		cust.open();
		if (cust.getReturnCode() == OK) {
			return cust.getPass();
		} else {
			return null;
		}
	}
	
	/**
	 * @author Rod
	 * Used to validate Custom permissions submited by user.
	 */
	public class nameValidator implements IInputValidator {
		public String isValid(String arg0) {
			//IStatus val= JavaConventions.validateJavaTypeName(arg0);
			IStatus val= JavaConventions.validatePackageName(arg0);
			if (!val.isOK()){
				return SecurityManagmentUIMessages.MainDialog_Permission_name_is_not_valid___Please_enter_a_valid_Permission_name__57; 
			}
			return null;
		}
	}
	/**
	 * Returns the MTJ project's deployed JAD file
	 * @param project
	 * @return
	 * @throws MtjException
	 */
	private IFile getProjectjadIFile(IMtjProject project) throws MtjException {	
		IFile jadIFile = null;
		Deployment dp = null;
		
		try {
			dp = project.getDeployment();
		} catch (CoreException e) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SIGNING) + "", e); //$NON-NLS-1$
		}
		if(dp.getType() == DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL)
		{
			try {
				jadIFile = project.getDeploymentFolder(null).getFile(((MidletDeployment)dp).getJad().getName());
			} catch (CoreException e) {
				throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SIGNING) + "", e); //$NON-NLS-1$
			}
		}
		return jadIFile;
	}
	/**
	 * Updates the permission's lists and buttons in the permissions page
	 */
	private void updatePermListsandButtons() {
		JadFileDescriptor descriptor1;

		IFile JadFile = null;
		try {
			JadFile = getProjectjadIFile(fMtjProject);
			descriptor1 = JadFileDescriptor.getDescriptor(JadFile);	
			
			String prof =  descriptor1.getProperty(JadFileDescriptor.PROFILE_NAME);
			
			if (!prof.equals(JadFileDescriptor.MIDP20))
			{
				return;
			}
			
			add1.setEnabled(true);
			addcustom1.setEnabled(true);
			add2.setEnabled(true);
			addcustom2.setEnabled(true);
			
			String perm1 = descriptor1.getProperty(JadFileDescriptor.PERMISSIONS);
			String permopt1 = descriptor1.getProperty(JadFileDescriptor.PERMISSIONS_OPT);
			
			if (perm1 != null){
				list1.removeAll();
				StringTokenizer strtok = new StringTokenizer(perm1, ","); //$NON-NLS-1$
				while (strtok.hasMoreTokens()){
					list1.add(strtok.nextToken().trim());
				}
			} else {
				list1.removeAll();
			}
			
			if (permopt1 != null){
				list2.removeAll();
				StringTokenizer strtok2 = new StringTokenizer(permopt1, ","); //$NON-NLS-1$
				while (strtok2.hasMoreTokens()){
					list2.add(strtok2.nextToken().trim());
				}
			} else {
				list2.removeAll();
			}	
						
		} catch (Exception e3){
			add1.setEnabled(false);
			addcustom1.setEnabled(false);
			add2.setEnabled(false);
			addcustom2.setEnabled(false);
		}
				
	}
	
	protected void buttonPressed(int buttonId) {
		
		if ((buttonId == 0) && (updateButton.getEnabled() == true)) {
			if (MessageDialog.openConfirm(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), SecurityManagmentUIMessages.MainDialog_Confirm_1, SecurityManagmentUIMessages.MainDialog_If_you_close_this_dialog_without_updating_the_MIDP_application__you_will_lose_the_changes_you__ve_made___Are_you_sure_you_want_to_close_the_dialog__2)){ 
				super.buttonPressed(buttonId);
			}
		}
		else{
			super.buttonPressed(buttonId);
		}
	}
}