package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpSigning;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PopUpAction implements IObjectActionDelegate {

	private IMtjProject fTargetProject = null;
	private MidpSigning midpSigning = null;
	private boolean SignAction = false;
	private Shell shell;
	
	/**
	 * Constructor for Action1.
	 */
	public PopUpAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {

		if (action.getId().endsWith(".unsigncontribution")){ //$NON-NLS-1$
			SignAction = false;
		}
		else if (action.getId().endsWith(".signcontribution")){ //$NON-NLS-1$
			SignAction = true;
		}
		
		Display display = Display.getCurrent();
		if (display == null) {
			display = Display.getDefault();
		}
		if (display == null) {
			shell = new Shell();
		} else {
			shell = display.getActiveShell();
		}		
		
		try {
			if (fTargetProject != null) {
				if (fTargetProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL)
				{					
					try	{
						new ProgressMonitorDialog(shell).run(false, false, getSignMidletRunnable());
					}
					catch (InvocationTargetException e) {}
					catch (InterruptedException e) {}
				}
			}
		} catch (MtjException e) {}
	}
	
	public IRunnableWithProgress getSignMidletRunnable() {
		return new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				if (monitor == null) {
					monitor = new NullProgressMonitor();
				}
				
				midpSigning = new MidpSigning(fTargetProject, monitor);
					
				//if Sign application...
				if (SignAction){
					midpSigning.preemtSign();
									
					if (midpSigning.canSign()){
						midpSigning.sign();
					} else {
						midpSigning.displaySigningStepMessage(new MtjException(), SecurityManagmentUIMessages.PopUpAction_2, SecurityManagmentUIMessages.PopUpAction_3, IStatus.INFO); 
					}
				}
				//else unsing application
				else {
					midpSigning.unsign();
				}
			}
		};
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection && ((IStructuredSelection) selection).size() == 1) {		
			fTargetProject = getFirstProject(((IStructuredSelection) selection).toList());
		}
	}

	/**
	 * @param list
	 * @return
	 */
	private IMtjProject getFirstProject(List list) {
		IMtjProject firstProject = null;
		for (Iterator i = list.iterator(); i.hasNext();) {
			Object element = i.next();
			
			if (element instanceof IAdaptable) {
				// any resource will trigger this action (for its project)
				IResource res = (IResource) ((IAdaptable) element).getAdapter(IResource.class);
				
				if (res != null) {
					try {
						//get an MTJ project from the selection
						firstProject = MtjProject.getMtjProject((new JavaProject(res.getProject(), null)));
						
					} catch (MtjException e) {}
				}
			}
		}
		return firstProject;
	}
}
