package org.eclipse.mtj.extension.smgmt.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RootCertDialog extends Dialog {

	
	private String KeystoreName = null;
	private String Alias = null;
	private String RootCertName = null;
	
	private Text RootCertText = null;
	
	private Button closeButton = null;
	private Button ImportButton = null;
	
	public RootCertDialog(Shell parentShell, String keystore, String alias) {
		super(parentShell);
		this.KeystoreName = keystore;
		this.Alias = alias;
	
	}
	
	protected void createButtonsForButtonBar(final Composite parent) {
        
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		parent.setLayout(gridLayout);

		ImportButton = createButton(parent, IDialogConstants.OK_ID, SecurityManagmentUIMessages.RootCertDialog_Import, true);
		ImportButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		ImportButton.setEnabled (false);
		ImportButton.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {		
			}});
		
		closeButton = createButton(parent, IDialogConstants.CANCEL_ID , IDialogConstants.CANCEL_LABEL, true);
		closeButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		closeButton.setFocus();
	}
		
	protected Control createContents(Composite parent) {
		parent.getShell().setText(SecurityManagmentUIMessages.RootCertDialog_Import_Root_Certificate);
		
		Composite c1 =	new Composite(parent, SWT.NONE);
		
		GridLayout c1gridLayout = new GridLayout();
		c1gridLayout.numColumns = 3;
		c1.setLayout(c1gridLayout);
		GridData gdC = new GridData(GridData.FILL_HORIZONTAL);
		c1.setLayoutData(gdC);
		
		Label nameLabel = new Label(c1, SWT.LEFT);
		nameLabel.setText(SecurityManagmentUIMessages.RootCertDialog_From_Keystore);
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		gd.widthHint = 250;
		
		Text NameText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		NameText.setLayoutData(gd);
		NameText.setEnabled(false);
		if (this.KeystoreName != null) NameText.setText(this.KeystoreName);
		
		Label versionLabel = new Label(c1, SWT.LEFT);
		versionLabel.setText(SecurityManagmentUIMessages.RootCertDialog_Target_Alias);
		
		gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		gd.widthHint = 250;
		
		Text VersionText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		VersionText.setLayoutData(gd);
		if (this.Alias != null) VersionText.setText(this.Alias);
		VersionText.setEnabled(false);
		
		Label locationLabel = new Label(c1, SWT.LEFT);
		locationLabel.setText("Target Root Certificate"); //$NON-NLS-1$
		
		gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 1;

		RootCertText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		RootCertText.setLayoutData(gd);
		if (this.RootCertName != null) RootCertText.setText(this.RootCertName);
		RootCertText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				
			}
		});
		
		gd = new GridData( GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 1;
		gd.widthHint = 70;
		
		Button search = new Button(c1,SWT.PUSH);
		search.setLayoutData(gd);
		search.setText(SecurityManagmentUIMessages.SecurityManagementEditor_4);  
		search.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {

				FileDialog newSecurityLocation = new FileDialog(getShell());
			
				newSecurityLocation.setFilterPath(RootCertText.getText());

				newSecurityLocation.setText(SecurityManagmentUIMessages.RootCertDialog_Specify_root_certificate);
				
				String newSecurityLoc = newSecurityLocation.open();
				if (newSecurityLoc != null && !newSecurityLoc.equals("")) //$NON-NLS-1$
				{
					RootCertText.setText(newSecurityLoc);
					ImportButton.setEnabled(true);
				}
			}					
		});
					
		return super.createContents(parent);
	}
	protected void buttonPressed(int buttonId) {
		if (buttonId == OK) {
			this.RootCertName = RootCertText.getText();
		}
		super.buttonPressed(buttonId);

	}
	
	public String getRootCertName() {
		return this.RootCertName;
	}
}
