/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/
package org.eclipse.mtj.extension.smgmt.ui.eclipse.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * @author Rod
 *
 */
public class SecurityManagementEditor extends Dialog {

	private String name = null;
	private String version = null;
	private String path = null;
	private String description = null;
	
	private Text NameText;
	private Text VersionText;
	private Text LocationText;
	private Text DescriptionText;
	
	/**
	 * @param parentShell
	 */
	public SecurityManagementEditor(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * @param parentShell
	 * @param description 
	 */
	public SecurityManagementEditor(Shell parentShell, String name, String version, String path, String description) {
		super(parentShell);
		this.name = name;
		this.version = version;
		this.path = path;
		this.description = description;

	}
	/**
	 * @param parentShell
	 */
	public SecurityManagementEditor(IShellProvider parentShell) {
		super(parentShell);
		// TODO Auto-generated constructor stub
	}

	@Override
	protected Control createContents(Composite parent) {
		parent.getShell().setText(SecurityManagmentUIMessages.SecurityManagementEditor_1); 
		
		Composite c1 =	new Composite(parent, SWT.NONE);
		
		GridLayout c1gridLayout = new GridLayout();
		c1gridLayout.numColumns = 3;
		c1.setLayout(c1gridLayout);
		GridData gdC = new GridData(GridData.FILL_HORIZONTAL);
		c1.setLayoutData(gdC);
		
		Label nameLabel = new Label(c1, SWT.LEFT);
		nameLabel.setText(SecurityManagmentUIMessages.SecurityManagementEditor_2);  
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		gd.widthHint = 250;
		
		NameText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		NameText.setLayoutData(gd);
		NameText.setEnabled(false);
		if (this.name != null) NameText.setText(this.name);
		
		Label versionLabel = new Label(c1, SWT.LEFT);
		versionLabel.setText(SecurityManagmentUIMessages.SecurityManagementEditor_0); 
		
		gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		gd.widthHint = 250;
		
		VersionText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		VersionText.setLayoutData(gd);
		if (this.version != null) VersionText.setText(this.version);
		VersionText.setEnabled(false);
		
		Label descriptionLabel = new Label(c1, SWT.LEFT);
		descriptionLabel.setText(SecurityManagmentUIMessages.SecurityManagementEditor_7); 
		
		gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		gd.widthHint = 250;
		
		DescriptionText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		DescriptionText.setLayoutData(gd);
		if (this.description != null) DescriptionText.setText(this.description);
		DescriptionText.setEnabled(false);
		
		Label locationLabel = new Label(c1, SWT.LEFT);
		locationLabel.setText(SecurityManagmentUIMessages.SecurityManagementEditor_3); 
		
		gd = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 1;

		LocationText = new Text(c1, SWT.SINGLE | SWT.BORDER);
		LocationText.setLayoutData(gd);
		if (this.path != null) LocationText.setText(this.path);
		LocationText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				
			}
		});
		
		gd = new GridData( GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 1;
		gd.widthHint = 70;
		
		Button search = new Button(c1,SWT.PUSH);
		search.setLayoutData(gd);
		search.setText(SecurityManagmentUIMessages.SecurityManagementEditor_4);  
		search.addSelectionListener(new SelectionAdapter (){
			public void widgetSelected(SelectionEvent e) {

				DirectoryDialog newSecurityLocation = new DirectoryDialog(getShell());
			
				newSecurityLocation.setFilterPath(LocationText.getText());

				newSecurityLocation.setText(SecurityManagmentUIMessages.SecurityManagementEditor_5);  

				newSecurityLocation.setMessage(SecurityManagmentUIMessages.SecurityManagementEditor_6);  
				
				String newSecurityLoc = newSecurityLocation.open();
				if (newSecurityLoc != null)
				{
					LocationText.setText(newSecurityLoc);
				}

			}
					
		});
					
		return super.createContents(parent);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	protected void buttonPressed(int buttonId) {
		if (buttonId == OK) {
			//this.name = NameText.getText();
			this.path = LocationText.getText();
			//this.version = VersionText.getText();
		} 
		super.buttonPressed(buttonId);
	}

	public String getName() {
		return name;
	}

	public String getPath() {
		return path;
	}
	
	public String getVersion() {
		return version;
	}
}

