/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJLibrarySelectionWizard;
import org.eclipse.mtj.jad.JadPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class MTJLibrarySelectionAction implements IWorkbenchWindowActionDelegate, IObjectActionDelegate
{

	private IWorkbenchWindow fWorkbenchWindow;

	private IStructuredSelection fSelection;

	public void run(IAction action) {

		MTJLibrarySelectionWizard midletSuitePackagingWizard = new MTJLibrarySelectionWizard(fSelection);
		midletSuitePackagingWizard.setWindowTitle(Messages.MTJLibrarySelectionAction_ReplaceRuntimePlatform);
		Shell shell = JadPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
		WizardDialog wizardDialog = new WizardDialog(shell, midletSuitePackagingWizard);
		wizardDialog.create();
		int result= wizardDialog.open();
		
		if (result != IDialogConstants.OK_ID) {
//			System.out.println("Didn't open");
		}

	}


	/**
	 * @see IActionDelegate
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		fSelection = (IStructuredSelection) selection;


		// Update the action enablement based on the selection.
		if (action != null)
			action.setEnabled(isEnabled(getSelection()));
	}

	protected boolean isEnabled(IStructuredSelection selection) {
		return true;
	}

	/**
	 * @see IEditorActionDelegate
	 */
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		fWorkbenchWindow = targetEditor.getEditorSite().getWorkbenchWindow();

		selectionChanged(action, targetEditor.getEditorSite()
				.getSelectionProvider().getSelection());
	}

	/**
	 * @see IObjectActionDelegate
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		fWorkbenchWindow = targetPart.getSite().getWorkbenchWindow();

		if (targetPart.getSite().getSelectionProvider() != null) {
			selectionChanged(action, targetPart.getSite()
					.getSelectionProvider().getSelection());
		}
	}

	/**
	 * @see IViewActionDelegate
	 */
	public void init(IViewPart view) {
		fWorkbenchWindow = view.getSite().getWorkbenchWindow();

		selectionChanged(null, view.getSite().getSelectionProvider()
				.getSelection());
	}

	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void dispose() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void init(IWorkbenchWindow window) {
		fWorkbenchWindow = window;

		selectionChanged(null, window.getSelectionService().getSelection());
	}

	protected IStructuredSelection getSelection() {
		if (fSelection instanceof IStructuredSelection)
			return (IStructuredSelection) fSelection;
		else
			return new StructuredSelection();
	}

	protected Shell getShell() {
		return getWorkbenchWindow().getShell();
	}

	protected IWorkbench getWorkbench() {
		return getWorkbenchWindow().getWorkbench();
	}

	protected IWorkbenchWindow getWorkbenchWindow() {
		return fWorkbenchWindow;
	}
}
