/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors:
 * 		Kevin Horowitz (IBM Corp) - Add progress monitor code
*******************************************************************************/
package org.eclipse.mtj.extension.devide.action;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.BuildManagement;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ToggleProjectBuildAction extends AbstractJavaProjectAction
{
	private IStructuredSelection	currentProjectSelection = null;
	IMtjProject mtjproject;
	BuildManagement buildManagement;
	RuntimePlatformDefinition rpd;
	
	public void dispose() {}

	public void init(IWorkbenchWindow window) {}

	private IProject findProject(IProject project) throws CoreException {
		IProject[] projects = EclipseUtil.getProjectsForNature(MtjNature.getNatureID());
		for (int i = 0; i < projects.length; i++) {
			if (projects[i] == project) {
				return projects[i];
			}
		}		
		MessageDialog.openInformation(MtjCorePlugin.getActiveShell(),
	            Messages.ToggleProjectBuildAction_InformationDialogTitle, Messages.ToggleProjectBuildAction_ProjectNotMtj);		
		return null;
	}
	
	private IProject getProject() {
		// NB: An IJavaProject is NOT an IProject !!  (but we can ask IProject from IJavaProject) 
		if (currentProjectSelection.getFirstElement() instanceof IJavaProject) {
			return ((IJavaProject)currentProjectSelection.getFirstElement()).getProject();
		} else {
			return (IProject)currentProjectSelection.getFirstElement();
		}		
	}

	private void openMtjExceptionDialog(MtjException e) {
		ErrorDialog.openError (	MtjCorePlugin.getActiveShell()	
				, Messages.ToggleProjectBuildAction_Error_while_building_project
				, e.getMessage()
				, new Status( IStatus.ERROR, 
						IEclipseMtjCoreConstants.PLUGIN_ID, 
						-1, e.toString(), 
						e));		
	}
	
	private void openCoreExceptionDialog(CoreException e) {
		ErrorDialog.openError (	MtjCorePlugin.getActiveShell()
				, Messages.ToggleProjectBuildAction_Error
				, getClass().getName()
				, e.getStatus());		
	}
	
	private void processProjectData(IProject project, BuildManagement bm) throws MtjException {
		IMtjProject proj = MtjProject.getMtjProject(project);
		Project data = proj.getProjectData();
		if (data == null || data.getDefaultTargetDevice() == null || 
			data.getDefaultTargetDevice().getRuntimePlatform() == null) {
			MessageDialog.openInformation(MtjCorePlugin.getActiveShell(), Messages.ToggleProjectBuildAction_Error_while_building_project_2,
		            Messages.ToggleProjectBuildAction_Project_default_target_device_not_selected);
		}
		else {
			rpd = data.getDefaultTargetDevice().getRuntimePlatform();
			mtjproject = MtjProject.getMtjProject(project);
			buildManagement = bm;
				
		  	try 
		  	{
			   IWorkbench wb = PlatformUI.getWorkbench();
			   IProgressService ps = wb.getProgressService();
			   ps.busyCursorWhile(new IRunnableWithProgress() {
				   public void run(IProgressMonitor pm) throws InvocationTargetException {
						try {
							build(pm);
						} catch (MtjException e) {
							throw new InvocationTargetException (e);
						}
			      }
			   });
			} catch (InvocationTargetException e) {
				throw (MtjException) e.getTargetException();
			} catch (InterruptedException e) {
				e.printStackTrace();
			} catch (SWTException e) { // When this is run from the launch window, the shell is not available, so just create a null progress monitor
				build (new NullProgressMonitor());
			}
		
				
		}		
	}
	
	public void build (IProgressMonitor pm) throws MtjException
	{
		buildManagement.build(mtjproject, MtjNature.getNatureID(), BuildType.BUILD_TYPE_ECLIPSE_LITERAL, rpd, pm);
	}
	
	public void run(ILaunchConfiguration launchConfiguration)
	{		
		try {
			IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "")); //$NON-NLS-1$
			if (project != null) {
				BuildManagement bm = (BuildManagement)
					MtjServices.getInstance().getImplementations(ExtensionType.BUILD_MANAGEMENT_LITERAL,
							null,null,true)[0];				
				processProjectData(project, bm);
			}
		} catch (MtjException e) {
			openMtjExceptionDialog(e);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void run(IAction action)
	{		
		try {
			IProject project = findProject(getProject());
			if (project != null) {
				BuildManagement bm = (BuildManagement)
					MtjServices.getInstance().getImplementations(ExtensionType.BUILD_MANAGEMENT_LITERAL,
							null,null,true)[0];				
				processProjectData(project, bm);
			}
		} catch (MtjException e) {
			openMtjExceptionDialog(e);
		} catch (CoreException ce) {
			openCoreExceptionDialog(ce);
		}
	}

	public void selectionChanged(IAction action, ISelection selection)
	{
		if (selection instanceof IStructuredSelection) {
			currentProjectSelection = (IStructuredSelection)selection;
		}
	}
}
