/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ToggleProjectNatureAction implements IWorkbenchWindowActionDelegate
{
	private IStructuredSelection	currentProjectSelection = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose()
	{

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window)
	{

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action)
	{
		IProject project;
		
		// NB: An IJavaProject is NOT an IProject !!  (but we can ask IProject from IJavaProject) 
		if (currentProjectSelection.getFirstElement() instanceof IJavaProject) {
			project = ((IJavaProject)currentProjectSelection.getFirstElement()).getProject();
		} else {
			project = (IProject)currentProjectSelection.getFirstElement();
		}
		try {
			IProject[] projects = EclipseUtil.getProjectsForNature(MtjNature.getNatureID());
			int ix = -1;
			for (int i = 0; i < projects.length; i++) {
				if (projects[i] == project) {
					ix = i;
					break;
				}
			}
			if ( ix == -1 ) {
				EclipseUtil.toggleProjectNature(MtjNature.getNatureID(), project);
				
				IJavaProject javaProject = JavaCore.create (project);
				// The project needs to be a 1.4 project to keep 5.0 syntax from being introduced 
				// This sets the values.
				javaProject.setOption(JavaCore.COMPILER_COMPLIANCE, JavaCore.VERSION_1_4);
				javaProject.setOption(CompilerOptions.OPTION_Source, JavaCore.VERSION_1_3);
				javaProject.setOption(CompilerOptions.OPTION_TargetPlatform, JavaCore.VERSION_1_2);

				Project mtjProject = ProjectFactory.eINSTANCE.createProject();
				mtjProject.setType(ProjectType.PROJECT_TYPE_MIDP_LITERAL);
				try {
					MtjProject.setProjectData(javaProject, mtjProject);
				} catch (MtjException e) {
					e.printStackTrace();
				}

			}
			else {
				MessageDialog.openInformation(MtjCorePlugin.getActiveShell(),
			            Messages.ToggleProjectNatureAction_InformationDialogTitle, Messages.ToggleProjectNatureAction_Project_alread_MTJ_project);
			}
		} catch (CoreException ce) {
			ErrorDialog.openError (	MtjCorePlugin.getActiveShell()	// window.getShell()
					, Messages.ToggleProjectNatureAction_Error
					, getClass().getName()
					, ce.getStatus());
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection)
	{
		if (selection instanceof IStructuredSelection)
			currentProjectSelection = (IStructuredSelection)selection;
	}

}
