/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.extension.devide.executable;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.extension.devide.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.internal.utils.Utils;

/**
 * Classpath entry visitor implementation for collecting up
 * the classpath.
 */
public class ClasspathCollectionVisitor
	extends FilteringClasspathEntryVisitor
{
	private Set cpEntries;
	private IPath classesPath;
	private IPath libsPath;
	
	/** Constructor */
	public ClasspathCollectionVisitor(IPath classesPath, IPath libsPath) {
		this.classesPath = classesPath;
		this.libsPath = libsPath;
		cpEntries = new LinkedHashSet();
	}
	
	/**
	 * @return Returns the cpEntries.
	 */
	public Set getCpEntries() {
		return cpEntries;
	}

	/**
	 * @see eclipseme.core.internal.utils.IClasspathEntryVisitor#visitLibraryEntry(org.eclipse.jdt.core.IClasspathEntry, org.eclipse.jdt.core.IJavaProject, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void visitLibraryEntry(
		IClasspathEntry entry,
		IJavaProject javaProject, 
		IProgressMonitor monitor)
			throws CoreException 
	{
		File resolvedEntry = Utils.getResolvedClasspathEntryFile(entry);
		if (resolvedEntry.isFile()) {
			IPath libPath = libsPath.append(entry.getPath().lastSegment());
			cpEntries.add(libPath);
		}
	}
	
	/**
	 * @see eclipseme.core.internal.utils.IClasspathEntryVisitor#visitSourceEntry(org.eclipse.jdt.core.IClasspathEntry, org.eclipse.jdt.core.IJavaProject, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void visitSourceEntry(
		IClasspathEntry entry,
		IJavaProject javaProject, 
		IProgressMonitor monitor)
			throws CoreException 
	{
		cpEntries.add(classesPath);
	}
}
