/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.properties;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class RuntimeListComposite extends Composite {
	private GuiComponents gc = new GuiComponents();

	public RuntimeListComposite(Composite parent) {
		super(parent, SWT.NONE);
		setLayout(new FillLayout());

		gc.createSashForm(this);
	}	
	
	public Button getEditRuntimeButton() {
		return gc.button;
	}
	
	public CheckboxTableViewer getRuntimeTableViewer() {
		return new CheckboxTableViewer(gc.table);
	}

	public Button getEditDeviceButton() {
		return gc.button1;
	}
	
	public CheckboxTableViewer getDeviceTableViewer() {
		return new CheckboxTableViewer(gc.table1);
	}
}

class GuiComponents {
	private Composite composite = null;
	public Table table = null;
	private Composite composite1 = null;
	public Button button = null;
	private Group group = null;
	private SashForm sashForm = null;
	private Group group1 = null;
	private Composite composite2 = null;
	public Table table1 = null;
	private Composite composite3 = null;
	public Button button1 = null;

	private void createComposite() {
		composite = new Composite(group, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite.setLayout(gridLayout);
		createTable();
		//createComposite1();
	}

	private void createTable() {
		table = new Table(composite, SWT.CHECK | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		GridData data = new GridData(GridData.FILL_BOTH);
		table.setLayoutData(data);
	}

	private void createGroup() {
		group = new Group(sashForm, SWT.NONE);
		group.setText(Messages.RuntimeListComposite_Runtime_Platform);
		createComposite();
		group.setLayout(new FillLayout());
	}

	public void createSashForm(Composite parent) {
		sashForm = new SashForm(parent, SWT.NONE | SWT.VERTICAL);
		createGroup();
		createGroup1();
	}

	private void createGroup1() {
		group1 = new Group(sashForm, SWT.NONE);
		group1.setText(Messages.RuntimeListComposite_Device);
		group1.setLayout(new FillLayout());
		createComposite2();	
	}

	private void createComposite2() {
		composite2 = new Composite(group1, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite2.setLayout(gridLayout);
		createTable1();
		//createComposite3();
	}

	private void createTable1() {
		table1 = new Table(composite2, SWT.CHECK | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE);
		table1.setHeaderVisible(true);
		table1.setLinesVisible(true);
		GridData data = new GridData(GridData.FILL_BOTH);
		table1.setLayoutData(data);
	}

	private void createComposite1() {
		composite1 = new Composite(composite, SWT.NONE);

		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		gl.marginHeight = 2;
		gl.marginWidth = 2;
		gl.horizontalSpacing = 1;
		gl.verticalSpacing = 1;

		composite1.setLayout(gl);

		button = new Button(composite1, SWT.NONE);
		button.setText(Messages.RuntimeListComposite_Edit);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		button.setLayoutData(data);

		GridData data2 = new GridData(GridData.FILL_VERTICAL);
		data2.widthHint = 60;
		composite1.setLayoutData(data2);
	}

	private void createComposite3() {
		composite3 = new Composite(composite2, SWT.NONE);
		
		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		gl.marginHeight = 2;
		gl.marginWidth = 2;
		gl.horizontalSpacing = 1;
		gl.verticalSpacing = 1;

		composite3.setLayout(gl);

		button1 = new Button(composite3, SWT.NONE);
		button1.setText(Messages.RuntimeListComposite_Edit);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		button1.setLayoutData(data);
	
		GridData data2 = new GridData(GridData.FILL_VERTICAL);
		data2.widthHint = 60;
		composite3.setLayoutData(data2);
	}
}

