/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.model.RpmUIManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RuntimeListController implements SelectionListener, ICheckStateListener {
	private static Shell containerShell = new Shell();
	private MtjServiceHandler mtjServiceHandler = new MtjServiceHandler();
		
	private IMtjProject myProject;
	private Project myProjectData;
	private RuntimePlatform[] runtimes;
	private RuntimePlatform selectedRuntime;
	// private EList targetDevices;
	private TargetDevice defaultDevice;
	
	private RuntimeListComposite composite;
	
	// private Button editRuntimeButton;
	// private Button editDeviceButton;
	private CheckboxTableViewer runtimeTableViewer;
	private CheckboxTableViewer deviceTableViewer;
	
	public RuntimeListController(RuntimeListComposite composite, IMtjProject myProject, Project myProjectData) {
		this.composite = composite;

		this.myProject = myProject;
		this.myProjectData = myProjectData;
		
		//this.editRuntimeButton = composite.getEditRuntimeButton();
		//this.editDeviceButton = composite.getEditDeviceButton();
		this.runtimeTableViewer = composite.getRuntimeTableViewer();
		this.deviceTableViewer = composite.getDeviceTableViewer();
		//editRuntimeButton.setEnabled(false);
		
		runtimes = mtjServiceHandler.getRuntimePlatforms();
		// targetDevices = this.myProjectData.getTargetDevices();
		defaultDevice = this.myProjectData.getDefaultTargetDevice();
		
		checkRuntimes();
		setRuntimeData();
		setDeviceData();
		addListener();
	}

	private void checkRuntimes() {
		// TODO
		// selectedRuntime = this.myProjectData.getDefaultTargetDevice().get;
	}
	
	public TargetDevice getDefaultTargetDevice() {
		return defaultDevice;
	}
	
	private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
		TableColumn tableColumn = new TableColumn(table, SWT.NONE, index);
		tableColumn.setResizable(true);
		tableColumn.setWidth(widthHint);
		tableColumn.setText(title);
		return tableColumn;
	}
	
	private void setDeviceData() {
		class ArrayContentProvider implements IStructuredContentProvider 
		{
			public Object[] getElements(Object o) {
				if(o instanceof TargetDevice[] ) {
					return (Object[])o;
				} else return null;
			}
			
			public void dispose() {}		
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		}

		class dtlp extends LabelProvider implements ITableLabelProvider {
			public Image getColumnImage(Object element, int columnIndex) {
				  return null;
			}
			
			public String getColumnText(Object element, int columnIndex) {
				if(element instanceof TargetDevice) {
					TargetDevice d = (TargetDevice) element;
					if(columnIndex == 0) { return ""; } //$NON-NLS-1$
					else if(columnIndex == 1) { return d.getName(); }
					else if(columnIndex == 2) { return d.getDescription(); }
				}
				return null;
			}			
		}

		deviceTableViewer.setContentProvider(new ArrayContentProvider());
		deviceTableViewer.setLabelProvider(new dtlp());
		
		createTableColumn("", deviceTableViewer.getTable(), 0, 25); //$NON-NLS-1$
		createTableColumn(Messages.RuntimeListController_NameColumn, deviceTableViewer.getTable(), 1, 150);
		createTableColumn(Messages.RuntimeListController_DescriptionColumn, deviceTableViewer.getTable(), 2, 150);
		
		this.deviceTableViewer.setInput(new TargetDevice[] {defaultDevice});		
		this.deviceTableViewer.setChecked(defaultDevice, true);		
	}
	
	private void setRuntimeData() {
		class ArrayContentProvider implements IStructuredContentProvider 
		{
			public Object[] getElements(Object o) {
				if(o instanceof RuntimePlatform[]) {
					return (Object[])o;
				} else return null;
			}
			
			public void dispose() {}		
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		}

		class dtlp extends LabelProvider implements ITableLabelProvider {
			public Image getColumnImage(Object element, int columnIndex) {
				  return null;
			}
			
			public String getColumnText(Object element, int columnIndex) {
				if(element instanceof RuntimePlatform) {
					RuntimePlatform rp = (RuntimePlatform) element;
					if(columnIndex == 0) { return ""; } //$NON-NLS-1$
					else if(columnIndex == 1) { return rp.getName(); }
					else if(columnIndex == 2) { return rp.getDescription(); }
				}
				return null;
			}			
		}

		runtimeTableViewer.setContentProvider(new ArrayContentProvider());
		runtimeTableViewer.setLabelProvider(new dtlp());
		
		createTableColumn("", runtimeTableViewer.getTable(), 0, 25); //$NON-NLS-1$
		createTableColumn(Messages.RuntimeListController_NameColumn_2, runtimeTableViewer.getTable(), 1, 150);
		createTableColumn(Messages.RuntimeListController_DescriptionColumn_2, runtimeTableViewer.getTable(), 2, 150);
		
		this.runtimeTableViewer.setInput(runtimes);
		selectedRuntime = mtjServiceHandler.getRuntimePlatform(runtimes, defaultDevice);
		if(selectedRuntime != null) {
			runtimeTableViewer.setChecked(selectedRuntime,true);
		}
	}
	
	private void addListener() {
		//editRuntimeButton.addSelectionListener(this);
		//editDeviceButton.addSelectionListener(this);
		this.runtimeTableViewer.addCheckStateListener(this);
		this.deviceTableViewer.addCheckStateListener(this);
	}

	public void widgetDefaultSelected(SelectionEvent e) {}
	public void widgetSelected(SelectionEvent e) {
		/*
		if(e.widget == editRuntimeButton) {
			if(RpmUIManager.editRuntimePlatform(selectedRuntime, composite) == Dialog.OK) {
				mtjServiceHandler.storeRuntimes(runtimes);
				runtimes = mtjServiceHandler.getRuntimePlatforms();
				this.runtimeTableViewer.setInput(runtimes);
				if(selectedRuntime != null) {
					runtimeTableViewer.setChecked(selectedRuntime,true);
				}
			}
		}
		else if(e.widget == editDeviceButton) {
			RpmUIManager.editDevicePlatform(selectedRuntime, composite);
		}
		*/
	}

	public void checkStateChanged(CheckStateChangedEvent event) {
		boolean checkState = event.getChecked();
		Object o = event.getElement();
		if(o instanceof TargetDevice) {
			// defaultDevice = (TargetDevice) o; 
			deviceTableViewer.setChecked(o, true);	
		}
		else if(o instanceof RuntimePlatform) {
			ISelection selection = runtimeTableViewer.getSelection();
			RuntimePlatform rp = (RuntimePlatform) o;
			selectedRuntime = rp;
			runtimeTableViewer.setAllChecked(false);
			runtimeTableViewer.setChecked(rp, true);	
			defaultDevice = (TargetDevice) rp.getTargetDevices().get(0);
			
			if(checkState) {
				this.deviceTableViewer.setInput(new TargetDevice[] {defaultDevice});		
				this.deviceTableViewer.setChecked(defaultDevice, true);		
			}
			
		}
	}
}
