/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * MidletSuiteRequiredSection.java 2006 Mar 1, 2006 4:08:21 PM @author khorowit
 *
 */
public abstract class FormToolkitTemplate  {

		
	static public Text createTextEntry (String labelValue, String initialValue, FormToolkit formToolkit, Composite parent)
	{
		Label label = formToolkit.createLabel(parent, labelValue);
		Text  text = formToolkit.createText(parent, initialValue, SWT.SINGLE);
		
		text.setLayoutData(new GridData (GridData.FILL_HORIZONTAL));
		return text;
	}
	
	/**
	 * First item in list is selected
	 * @param labelValue
	 * @param initialValue
	 * @param optionsList
	 * @param parent
	 * @return
	 */
	static public CCombo createComboEntry (String labelValue, String initialValue, String[] optionsList, FormToolkit formToolkit, Composite parent)
	{
		Label label = formToolkit.createLabel(parent, labelValue);
	
		CCombo combo;

		combo = new CCombo(parent, SWT.DROP_DOWN | SWT.FLAT);  // Should switch to CCombo
		formToolkit.adapt(combo, true, true);
	
		combo.setLayoutData(new GridData (GridData.FILL_HORIZONTAL));

		//for (String options: optionsList)
		int count = optionsList.length;
		for (int i = 0; i < count; i++)
		{
			String options = optionsList[i];
			combo.add(options);
		}
    
		if (initialValue != null)
		{
			int index = combo.indexOf(initialValue);
			if (index >= 0)
				combo.select(index);
		}
		
		return combo;
	}

}
