/*******************************************************************************
* Copyright (c) 1998, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class RunnableActionExecutor implements IRunnableWithProgress {
	private String fActionName;
	private List fActionElements = new ArrayList();
	private Shell fTaskShell = MtjCoreUiPlugin.getActiveWorkbenchShell();	
	
	public RunnableActionExecutor(String taskName) {
		fActionName = taskName;
	}

	public boolean runWithDialog(Shell shell) {
		ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
		d.create(); // Force to create the shell etc...
		fTaskShell = d.getShell();
		try {
			d.run(true,true,this);
		} catch (InterruptedException e) {
			return false;
		} catch (InvocationTargetException e) {
			String title = Messages.RunnableActionExecutor_Project_Error; 
			MessageBox message = new MessageBox (shell, SWT.ICON_ERROR);
			// Add the received exception to try to locate this message
			// We are seeing it at random times, and need more information when
			// it occurs.
			message.setMessage(title + " " + e.getMessage()); //$NON-NLS-1$
			e.printStackTrace();
			message.open();
			return false;
		}
		
		return true;
	}
		
	public void insertInitialAction(RunnableAction act) {
		List newActions = new ArrayList();
		newActions.add(act);
		Iterator tIter = fActionElements.iterator();
		while (tIter.hasNext()) {
			newActions.add(tIter.next());
		}
		fActionElements = newActions;
	}			
	
	public void addAction(RunnableAction act) {
		fActionElements.add(act);
	}			
	
	public void addActions(RunnableAction[] acts) {
		for (int i = 0; i < acts.length; i++) {
			fActionElements.add(acts[i]);
		}
	}			
	
	/**
	 * 	 @see IRunnableWithProgress#run(IProgressMonitor) 
	 */
	public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
		monitor.beginTask(fActionName, calculateTotalWorkunits());
		Iterator tIter = fActionElements.iterator();
		while (tIter.hasNext()) {
			RunnableAction task = (RunnableAction)tIter.next();
			if (task.getName()!= null) 
				monitor.subTask(task.getName());

			task.getRunnable(fTaskShell).run(monitor);
			monitor.worked(task.getUnits());
		}
	}

	public int calculateTotalWorkunits() {
		Iterator taskIter = fActionElements.iterator();
		int result = 0;
		while (taskIter.hasNext()) {
			result += ((RunnableAction)taskIter.next()).getUnits();
		}
		return result;
	}
}

