/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.extension.devide.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

/**
 * Instances of this interface are called at appropriate times
 * to visit the classpath entries as they are traversed.  At any
 * time, each method may return <code>false</code> to stop traversing
 * that part of the classpath entry tree.
 */
public interface IClasspathEntryVisitor {
	/**
	 * Visit a classpath entry container.
	 * Return a boolean value specifying whether to resolve the entry
	 * and recursively visit the resolved entry.
	 * @param entry TODO
	 * @param javaProject
	 * @param containerName
	 * @param monitor
	 * 
	 * @return
	 * @throws CoreException
	 */
	public boolean visitContainer(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		String containerName, 
		IProgressMonitor monitor)
			throws CoreException;
	
	/**
	 * Visit a classpath library entry.
	 * @param entry
	 * @param javaProject
	 * @param monitor
	 * 
	 * @throws CoreException
	 */
	public void visitLibraryEntry(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		IProgressMonitor monitor)
			throws CoreException;
	
	/**
	 * Visit a classpath project entry.
	 * Return a boolean value specifying whether to resolve the entry
	 * and recursively visit the resolved entry.
	 * @param entry TODO
	 * @param javaProject
	 * @param classpathProject
	 * @param monitor
	 * 
	 * @return
	 * @throws CoreException
	 */
	public boolean visitProject(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		IJavaProject classpathProject, 
		String natureId,
		IProgressMonitor monitor)
			throws CoreException;
	
	/**
	 * Visit a classpath source entry.
	 * @param entry
	 * @param javaProject
	 * @param monitor
	 * 
	 * @throws CoreException
	 */
	public void visitSourceEntry(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		IProgressMonitor monitor)
			throws CoreException;

	/**
	 * Visit a classpath variable name entry.
	 * Return a boolean value specifying whether to resolve the entry
	 * and recursively visit the resolved entry.
	 * @param entry TODO
	 * @param javaProject
	 * @param variableName
	 * @param monitor
	 * 
	 * @return
	 * @throws CoreException
	 */
	public boolean visitVariable(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		String variableName, IProgressMonitor monitor)
			throws CoreException;
}
