/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/
package org.eclipse.mtj.extension.devide.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
//import org.eclipse.mtj.extension.smgmt.ui.actions.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputValidationDialog extends Dialog {


	private IInputValidator validator2;
	private IInputValidator validator1;
	private IInputValidator validator;
	private String title;
	private String message;
	private String message1;
	private String message2;
	private String value= "";//$NON-NLS-1$
	private Button okButton;
	private Text text;
	private Text text1;
	private Text text2;
	
	private String pass;
	private String pass1;
	private String pass2;
	
	private Label errorMessageLabel;
	private boolean enableok;


public InputValidationDialog(Shell parentShell, String dialogTitle, String dialogMessage, String dialogMessage1, String dialogMessage2, IInputValidator validator, IInputValidator validator1, IInputValidator validator2) {
	super(parentShell);
	this.title = dialogTitle;
	this.validator = validator;
	this.validator1 = validator1;
	this.validator2 = validator2;
	message = dialogMessage;
	message1 = dialogMessage1;
	message2 = dialogMessage2;
	enableok = false;
	
}

	protected void buttonPressed(int buttonId) {
		if (buttonId == OK) {
			if (message != null) {
				setPass(text.getText());
			}
			if (message1 != null) {
				setPass1(text1.getText());
			}
			if (message2 != null) {
				setPass2(text2.getText());
			}
		}
		
		super.buttonPressed(buttonId);

		
	}

protected void configureShell(Shell shell) {
	super.configureShell(shell);
	if (title != null)
		shell.setText(title);
}

protected void createButtonsForButtonBar(Composite parent) {
	// create OK and Cancel buttons by default
	okButton = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
	createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);

	//do this here because setting the text will set enablement on the ok button
	text.setFocus();
	if (value != null) {
		text.setText(value);
		text.selectAll();
	}
}

protected Control createDialogArea(final Composite parent) {
	
	// create composite
	Composite composite = (Composite)super.createDialogArea(parent);

	
		// create message
		if (message != null) {
			Label label = new Label(composite, SWT.WRAP);
			label.setText(message);
			GridData data = new GridData(
				GridData.GRAB_HORIZONTAL |
				GridData.GRAB_VERTICAL |
				GridData.HORIZONTAL_ALIGN_FILL |
				GridData.VERTICAL_ALIGN_CENTER);
			//data.widthHint = convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH);;
			data.widthHint = 200;
			label.setLayoutData(data);
			label.setFont(parent.getFont());
			
		
		text= new Text(composite, SWT.SINGLE | SWT.BORDER);
		text.setLayoutData(new GridData(
			GridData.GRAB_HORIZONTAL | 
			GridData.HORIZONTAL_ALIGN_FILL));
		//set echo char to * only if not custom permission dialog 
//	    if (message.compareTo(Messages.getString("MainDialog.Enter_custom_permission_to_add__59")) != 0) //$NON-NLS-1$
	    if (message.compareTo("dd") != 0) //$NON-NLS-1$
			text.setEchoChar('*');
		text.addModifyListener(
				new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						if (message1 == null) {
							enableok = true;
						}
						validateInput(validator, text, parent);
					}
				}
			);
		}
	
	
		if (message1 != null) {
			Label label = new Label(composite, SWT.WRAP);
			label.setText(message1);
			GridData data = new GridData(
					GridData.GRAB_HORIZONTAL |
					GridData.GRAB_VERTICAL |
					GridData.HORIZONTAL_ALIGN_FILL |
					GridData.VERTICAL_ALIGN_CENTER);
			data.widthHint = 200;
			label.setLayoutData(data);
			label.setFont(parent.getFont());
		
			text1= new Text(composite, SWT.SINGLE | SWT.BORDER);
			text1.setLayoutData(new GridData(
			GridData.GRAB_HORIZONTAL | 
			GridData.HORIZONTAL_ALIGN_FILL));
			text1.setEchoChar('*');
			text1.addModifyListener(
				new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						if (message2 == null){
							enableok = true;
							}
						validateInput(validator1, text1, parent);
					}
				}
			);
		}

			
		if (message2 != null) {
			Label label = new Label(composite, SWT.WRAP);
			label.setText(message2);
			GridData data = new GridData(
					GridData.GRAB_HORIZONTAL |
					GridData.GRAB_VERTICAL |
					GridData.HORIZONTAL_ALIGN_FILL |
					GridData.VERTICAL_ALIGN_CENTER);
			data.widthHint = 200;
			label.setLayoutData(data);
			label.setFont(parent.getFont());
		
		text2= new Text(composite, SWT.SINGLE | SWT.BORDER);
		text2.setLayoutData(new GridData(
		GridData.GRAB_HORIZONTAL | 
		GridData.HORIZONTAL_ALIGN_FILL));
		text2.setEchoChar('*');
		text2.addModifyListener(
				new ModifyListener() {
					public void modifyText(ModifyEvent e) {
						enableok = true;
						validateInput(validator2, text2, parent);
					}
				}
			);
		}


	errorMessageLabel = new Label(composite, SWT.WRAP);
	GridData msg = new GridData(
			GridData.GRAB_HORIZONTAL |
			GridData.HORIZONTAL_ALIGN_FILL);
	msg.heightHint = 35;
	errorMessageLabel.setLayoutData(msg);
	errorMessageLabel.setFont(parent.getFont());
	
	
	return composite;
}

protected Label getErrorMessageLabel() {
	return errorMessageLabel;
}

protected Button getOkButton() {
	return okButton;
}

/**
 * Returns the validator.
 *
 * @return the validator
 */
protected IInputValidator getValidator() {
	return validator;
}

/**
 * Validates the input text.
 * This method is called whenever the text changes in the
 * input field.
 */
protected void validateInput(IInputValidator validator, Text text, Composite parent) {

	String errorMessage = null;
	
	if (validator != null) {
		errorMessage = validator.isValid(text.getText());
	}
	
	// important not to treat "" (blank error) the same as null (no error)
	errorMessageLabel.setText(errorMessage == null ? "" : errorMessage); //$NON-NLS-1$
	Color red = new Color(parent.getShell().getDisplay(), 255,0,0);
	errorMessageLabel.setForeground(red);
	
	okButton.setEnabled(errorMessage == null && enableok == true);
	//okButton.setEnabled(errorMessage == null);

	errorMessageLabel.getParent().update();
}

	/**
	 * @return
	 */
	public String getPass() {
		return pass;
	}

	/**
	 * @return
	 */
	public String getPass1() {
		return pass1;
	}

	/**
	 * @return
	 */
	public String getPass2() {
		return pass2;
	}

	/**
	 * @param string
	 */
	public void setPass(String string) {
		pass = string;
	}

	/**
	 * @param string
	 */
	public void setPass1(String string) {
		pass1 = string;
	}

	/**
	 * @param string
	 */
	public void setPass2(String string) {
		pass2 = string;
	}
}
