/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mtj.core.util.DirUtil;
import org.eclipse.mtj.core.version.Version;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.config.LibrarySpecification;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MtjDevIdePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide";
    public static final String J2ME_CONFIGURATIONS_ID = Messages.MtjDevIdePlugin_ConfigurationId;
    public static final String J2ME_PROFILES_ID = Messages.MtjDevIdePlugin_ProfileId;
    public static final String TEMPLATES_DIR = "templates";
    public static final String MIDP_TEMPLATES_DIR = "MIDP";
    public static final String PPRO_TEMPLATES_DIR = "PPRO";
    public static final String JAR_FILE_EXTENSION_SEPERATOR = ".jar!";
    public static final String JAR_FILE_SEPERATOR = "!";
    public static final String FILE_PROTOCOL = "file:";
    public static final String TEMPLATE_EXTENSION = ".template";
    public static final byte MTJ_TEMPLATE_MIDP = 1;
    public static final byte MTJ_TEMPLATE_PPRO = 2;
    private LibrarySpecification[] configSpecs;
    private LibrarySpecification[] profileSpecs;
    private static MtjDevIdePlugin plugin;

    public MtjDevIdePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static MtjDevIdePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static LibrarySpecification[] getConfigurationSpecifications() throws CoreException {
        MtjDevIdePlugin plugin = MtjDevIdePlugin.getDefault();
        if (plugin.configSpecs == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, J2ME_CONFIGURATIONS_ID);
            IConfigurationElement[] configElements = point.getConfigurationElements();
            plugin.configSpecs = new LibrarySpecification[configElements.length];
            int i = 0;
            while (i < configElements.length) {
                plugin.configSpecs[i] = MtjDevIdePlugin.createComponentSpecification(configElements[i]);
                ++i;
            }
        }
        return plugin.configSpecs;
    }

    private static LibrarySpecification createComponentSpecification(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        String versionString = element.getAttribute("version");
        Version version = new Version(versionString);
        LibrarySpecification specification = new LibrarySpecification();
        specification.setIdentifier(id);
        specification.setName(name);
        specification.setVersion(version);
        return specification;
    }

    public static LibrarySpecification[] getProfileSpecifications() throws CoreException {
        MtjDevIdePlugin plugin = MtjDevIdePlugin.getDefault();
        if (plugin.profileSpecs == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, J2ME_PROFILES_ID);
            IConfigurationElement[] configElements = point.getConfigurationElements();
            plugin.profileSpecs = new LibrarySpecification[configElements.length];
            int i = 0;
            while (i < configElements.length) {
                plugin.profileSpecs[i] = MtjDevIdePlugin.createComponentSpecification(configElements[i]);
                ++i;
            }
        }
        return plugin.profileSpecs;
    }

    public static String getPluginIconsDir() {
        return MtjDevIdePlugin.getInstallLocation().append("/icons").toString();
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        super.initializeImageRegistry(imageRegistry);
        try {
            ArrayList images = DirUtil.getAllFilesInDirectory((String)MtjDevIdePlugin.getPluginIconsDir(), (boolean)true, (boolean)true, (String)"*.gif");
            for (String fileName : images) {
                int pos = fileName.indexOf("/icons/");
                if (pos == -1) continue;
                String imageKey = fileName.substring(pos += 7);
                imageRegistry.put(imageKey, ImageDescriptor.createFromURL((URL)new URL(FILE_PROTOCOL + fileName)));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static ImageRegistry getMtjImageRegistry() {
        return MtjDevIdePlugin.getDefault().getImageRegistry();
    }

    public static String getPluginId() {
        return MtjDevIdePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Path getInstallLocation() {
        try {
            Bundle bundle = MtjDevIdePlugin.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
            String s1 = FileLocator.resolve((URL)url).getFile();
            if (s1.startsWith("/")) {
                s1 = s1.substring(1);
            }
            String s = (s1 = new Path(s1).toOSString()).endsWith(File.separator) ? s1 : String.valueOf(s1) + File.separator;
            return new Path(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getTemplateFiles(byte type) {
        File templatesDir = null;
        ArrayList<String> filteredFileList = new ArrayList<String>();
        templatesDir = new File(MtjDevIdePlugin.getTemplatesPath(type).toOSString());
        if (MtjDevIdePlugin.isJarfile(templatesDir.getPath())) {
            String jarFileName = templatesDir.toString();
            int index = jarFileName.indexOf(JAR_FILE_SEPERATOR);
            if (index != -1) {
                jarFileName = jarFileName.substring(0, index);
            }
            try {
                JarFile pluginjarfile = new JarFile(jarFileName);
                Enumeration<JarEntry> jarentries = null;
                jarentries = pluginjarfile.entries();
                String entrieName = null;
                while (jarentries.hasMoreElements()) {
                    entrieName = ((ZipEntry)jarentries.nextElement()).getName();
                    if (!entrieName.contains(type == 1 ? MIDP_TEMPLATES_DIR : PPRO_TEMPLATES_DIR) || !entrieName.endsWith(TEMPLATE_EXTENSION)) continue;
                    filteredFileList.add(MtjDevIdePlugin.getLastSegment(entrieName));
                }
            }
            catch (IOException iOException) {
                filteredFileList.add("NULL");
            }
        } else {
            String[] dirFileArray = templatesDir.list();
            int i = 0;
            while (i < dirFileArray.length) {
                if (dirFileArray[i].endsWith(TEMPLATE_EXTENSION)) {
                    filteredFileList.add(dirFileArray[i]);
                }
                ++i;
            }
        }
        return filteredFileList.toArray(new String[filteredFileList.size()]);
    }

    public static Path getTemplatesPath(byte type) {
        StringBuffer sb = new StringBuffer(MtjDevIdePlugin.getInstallLocation().toOSString());
        sb.append(MtjDevIdePlugin.getTemplatesSegments(type));
        Path pa = new Path(MtjDevIdePlugin.removeProtocol(sb.toString()));
        return pa;
    }

    public static String getTemplatesSegments(byte type) {
        Path p = new Path(TEMPLATES_DIR + File.separator + (type == 1 ? MIDP_TEMPLATES_DIR : PPRO_TEMPLATES_DIR));
        return p.toOSString();
    }

    private static String removeProtocol(String templatesPath) {
        int index = 0;
        if (templatesPath.startsWith(FILE_PROTOCOL)) {
            index = FILE_PROTOCOL.length();
        }
        return templatesPath.substring(index);
    }

    private static boolean isJarfile(String templatesPath) {
        return templatesPath.contains(JAR_FILE_EXTENSION_SEPERATOR);
    }

    private static String getLastSegment(String entrieName) {
        Path tempPath = new Path(entrieName);
        return tempPath.lastSegment();
    }
}

