/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PackageMidletSuiteAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private IWorkbenchWindow fWorkbenchWindow;
    private IStructuredSelection fSelection;

    public void run(IAction action) {
        Shell shell = MtjDevIdePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        new ProgressMonitorDialog(shell);
        IProject project = this.fSelection.getFirstElement() instanceof IJavaProject ? ((IJavaProject)this.fSelection.getFirstElement()).getProject() : (IProject)this.fSelection.getFirstElement();
        try {
            Shell parentShell = this.getShell();
            JarPackageData description = new JarPackageData();
            description.setExportClassFiles(true);
            IResource[] projectMembers = project.members();
            Vector<IResource> exportFiles = new Vector<IResource>();
            int i = 0;
            while (i < projectMembers.length) {
                String fileExtension;
                IResource manifest;
                IFolder folder;
                IResource thisMember = projectMembers[i];
                if (thisMember instanceof IFolder && (folder = (IFolder)thisMember).getName().compareTo("META-INF") == 0 && (manifest = folder.findMember("MANIFEST.MF")) != null) {
                    description.setSaveManifest(true);
                    description.setManifestLocation(manifest.getFullPath());
                    description.setUsesManifest(true);
                    description.setGenerateManifest(false);
                    thisMember = manifest;
                }
                if (thisMember instanceof IFile && (fileExtension = thisMember.getFileExtension()) != null) {
                    if (thisMember.getName().compareTo("MANIFEST.MF") == 0) {
                        exportFiles.add(thisMember);
                    } else if (fileExtension.compareTo("class") == 0) {
                        exportFiles.add(thisMember);
                    } else if (fileExtension.compareTo("jad") == 0) {
                        exportFiles.add(thisMember);
                    }
                }
                ++i;
            }
            Path location = new Path("C:/myjar.jar");
            description.setJarLocation((IPath)location);
            description.setElements(exportFiles.toArray());
            IJarExportRunnable runnable = description.createJarExportRunnable(parentShell);
            try {
                new ProgressMonitorDialog(parentShell).run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(this.getSelection()));
        }
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        return true;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fWorkbenchWindow = targetEditor.getEditorSite().getWorkbenchWindow();
        this.selectionChanged(action, targetEditor.getEditorSite().getSelectionProvider().getSelection());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchWindow = targetPart.getSite().getWorkbenchWindow();
        if (targetPart.getSite().getSelectionProvider() != null) {
            this.selectionChanged(action, targetPart.getSite().getSelectionProvider().getSelection());
        }
    }

    public void init(IViewPart view) {
        this.fWorkbenchWindow = view.getSite().getWorkbenchWindow();
        this.selectionChanged(null, view.getSite().getSelectionProvider().getSelection());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
        this.selectionChanged(null, window.getSelectionService().getSelection());
    }

    protected IStructuredSelection getSelection() {
        if (this.fSelection instanceof IStructuredSelection) {
            return this.fSelection;
        }
        return new StructuredSelection();
    }

    protected Shell getShell() {
        return this.getWorkbenchWindow().getShell();
    }

    protected IWorkbench getWorkbench() {
        return this.getWorkbenchWindow().getWorkbench();
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }
}

