/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.action;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.BuildManagement;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.action.AbstractJavaProjectAction;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class ToggleProjectBuildAction
extends AbstractJavaProjectAction {
    private IStructuredSelection currentProjectSelection = null;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private IProject findProject(IProject project) throws CoreException {
        IProject[] projects = EclipseUtil.getProjectsForNature((String)MtjNature.getNatureID());
        int i = 0;
        while (i < projects.length) {
            if (projects[i] == project) {
                return projects[i];
            }
            ++i;
        }
        MessageDialog.openInformation((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_InformationDialogTitle, (String)Messages.ToggleProjectBuildAction_ProjectNotMtj);
        return null;
    }

    private IProject getProject() {
        if (this.currentProjectSelection.getFirstElement() instanceof IJavaProject) {
            return ((IJavaProject)this.currentProjectSelection.getFirstElement()).getProject();
        }
        return (IProject)this.currentProjectSelection.getFirstElement();
    }

    private void openMtjExceptionDialog(MtjException e) {
        ErrorDialog.openError((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error_while_building_project, (String)e.getMessage(), (IStatus)new Status(4, "org.eclipse.mtj.core.ui", -1, e.toString(), (Throwable)e));
    }

    private void openCoreExceptionDialog(CoreException e) {
        ErrorDialog.openError((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error, (String)this.getClass().getName(), (IStatus)e.getStatus());
    }

    private void processProjectData(IProject project, BuildManagement bm) throws MtjException {
        IMtjProject proj = MtjProject.getMtjProject(project);
        Project data = proj.getProjectData();
        if (data == null || data.getDefaultTargetDevice() == null || data.getDefaultTargetDevice().getRuntimePlatform() == null) {
            MessageDialog.openInformation((Shell)MtjCorePlugin.getActiveShell(), (String)Messages.ToggleProjectBuildAction_Error_while_building_project_2, (String)Messages.ToggleProjectBuildAction_Project_default_target_device_not_selected);
        } else {
            RuntimePlatformDefinition rpd = data.getDefaultTargetDevice().getRuntimePlatform();
            IMtjProject mtjproject = MtjProject.getMtjProject(project);
            bm.build(mtjproject, MtjNature.getNatureID(), BuildType.BUILD_TYPE_ECLIPSE_LITERAL, rpd, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void run(IAction action) {
        try {
            IProject project = this.findProject(this.getProject());
            if (project != null) {
                BuildManagement bm = (BuildManagement)MtjServices.getInstance().getImplementations(ExtensionType.BUILD_MANAGEMENT_LITERAL, null, null, true)[0];
                this.processProjectData(project, bm);
            }
        }
        catch (MtjException e) {
            this.openMtjExceptionDialog(e);
        }
        catch (CoreException ce) {
            this.openCoreExceptionDialog(ce);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentProjectSelection = (IStructuredSelection)selection;
        }
    }
}

