/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.ui.util.ExecutableSelectionDialogCreator;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.launching.DeviceTab;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JavaTab
extends JavaMainTab {
    private Button fSearchButton;
    private Button fProjButton;
    private DeviceTab deviceTab;
    private Label projectLabel;
    private Text executableText;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectComponents(comp);
        this.createVerticalSpacer(comp, 1);
        this.createExecutableComponents(comp);
        this.updateEnablement();
    }

    public DeviceTab getDeviceTab() {
        return this.deviceTab;
    }

    public String getName() {
        return Messages.launchtab_executable_title;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            this.fProjText.setText(projectName);
        }
        catch (CoreException coreException) {}
        String midletName = this.getStringOrDefault(config, "org.eclipse.mtj.executable_class", "");
        this.executableText.setText(midletName);
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            MtjCorePlugin.getDefault();
            if (!MtjCorePlugin.getWorkspace().getRoot().getProject(name).exists()) {
                this.setErrorMessage(Messages.launchtab_executable_error_project_does_not_exist);
                return false;
            }
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjText.getText().trim());
        try {
            if (!MtjNature.hasMtjNature(project)) {
                this.setErrorMessage(Messages.launchtab_executable_error_project_has_not_mtj_nature);
                return false;
            }
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.launchtab_executable_error_while_checking_project_nature);
            return false;
        }
        name = this.executableText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(Messages.launchtab_executable_error_Executable_not_specified);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute("org.eclipse.mtj.executable_class", this.executableText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        config.setAttribute("org.eclipse.mtj.executable_class", "");
    }

    public void setDeviceTab(DeviceTab tab) {
        this.deviceTab = tab;
    }

    protected void handleSearchButtonSelected() {
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject != null) {
                IType type;
                Object[] results;
                IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
                IJavaSearchScope searchScope = mtjProject.getJavaSearchScope(javaProject);
                SelectionDialog dialog = ExecutableSelectionDialogCreator.createExecutableSelectionDialog((Shell)this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaSearchScope)searchScope, (boolean)false);
                if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                    this.executableText.setText(type.getFullyQualifiedName());
                    javaProject = type.getJavaProject();
                    this.fProjText.setText(javaProject.getElementName());
                }
            }
        }
        catch (CoreException e) {
            MtjCorePlugin.log((int)4, (String)Messages.JavaTab_3, (Throwable)e);
        }
        catch (MtjException e) {
            MtjCorePlugin.log((int)4, (String)Messages.JavaTab_4, (Throwable)e);
        }
    }

    private void createExecutableComponents(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(Messages.JavaTab_5);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        group.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.createExecutableComponents(group);
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = "";
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log((Throwable)ce);
        }
        if (this.fMainText != null) {
            this.fMainText.setText(mainTypeName);
        }
    }

    private void createExecutableComponents(Group parent) {
        Font font = parent.getFont();
        Composite composite = new Composite((Composite)parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        composite.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setFont(font);
        this.executableText = new Text(composite, 2052);
        gd = new GridData(768);
        this.executableText.setLayoutData((Object)gd);
        this.executableText.setFont(font);
        this.executableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(composite, Messages.launchtab_executable_search, null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void createMainTypeEditor(Composite parent, String text, Button[] buttons) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(text);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fMainText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaTab.this.updateLaunchConfigurationDialog();
            }
        });
        if (buttons != null) {
            int i = 0;
            while (i < buttons.length) {
                buttons[i].setParent((Composite)mainGroup);
                ++i;
            }
        }
    }

    private void createProjectComponents(Composite parent) {
        Font font = parent.getFont();
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.projectLabel = new Label(projComp, 0);
        this.projectLabel.setText(Messages.launchtab_executable_project);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gd);
        this.projectLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaTab.this.updateLaunchConfigurationDialog();
                JavaTab.this.deviceTab.setJavaProject(JavaTab.this.getJavaProject());
            }
        });
        this.fProjButton = this.createPushButton(projComp, Messages.launchtab_executable_browse, null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaTab.this.handleProjectButtonSelected();
            }
        });
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(Messages.JavaTab_Main);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.getDefaultListener());
    }

    public IJavaProject getJavaProject() {
        if (this.fProjText == null || this.fProjText.getText() == null || this.fProjText.getText().equals(Messages.JavaTab_6)) {
            return null;
        }
        return super.getJavaProject();
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            MtjCorePlugin.log((int)2, (Throwable)e);
            value = defaultValue;
        }
        return value;
    }

    private void updateEnablement() {
        this.executableText.setEnabled(true);
        this.fSearchButton.setEnabled(true);
    }
}

