/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.properties;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.properties.RuntimeListComposite;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.model.RpmUIManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RuntimeListController
implements SelectionListener,
ICheckStateListener {
    private static Shell containerShell = new Shell();
    private MtjServiceHandler mtjServiceHandler = new MtjServiceHandler();
    private IMtjProject myProject;
    private Project myProjectData;
    private RuntimePlatform[] runtimes;
    private RuntimePlatform selectedRuntime;
    private TargetDevice defaultDevice;
    private RuntimeListComposite composite;
    private Button editRuntimeButton;
    private Button editDeviceButton;
    private CheckboxTableViewer runtimeTableViewer;
    private CheckboxTableViewer deviceTableViewer;

    public RuntimeListController(RuntimeListComposite composite, IMtjProject myProject, Project myProjectData) {
        this.composite = composite;
        this.myProject = myProject;
        this.myProjectData = myProjectData;
        this.editRuntimeButton = composite.getEditRuntimeButton();
        this.editDeviceButton = composite.getEditDeviceButton();
        this.runtimeTableViewer = composite.getRuntimeTableViewer();
        this.deviceTableViewer = composite.getDeviceTableViewer();
        this.editRuntimeButton.setEnabled(false);
        this.runtimes = this.mtjServiceHandler.getRuntimePlatforms();
        this.defaultDevice = this.myProjectData.getDefaultTargetDevice();
        this.checkRuntimes();
        this.setRuntimeData();
        this.setDeviceData();
        this.addListener();
    }

    private void checkRuntimes() {
    }

    public TargetDevice getDefaultTargetDevice() {
        return this.defaultDevice;
    }

    private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
        TableColumn tableColumn = new TableColumn(table, 0, index);
        tableColumn.setResizable(true);
        tableColumn.setWidth(widthHint);
        tableColumn.setText(title);
        return tableColumn;
    }

    private void setDeviceData() {
        private class ArrayContentProvider
        implements IStructuredContentProvider {
            ArrayContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof TargetDevice[]) {
                    return (Object[])o;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.deviceTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        private class Dtlp
        extends LabelProvider
        implements ITableLabelProvider {
            Dtlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof TargetDevice) {
                    TargetDevice d = (TargetDevice)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return d.getName();
                    }
                    if (columnIndex == 2) {
                        return d.getDescription();
                    }
                }
                return null;
            }
        }
        this.deviceTableViewer.setLabelProvider((IBaseLabelProvider)new Dtlp());
        RuntimeListController.createTableColumn("", this.deviceTableViewer.getTable(), 0, 25);
        RuntimeListController.createTableColumn(Messages.RuntimeListController_NameColumn, this.deviceTableViewer.getTable(), 1, 150);
        RuntimeListController.createTableColumn(Messages.RuntimeListController_DescriptionColumn, this.deviceTableViewer.getTable(), 2, 150);
        this.deviceTableViewer.setInput((Object)new TargetDevice[]{this.defaultDevice});
        this.deviceTableViewer.setChecked((Object)this.defaultDevice, true);
    }

    private void setRuntimeData() {
        private class ArrayContentProvider
        implements IStructuredContentProvider {
            ArrayContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof RuntimePlatform[]) {
                    return (Object[])o;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.runtimeTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        private class Dtlp
        extends LabelProvider
        implements ITableLabelProvider {
            Dtlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof RuntimePlatform) {
                    RuntimePlatform rp = (RuntimePlatform)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return rp.getName();
                    }
                    if (columnIndex == 2) {
                        return rp.getDescription();
                    }
                }
                return null;
            }
        }
        this.runtimeTableViewer.setLabelProvider((IBaseLabelProvider)new Dtlp());
        RuntimeListController.createTableColumn("", this.runtimeTableViewer.getTable(), 0, 25);
        RuntimeListController.createTableColumn(Messages.RuntimeListController_NameColumn_2, this.runtimeTableViewer.getTable(), 1, 150);
        RuntimeListController.createTableColumn(Messages.RuntimeListController_DescriptionColumn_2, this.runtimeTableViewer.getTable(), 2, 150);
        this.runtimeTableViewer.setInput((Object)this.runtimes);
        this.selectedRuntime = this.mtjServiceHandler.getRuntimePlatform(this.runtimes, this.defaultDevice);
        if (this.selectedRuntime != null) {
            this.runtimeTableViewer.setChecked((Object)this.selectedRuntime, true);
        }
    }

    private void addListener() {
        this.editRuntimeButton.addSelectionListener((SelectionListener)this);
        this.editDeviceButton.addSelectionListener((SelectionListener)this);
        this.runtimeTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.deviceTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.editRuntimeButton) {
            if (RpmUIManager.editRuntimePlatform((RuntimePlatform)this.selectedRuntime, (Composite)this.composite) == 0) {
                MtjServiceHandler.storeRuntimes((RuntimePlatform[])this.runtimes);
                this.runtimes = this.mtjServiceHandler.getRuntimePlatforms();
                this.runtimeTableViewer.setInput((Object)this.runtimes);
                if (this.selectedRuntime != null) {
                    this.runtimeTableViewer.setChecked((Object)this.selectedRuntime, true);
                }
            }
        } else if (e.widget == this.editDeviceButton) {
            RpmUIManager.editDevicePlatform((RuntimePlatform)this.selectedRuntime, (Composite)this.composite);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checkState = event.getChecked();
        Object o = event.getElement();
        if (o instanceof TargetDevice) {
            this.deviceTableViewer.setChecked(o, true);
        } else if (o instanceof RuntimePlatform) {
            RuntimePlatform rp;
            this.runtimeTableViewer.getSelection();
            this.selectedRuntime = rp = (RuntimePlatform)o;
            this.runtimeTableViewer.setAllChecked(false);
            this.runtimeTableViewer.setChecked((Object)rp, true);
            this.defaultDevice = (TargetDevice)rp.getTargetDevices().get(0);
            if (checkState) {
                this.deviceTableViewer.setInput((Object)new TargetDevice[]{this.defaultDevice});
                this.deviceTableViewer.setChecked((Object)this.defaultDevice, true);
            }
        }
    }
}

