/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.FormToolkitTemplate;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.mtj.jad.util.MidletSearchEngine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MidletAdditionDialog
extends Dialog
implements SelectionListener {
    IProject project;
    JadFileDescriptor jadFileDescriptor;
    MIDletDescriptor midlet;
    Text midletName;
    Text midletIcon;
    org.eclipse.swt.widgets.List midletList;

    public MidletAdditionDialog(IProject project, JadFileDescriptor jadFileDescriptor, Shell parentShell) {
        super(parentShell);
        this.project = project;
        this.jadFileDescriptor = jadFileDescriptor;
        this.midlet = new MIDletDescriptor("", "", "");
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        Form form = formToolkit.createForm(parent);
        Composite body = form.getBody();
        GridLayout bodyLayout = new GridLayout();
        bodyLayout.numColumns = 1;
        body.setLayout((Layout)bodyLayout);
        Composite midletNameBox = formToolkit.createComposite(body);
        this.midletName = FormToolkitTemplate.createTextEntry(Messages.MidletAdditionDialog_Name_of_MIDlet, "", formToolkit, midletNameBox);
        this.midletName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MidletAdditionDialog.this.midlet.setName(MidletAdditionDialog.this.midletName.getText());
            }
        });
        GridLayout midletNameLayout = new GridLayout();
        midletNameLayout.numColumns = 2;
        midletNameBox.setLayout((Layout)midletNameLayout);
        midletNameBox.setLayoutData((Object)new GridData(768));
        formToolkit.paintBordersFor(midletNameBox);
        Composite iconBox = formToolkit.createComposite(body);
        GridLayout iconBoxLayout = new GridLayout();
        iconBoxLayout.numColumns = 3;
        iconBox.setLayout((Layout)iconBoxLayout);
        this.midletIcon = FormToolkitTemplate.createTextEntry(Messages.MidletAdditionDialog_Icon_for_MIDlet, "", formToolkit, iconBox);
        this.midletIcon.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MidletAdditionDialog.this.midlet.setIcon(MidletAdditionDialog.this.midletIcon.getText());
            }
        });
        this.midletIcon.setLayoutData((Object)new GridData(768));
        formToolkit.createButton(iconBox, Messages.MidletAdditionDialog_Browse, 8);
        formToolkit.paintBordersFor(iconBox);
        this.midletList = this.createMidletClassSelection(formToolkit, body);
        this.midletList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] selection = MidletAdditionDialog.this.midletList.getSelection();
                MidletAdditionDialog.this.midlet.setClassname(selection[0]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String[] selection = MidletAdditionDialog.this.midletList.getSelection();
                MidletAdditionDialog.this.midlet.setClassname(selection[0]);
            }
        });
        formToolkit.paintBordersFor(body);
        return body;
    }

    private org.eclipse.swt.widgets.List createMidletClassSelection(FormToolkit formToolkit, Composite parent) {
        Composite fMidletSelectionControl = formToolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        fMidletSelectionControl.setLayout((Layout)layout);
        fMidletSelectionControl.setLayoutData((Object)new GridData(1808));
        Label label = new Label(fMidletSelectionControl, 16416);
        label.setText(Messages.MidletAdditionDialog_Availabe_Midlets);
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(fMidletSelectionControl, 2820);
        GridData gd2 = new GridData(1808);
        list.setLayoutData((Object)gd2);
        list.addSelectionListener((SelectionListener)this);
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            pmd.open();
            List midlets = MidletSearchEngine.searchSubtypes((IResource)this.project, (IProgressMonitor)pmd.getProgressMonitor());
            pmd.close();
            int toBeSelected = 0;
            int i = 0;
            int max = midlets.size();
            while (i < max) {
                String name = ((IType)midlets.get(i)).getFullyQualifiedName();
                if (this.midlet != null && name.equals(this.midlet.getClassname())) {
                    toBeSelected = i;
                }
                list.add(name);
                if (i == toBeSelected) {
                    list.setSelection(i);
                    list.setTopIndex(i);
                    this.midlet.setClassname(name);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        formToolkit.paintBordersFor(fMidletSelectionControl);
        return list;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public MIDletDescriptor getMIDletDescriptor() {
        if (this.getReturnCode() == 0) {
            String name = this.midlet.getName();
            String className = this.midlet.getClassname();
            String iconName = this.midlet.getIcon();
            MIDletDescriptor midletDescriptor = new MIDletDescriptor(name, iconName, className);
            return midletDescriptor;
        }
        return null;
    }
}

