/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuiteSectionRequired;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.SynchronizeManifestFileToJad;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MidletSuitePackagingWizardPage
extends WizardPage {
    IProject project = null;
    JadFileDescriptor jadFile;
    MidletSuiteSectionRequired requiredSection = null;

    public MidletSuitePackagingWizardPage(String pageName, JadFileDescriptor jadFile) {
        super(pageName);
        this.jadFile = jadFile;
        this.setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png"));
    }

    public MidletSuitePackagingWizardPage(String pageName, JadFileDescriptor jadFile, IProject project) {
        super(pageName);
        this.jadFile = jadFile;
        this.project = project;
        this.setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png"));
    }

    public MidletSuitePackagingWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.jadFile = JadFileDescriptor.getDescriptor();
        this.setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png"));
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.MidletSuitePackagingWizardPage_Configure_midlet_suite);
        this.setDescription(Messages.MidletSuitePackagingWizardPage_Configure_application_package);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        GridLayout gdLayout = new GridLayout();
        form.getBody().setLayout((Layout)gdLayout);
        this.requiredSection = new MidletSuiteSectionRequired(this.jadFile, form.getBody(), toolkit, 384);
        this.setControl((Control)form);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public Control getControl() {
        if (this.project != null && this.requiredSection != null) {
            this.requiredSection.initializeData(this.project.getName());
        }
        return super.getControl();
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setProjectName(String projectName) {
        this.requiredSection.initializeData(projectName);
    }

    public void doFinish() {
        this.jadFile = this.requiredSection.getJadFile();
        IFile jadIFile = this.project.getFile(String.valueOf(this.project.getName().replace(' ', '_')) + Messages.MidletSuitePackagingWizardPage_0);
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            this.jadFile.serialize(jadIFile, (IProgressMonitor)pm);
            SynchronizeManifestFileToJad info = new SynchronizeManifestFileToJad(jadIFile);
            info.run((IProgressMonitor)pm);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

