/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJNewProjectSelectLibraryWizardPage;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJNewProjectTemplatePage;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJNewProjectWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ProjectCreationAction
implements IRunnableWithProgress {
    public static final String NAME = Messages.ProjectCreationAction_Creating_java_project;
    private NewJavaProjectWizardPage fJavaPage;
    private MTJNewProjectSelectLibraryWizardPage fJavaSDKPage;
    private MidletSuitePackagingWizardPage fMidletSuitePage;
    private MTJNewProjectTemplatePage fNewProjTemplatePage;
    private Shell fShell;
    private ProjectCreationModel projectModel;

    public ProjectCreationAction(MTJNewProjectWizardPage javaPage, MTJNewProjectSelectLibraryWizardPage javaSDKPage, MidletSuitePackagingWizardPage fMidletSuitePage, MTJNewProjectTemplatePage templatesPage, ProjectCreationModel projectModel, Shell shell) {
        this.fJavaPage = javaPage;
        this.fJavaSDKPage = javaSDKPage;
        this.fMidletSuitePage = fMidletSuitePage;
        this.fShell = shell;
        this.fNewProjTemplatePage = templatesPage;
        this.projectModel = projectModel;
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        this.runFromWizardpage(pm);
    }

    public static String[] updateNatureListWithoutDuplicates(String[] natures, String nature) {
        String[] newNatures = new String[natures.length + 1];
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(nature)) {
                return natures;
            }
            newNatures[i] = natures[i];
            ++i;
        }
        newNatures[natures.length] = nature;
        return newNatures;
    }

    public void addNatures(IProject project, String[] naturesToAdd, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < naturesToAdd.length) {
            natures = ProjectCreationAction.updateNatureListWithoutDuplicates(natures, naturesToAdd[i]);
            ++i;
        }
        description.setNatureIds(natures);
        project.setDescription(description, 64, monitor);
    }

    public void runFromWizardpage(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invException = new InvocationTargetException[1];
        final InterruptedException[] interruptedException = new InterruptedException[1];
        Display display = this.fShell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                SubProgressMonitor pm = new SubProgressMonitor(monitor, 10);
                try {
                    try {
                        ProjectCreationAction.this.fJavaPage.getRunnable().run((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 8));
                        IJavaProject project = ProjectCreationAction.this.fJavaPage.getNewJavaProject();
                        ProjectCreationAction.this.projectModel.setProperty("ppc.jproject", (Object)project);
                        IWorkbenchWindow w = MtjCoreUiPlugin.getActiveWorkbenchWindow();
                        BasicNewResourceWizard.selectAndReveal((IResource)project.getProject(), (IWorkbenchWindow)w);
                        String nature = (String)ProjectCreationAction.this.projectModel.getProperty("ppc.nature");
                        ProjectCreationAction.this.addNatures(project.getProject(), new String[]{nature}, (IProgressMonitor)pm);
                        TargetDevice[] projectModelData = ProjectCreationAction.this.fJavaSDKPage.getProjectModelData();
                        if (ProjectCreationAction.this.fMidletSuitePage != null) {
                            ProjectCreationAction.this.storeProjectData(project, ProjectType.PROJECT_TYPE_MIDP_LITERAL, projectModelData);
                        } else {
                            ProjectCreationAction.this.storeProjectData(project, ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL, projectModelData);
                        }
                        IMtjProject mtjproject = MtjProject.getMtjProject(project);
                        if (ProjectCreationAction.this.fMidletSuitePage != null) {
                            ProjectCreationAction.this.fMidletSuitePage.setProject(project.getProject());
                            ProjectCreationAction.this.fMidletSuitePage.doFinish();
                        }
                        if (ProjectCreationAction.this.fNewProjTemplatePage != null) {
                            ProjectCreationAction.this.fNewProjTemplatePage.setProject(project.getProject());
                            if (ProjectCreationAction.this.fJavaPage instanceof MTJNewProjectWizardPage) {
                                ProjectCreationAction.this.fNewProjTemplatePage.setSrcPath(((MTJNewProjectWizardPage)ProjectCreationAction.this.fJavaPage).getSrcEntry());
                            }
                            ProjectCreationAction.this.fNewProjTemplatePage.doFinish();
                        }
                        mtjproject.initializeNewProject((IProgressMonitor)pm);
                    }
                    catch (MtjException e) {
                        invException[0] = new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        invException[0] = new InvocationTargetException(e);
                    }
                    catch (InterruptedException e) {
                        interruptedException[0] = e;
                    }
                    catch (InvocationTargetException e) {
                        invException[0] = e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    pm.done();
                }
            }
        });
        if (interruptedException[0] != null) {
            throw interruptedException[0];
        }
        if (invException[0] != null) {
            throw invException[0];
        }
    }

    private void storeProjectData(IJavaProject javaProject, ProjectType projectType, TargetDevice[] targetDevice) throws MtjException {
        Project project = ProjectFactory.eINSTANCE.createProject();
        project.setType(projectType);
        if (targetDevice != null && targetDevice.length > 0) {
            project.setDefaultTargetDevice(targetDevice[0]);
        }
        if (targetDevice != null && targetDevice.length > 1) {
            int i = 1;
            while (i < targetDevice.length) {
                project.getTargetDevices().add((Object)targetDevice[i]);
                ++i;
            }
        }
        MtjProject.setProjectData(javaProject, project);
    }
}

