/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.preferences;

import java.util.Hashtable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.ui.Messages;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformDirectoryEditor;
import org.eclipse.mtj.extension.dm.ui.util.DevicePlatformImportContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.PreferenceUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class AddDevicePlatformDialog2
extends TitleAreaDialog {
    private DirectoryFieldEditor rootEditor;
    private Combo providerCombo;
    private CheckboxTreeViewer dpTree;
    private Hashtable dppList;
    private Composite mainContainer;
    private Composite subContainer;
    private Composite dpContainer;
    private Composite descriptionContainer;
    private StyledText deviceDescription;
    private PreferenceUtils utils;
    private DevicePlatform[] myDps;
    private ToolkitSupport myToolkit;
    private String myTitle;
    private String mainMessage;
    private String defaultMessage;
    private String rootMessage;
    private String dpRetrieveFailure;
    private String errorInProperties;
    private Button checkAllButton;
    private Button unCheckAllButton;

    public AddDevicePlatformDialog2(Shell parentShell, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.myTitle = title;
        this.utils = new PreferenceUtils();
    }

    protected Control createDialogArea(Composite parent) {
        this.mainContainer = this.utils.createDefaultComposite(parent, 1, false);
        GridData data = (GridData)this.mainContainer.getLayoutData();
        data.grabExcessVerticalSpace = true;
        this.createProviderSelectionArea(this.mainContainer);
        this.utils.createHorizontalSeparator(this.mainContainer);
        this.subContainer = this.utils.createDefaultComposite(this.mainContainer, 2, false);
        this.dpContainer = (Composite)this.createPlatformSelectionArea(this.subContainer);
        data = (GridData)this.subContainer.getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.createPlatformButtonArea(this.subContainer);
        this.descriptionContainer = this.createDescriptionArea(this.mainContainer);
        this.initData();
        return this.mainContainer;
    }

    private Control createProviderSelectionArea(Composite parent) {
        Composite container = this.utils.createDefaultComposite(parent, 1, false);
        this.createProviderSelection(container);
        this.createRootSelection(container);
        return container;
    }

    private Control createProviderSelection(Composite parent) {
        Composite container = this.utils.createDefaultComposite(parent, 2, false);
        this.utils.createLabel(container, Messages.AddDevicePlatformDialog2_PlatformProvider);
        this.providerCombo = new Combo(container, 4);
        this.providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selection = AddDevicePlatformDialog2.this.providerCombo.getText();
                if (selection != null) {
                    AddDevicePlatformDialog2.this.checkPlatformProviderChange();
                }
            }
        });
        return container;
    }

    private Control createRootSelection(Composite parent) {
        Composite container = this.utils.createDefaultComposite(parent, 1, false);
        this.rootEditor = new DevicePlatformDirectoryEditor("rootLocation", "Location", container);
        this.rootEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AddDevicePlatformDialog2.this.checkRootLocationChange();
            }
        });
        return container;
    }

    private Control createPlatformSelectionArea(Composite parent) {
        Group platformContainer = this.utils.createDefaultGroup(parent, 1, false);
        platformContainer.setText(Messages.AddDevicePlatformDialog2_DevicePlatforms);
        GridData data = (GridData)platformContainer.getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.dpTree = this.utils.createDevicePlatformCheckTree((Composite)platformContainer);
        this.dpTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddDevicePlatformDialog2.this.changeDescriptionData();
            }
        });
        this.dpTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                block8: {
                    Object element;
                    block7: {
                        element = event.getElement();
                        DevicePlatformImportContentProvider contentProvider = (DevicePlatformImportContentProvider)AddDevicePlatformDialog2.this.dpTree.getContentProvider();
                        if (!(element instanceof DevicePlatform)) break block7;
                        boolean checkAndClear = event.getChecked();
                        Object[] children = contentProvider.getChildren(element);
                        int i = 0;
                        while (i < children.length) {
                            AddDevicePlatformDialog2.this.dpTree.setChecked(children[i], checkAndClear);
                            AddDevicePlatformDialog2.this.dpTree.setGrayed(children[i], !checkAndClear);
                            ++i;
                        }
                        break block8;
                    }
                    if (!(element instanceof Device)) break block8;
                    if (AddDevicePlatformDialog2.this.dpTree.getGrayed(element)) {
                        AddDevicePlatformDialog2.this.dpTree.setChecked(element, false);
                        return;
                    }
                    DevicePlatform dp = (DevicePlatform)((ITreeContentProvider)AddDevicePlatformDialog2.this.dpTree.getContentProvider()).getParent(element);
                    Device[] children = (Device[])dp.getDevices().toArray();
                    if (!event.getChecked()) {
                        boolean checkedFound = false;
                        int i = 0;
                        while (!checkedFound && i < children.length) {
                            if (AddDevicePlatformDialog2.this.dpTree.getChecked((Object)children[i])) {
                                checkedFound = true;
                            }
                            ++i;
                        }
                        if (!checkedFound) {
                            AddDevicePlatformDialog2.this.dpTree.setChecked((Object)dp, false);
                            i = 0;
                            while (i < children.length) {
                                AddDevicePlatformDialog2.this.dpTree.setGrayed((Object)children[i], true);
                                ++i;
                            }
                        }
                    }
                }
            }
        });
        return platformContainer;
    }

    private void createPlatformButtonArea(Composite parent) {
        Composite buttonComposite = this.utils.createButtonComposite(parent);
        this.checkAllButton = PreferenceUtils.createPushButton(buttonComposite, Messages.AddDevicePlatformDialog2_CheckAll);
        this.checkAllButton.setEnabled(false);
        this.checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddDevicePlatformDialog2.this.setAllElementsChecked(true);
            }
        });
        this.unCheckAllButton = PreferenceUtils.createPushButton(buttonComposite, Messages.AddDevicePlatformDialog2_UncheckAll);
        this.unCheckAllButton.setEnabled(false);
        this.unCheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddDevicePlatformDialog2.this.setAllElementsChecked(false);
            }
        });
    }

    private void setAllElementsChecked(boolean checked) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.dpTree.getContentProvider();
        Object[] elements = contentProvider.getElements(this.dpTree.getInput());
        if (checked) {
            this.dpTree.setCheckedElements(elements);
            Object[] children = null;
            int i = 0;
            while (i < elements.length) {
                children = contentProvider.getChildren(elements[i]);
                int j = 0;
                while (j < children.length) {
                    this.dpTree.setChecked(children[j], true);
                    this.dpTree.setGrayed(children[j], false);
                    ++j;
                }
                ++i;
            }
        } else {
            Object[] tmp = new Object[]{elements[0]};
            this.dpTree.setCheckedElements(tmp);
            this.dpTree.setChecked((Object)tmp, false);
        }
    }

    private Composite createDescriptionArea(Composite parent) {
        Group container = this.utils.createDefaultGroup(parent, 1, false);
        container.setText(Messages.AddDevicePlatformDialog2_Description);
        this.deviceDescription = this.utils.createStyledText((Composite)container, 60);
        this.deviceDescription.setBackground(parent.getBackground());
        this.deviceDescription.setEditable(false);
        return container;
    }

    private void clearDetailsArea() {
    }

    protected Control createButtonBar(Composite parent) {
        Control tmp = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return tmp;
    }

    private void changePlatform(String dppName) {
        this.isPlatformValid();
    }

    private void setProviderList() {
        DevicePlatformProvider[] dpps = this.utils.getToolkitSupporters();
        this.dppList = new Hashtable();
        String dppName = null;
        int i = 0;
        while (i < dpps.length) {
            dppName = PreferenceUtils.getObjectName(dpps[i]);
            this.providerCombo.add(dppName);
            this.dppList.put(dppName, dpps[i]);
            ++i;
        }
    }

    private void checkPlatformProviderChange() {
        this.isPlatformValid();
        String errorMsg = this.rootEditor.getStringValue();
        if (errorMsg == null || errorMsg.trim().length() == 0) {
            this.setMessage(this.rootMessage, 1);
        }
    }

    private void checkRootLocationChange() {
        if (this.isPlatformValid()) {
            this.createDevicePlatforms();
            if (this.myDps[0] == null) {
                this.setMessage(this.dpRetrieveFailure, 3);
            } else {
                this.subContainer.setEnabled(true);
                this.dpTree.setInput((Object)new DevicePlatform[]{this.myDps[0]});
                this.dpTree.setInput((Object)this.myDps);
                this.dpTree.refresh();
                this.setAllElementsChecked(true);
                this.deviceDescription.setText("");
                this.checkAllButton.setEnabled(true);
                this.unCheckAllButton.setEnabled(true);
                this.dpContainer.layout();
                this.descriptionContainer.layout();
                this.subContainer.layout();
                this.mainContainer.layout();
                this.getContents().pack();
                this.isPlatformValid();
            }
        }
    }

    private void changeDescriptionData() {
        Object o = this.utils.getSingleSelection(this.dpTree.getSelection());
        this.deviceDescription.setText(PreferenceUtils.getObjectStyledName(o));
    }

    private void createDevicePlatforms() {
        ToolkitSupport toolkit = (ToolkitSupport)this.dppList.get(this.providerCombo.getText());
        DevicePlatform[] dps = this.utils.createDevicePlatformFromDirectory(toolkit, this.rootEditor.getStringValue());
        if (dps == null) {
            this.setMessage(this.errorInProperties, 3);
        } else {
            this.myDps = new DevicePlatform[dps.length];
            System.arraycopy(dps, 0, this.myDps, 0, dps.length);
            this.myToolkit = toolkit;
        }
    }

    private boolean isPlatformValid() {
        if (!this.rootEditor.isValid()) {
            this.getButton(0).setEnabled(false);
            this.setMessage(this.rootEditor.getErrorMessage(), 3);
            return false;
        }
        this.getButton(0).setEnabled(true);
        this.getButton(0).setFocus();
        this.setMessage(null);
        return true;
    }

    private void initData() {
        this.defaultMessage = "";
        this.mainMessage = Messages.AddDevicePlatformDialog2_SelectPlatformProvdierRootLocation;
        this.rootMessage = Messages.AddDevicePlatformDialog2_EnterRootLocation;
        this.dpRetrieveFailure = Messages.AddDevicePlatformDialog2_DevicePlatformCouldNotBeRetreived;
        this.errorInProperties = Messages.AddDevicePlatformDialog2_ErrorReadingEmulatorProperties;
        this.setTitle(this.myTitle);
        this.setMessage(this.mainMessage, 1);
        this.setProviderList();
        if (this.dppList.size() == 1) {
            this.providerCombo.setText(this.providerCombo.getItem(0));
            this.rootEditor.setFocus();
        } else {
            boolean genericUEIfound = false;
            int i = 0;
            while (!genericUEIfound && i < this.providerCombo.getItemCount()) {
                if (this.providerCombo.getItem(i).contains(Messages.AddDevicePlatformDialog2_GenericUEI)) {
                    this.providerCombo.setText(this.providerCombo.getItem(i));
                    genericUEIfound = true;
                }
                ++i;
            }
            if (genericUEIfound) {
                this.rootEditor.setFocus();
            } else {
                this.providerCombo.setFocus();
            }
        }
        this.subContainer.setEnabled(false);
    }

    public DevicePlatform[] getDevicePlatforms() {
        return this.myDps;
    }

    protected void okPressed() {
        try {
            DevicePlatform[] dps = this.myToolkit.getDevicePlatforms();
            DevicePlatform[] r = new DevicePlatform[dps.length + this.myDps.length];
            int ix = 0;
            int i = 0;
            while (i < dps.length) {
                r[ix] = dps[i];
                ++ix;
                ++i;
            }
            i = 0;
            while (i < this.myDps.length) {
                r[ix] = this.myDps[i];
                ++ix;
                ++i;
            }
            this.myToolkit.setDevicePlatforms(r);
            super.okPressed();
        }
        catch (MtjException e) {
            try {
                this.myToolkit.setDevicePlatforms(new DevicePlatform[0]);
            }
            catch (Exception exception) {
                this.setMessage(e.getLocalizedMessage(), 3);
            }
        }
    }
}

