/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;

public class LaunchHelper {
    public static Device getTargetLaunchDevice(ILaunchConfiguration configuration) throws CoreException {
        String devicePlatformName = configuration.getAttribute("org.eclipse.mtj.emulation_platform_def", "");
        String deviceName = configuration.getAttribute("org.eclipse.mtj.emulated_device", "");
        if (!deviceName.equals("") && !devicePlatformName.equals("")) {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            try {
                return dm.getDevice(devicePlatformName, deviceName);
            }
            catch (MtjException e) {
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 2050, MtjCoreErrors.getErrorMessage(2050), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        return null;
    }

    public static DevicePlatform getTargetLaunchDevicePlatform(ILaunchConfiguration configuration) throws CoreException {
        String devicePlatformName = configuration.getAttribute("org.eclipse.mtj.emulation_platform_def", "");
        if (!devicePlatformName.equals("")) {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            try {
                return dm.getDevicePlatformByName(devicePlatformName);
            }
            catch (MtjException e) {
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 2051, MtjCoreErrors.getErrorMessage(2051), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        return null;
    }

    public static String getTargetApplication(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.mtj.executable_class", "");
    }
}

