/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.JvmImplementation;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.Messages;

public class MtjEmfUtil {
    public static IClasspathEntry[] getClasspathEntries(RuntimePlatformDefinition rpd) {
        String ob;
        ArrayList<String> filerefs = new ArrayList<String>();
        Iterator it = rpd.getServiceApis().iterator();
        while (it.hasNext()) {
            ob = ((ServiceApi)it.next()).getImplementation().getFileRef();
            if (filerefs.indexOf(ob) != -1) continue;
            filerefs.add(ob);
        }
        it = rpd.getDeviceConfigurations().iterator();
        if (it.hasNext() && filerefs.indexOf(ob = ((DeviceConfiguration)it.next()).getImplementation().getFileRef()) == -1) {
            filerefs.add(ob);
        }
        IClasspathEntry[] cpEntries = new IClasspathEntry[filerefs.size()];
        int i = 0;
        while (i < cpEntries.length) {
            IClasspathEntry entry;
            Path entryPath = new Path((String)filerefs.get(i));
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{};
            IPath sourceAttachmentPath = null;
            IPath sourceAttachmentRootPath = null;
            IAccessRule[] NO_ACCESS_RULES = new IAccessRule[]{};
            cpEntries[i] = entry = JavaCore.newLibraryEntry((IPath)entryPath, sourceAttachmentPath, sourceAttachmentRootPath, (IAccessRule[])NO_ACCESS_RULES, (IClasspathAttribute[])attributes, (boolean)false);
            ++i;
        }
        return cpEntries;
    }

    public static RuntimePlatformDefinition clone(RuntimePlatformDefinition rpd) {
        if (rpd == null) {
            return null;
        }
        RuntimePlatformDefinition resp = RuntimesFactory.eINSTANCE.createRuntimePlatformDefinition();
        resp.setName(rpd.getName());
        for (DeviceConfiguration dc : rpd.getDeviceConfigurations()) {
            resp.getDeviceConfigurations().add((Object)MtjEmfUtil.clone(dc));
        }
        for (ServiceApi sa : rpd.getServiceApis()) {
            resp.getServiceApis().add((Object)MtjEmfUtil.clone(sa));
        }
        for (DeviceProfile dp : rpd.getDeviceProfiles()) {
            resp.getDeviceProfiles().add((Object)MtjEmfUtil.clone(dp, resp));
        }
        return resp;
    }

    public static DeviceConfiguration clone(DeviceConfiguration dc) {
        if (dc == null) {
            return null;
        }
        DeviceConfiguration newdc = RuntimesFactory.eINSTANCE.createDeviceConfiguration();
        newdc.setName(dc.getName());
        newdc.setVersion(dc.getVersion());
        newdc.setJvmRef(MtjEmfUtil.clone(dc.getJvmRef()));
        newdc.setImplementation(MtjEmfUtil.clone(dc.getImplementation()));
        return newdc;
    }

    public static ServiceApi clone(ServiceApi sa) {
        if (sa == null) {
            return null;
        }
        ServiceApi newsa = RuntimesFactory.eINSTANCE.createServiceApi();
        newsa.setName(sa.getName());
        newsa.setVersion(sa.getVersion());
        newsa.setDescription(sa.getDescription());
        newsa.setImplementation(MtjEmfUtil.clone(sa.getImplementation()));
        return newsa;
    }

    public static DeviceProfile clone(DeviceProfile dp) {
        return MtjEmfUtil.clone(dp, null);
    }

    public static DeviceProfile clone(DeviceProfile dp, RuntimePlatformDefinition rpd) {
        if (dp == null) {
            return null;
        }
        DeviceProfile newdp = RuntimesFactory.eINSTANCE.createDeviceProfile();
        newdp.setName(dp.getName());
        newdp.setVersion(dp.getVersion());
        for (ServiceApi sa : dp.getServiceApis()) {
            if (rpd == null) {
                newdp.getServiceApis().add((Object)MtjEmfUtil.clone(sa));
                continue;
            }
            ServiceApi newsa = MtjEmfUtil.getServiceApi(sa.getName(), sa.getVersion(), rpd);
            if (newsa == null) {
                newdp.getServiceApis().add((Object)MtjEmfUtil.clone(sa));
                continue;
            }
            newdp.getServiceApis().add((Object)newsa);
        }
        return newdp;
    }

    private static ServiceApi getServiceApi(String name, String version, RuntimePlatformDefinition rpd) {
        for (ServiceApi sa : rpd.getServiceApis()) {
            if (name != null && !name.equals(sa.getName()) || version != null && !version.equals(sa.getVersion())) continue;
            return sa;
        }
        return null;
    }

    public static ImplementationRef clone(ImplementationRef ir) {
        if (ir == null) {
            return null;
        }
        ImplementationRef newir = RuntimesFactory.eINSTANCE.createImplementationRef();
        newir.setFileRef(ir.getFileRef());
        newir.setJavadocRef(ir.getJavadocRef());
        newir.setSourceRef(ir.getSourceRef());
        return newir;
    }

    public static JvmImplementation clone(JvmImplementation ji) {
        if (ji == null) {
            return null;
        }
        JvmImplementation newjir = RuntimesFactory.eINSTANCE.createJvmImplementation();
        newjir.setFileRef(ji.getFileRef());
        newjir.setName(ji.getName());
        newjir.setVendor(ji.getVendor());
        newjir.setVersion(ji.getVersion());
        return newjir;
    }

    public static TargetDevice clone(TargetDevice td) {
        if (td == null) {
            return null;
        }
        TargetDevice newtd = ProjectFactory.eINSTANCE.createTargetDevice();
        newtd.setName(td.getName());
        newtd.setDescription(td.getDescription());
        newtd.setDevicePlatformName(td.getDevicePlatformName());
        newtd.setDeviceName(td.getDeviceName());
        newtd.setDeviceGroupName(td.getDeviceGroupName());
        newtd.setRuntimePlatform(MtjEmfUtil.clone(td.getRuntimePlatform()));
        return newtd;
    }

    public static boolean equals(Device device1, Device device2) {
        return (device1.getName() != null && device1.getName().equals(device2.getName()) || device1.getName() == null && device2.getName() == null) && (device1.getVendor() != null && device1.getVendor().equals(device2.getVendor()) || device1.getVendor() == null && device2.getVendor() == null) && (device1.getVersion() != null && device1.getVersion().equals(device2.getVersion()) || device1.getVersion() == null && device2.getVersion() == null);
    }

    public static String toString(Device device) {
        return String.valueOf(device.getVendor() != null ? String.valueOf(device.getVendor()) + " " : "") + (device.getName() != null ? String.valueOf(device.getName()) + " " : String.valueOf(Messages.MtjEmfUtil_UnknownName) + " ") + (device.getVersion() != null ? String.valueOf(Messages.MtjEmfUtil_Version) + " " + device.getVersion() : "");
    }
}

