/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.ui.preferences.ModifyDeviceComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ModifyDeviceController
implements DialogController,
ICheckStateListener {
    private static final String MIDP = "MIDP";
    private static final String CLDC = "CLDC";
    private static final String MMAPI = "MMAPI";
    private static final String WMA = "WMA";
    private ModifyDeviceComposite composite;
    private RuntimePlatform selectedRuntime;
    private MtjServiceHandler mtjServiceHandler;
    private TargetDevice targetDevice;
    private RuntimePlatformDefinition rpd;
    private RuntimePlatformDefinition dprpd;
    private Device selectedDevice;
    private DeviceConfiguration selectedConfiguration;
    private DeviceProfile selectedProfile;
    private CheckboxTableViewer optionalApiTableViewer;

    public ModifyDeviceController(ModifyDeviceComposite composite, MtjServiceHandler mtjServiceHandler, RuntimePlatform selectedRuntime) {
        this.composite = composite;
        this.selectedRuntime = selectedRuntime;
        this.mtjServiceHandler = mtjServiceHandler;
        this.optionalApiTableViewer = composite.getOptionalApiTableViewer();
        this.optionalApiTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.targetDevice = (TargetDevice)selectedRuntime.getTargetDevices().get(0);
        if (this.targetDevice != null) {
            this.rpd = this.targetDevice.getRuntimePlatform();
            this.dprpd = mtjServiceHandler.getRuntimePlatformDefinition(this.targetDevice.getDevicePlatformName(), this.targetDevice.getDeviceName());
        }
        ModifyDeviceController.setData(composite, selectedRuntime);
        this.createProfileAndConfiguration();
        this.createServiceApi();
    }

    private static void setData(ModifyDeviceComposite c, RuntimePlatform s) {
        c.getRPNameLabel().setText(s.getName());
        EList targetList = s.getTargetDevices();
        TargetDevice targetDevice = null;
        if (targetList.size() >= 1) {
            targetDevice = (TargetDevice)targetList.get(0);
            c.getDeviceNameLabel().setText(targetDevice.getName());
            RuntimePlatformDefinition rpd = targetDevice.getRuntimePlatform();
            DeviceProfile cfr_ignored_0 = (DeviceProfile)rpd.getDeviceProfiles().get(0);
            DeviceConfiguration cfr_ignored_1 = (DeviceConfiguration)rpd.getDeviceConfigurations().get(0);
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null)[0];
            try {
                dm.getDevicePlatformByName(targetDevice.getDevicePlatformName());
            }
            catch (MtjException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checkState = event.getChecked();
        Object o = event.getElement();
        if (o instanceof ServiceApi) {
            ServiceApi api = (ServiceApi)o;
            if (checkState && api.getName().equals(WMA)) {
                this.uncheckApi(this.dprpd.getServiceApis(), WMA);
                this.optionalApiTableViewer.setChecked((Object)api, true);
            } else if (checkState && api.getName().equals(MMAPI)) {
                this.uncheckApi(this.dprpd.getServiceApis(), MMAPI);
                this.optionalApiTableViewer.setChecked((Object)api, true);
            }
        }
    }

    private void uncheckApi(EList l, String value) {
        int i = 0;
        while (i < l.size()) {
            ServiceApi a = (ServiceApi)l.get(i);
            if (a.getName().equals(value)) {
                this.optionalApiTableViewer.setChecked((Object)a, false);
            }
            ++i;
        }
    }

    private boolean containsProfile(String profileName, String profileVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceProfile dp = (DeviceProfile)iterator.next();
            if (!dp.getName().equals(profileName) || !dp.getVersion().equals(profileVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean containsConfiguration(String configurationName, String configurationVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceConfiguration dc = (DeviceConfiguration)iterator.next();
            if (!dc.getName().equals(configurationName) || !dc.getVersion().equals(configurationVersion)) continue;
            return true;
        }
        return false;
    }

    private void createProfileAndConfiguration() {
        Button button;
        String version;
        String name;
        Button button2;
        Iterator i;
        EList dpProfiles = this.dprpd.getDeviceProfiles();
        EList dpConfigs = this.dprpd.getDeviceConfigurations();
        EList profiles = this.rpd.getDeviceProfiles();
        EList configs = this.rpd.getDeviceConfigurations();
        Group pg = this.composite.getProfileGroup();
        Group cg = this.composite.getConfigGroup();
        if (profiles.size() >= 2) {
            i = profiles.iterator();
            DeviceProfile selectedProfile = null;
            while (i.hasNext()) {
                DeviceProfile dp = (DeviceProfile)i.next();
                if (selectedProfile == null) {
                    selectedProfile = dp;
                    continue;
                }
                DeviceProfile deviceProfile = selectedProfile = Double.parseDouble(selectedProfile.getVersion()) > Double.parseDouble(dp.getVersion()) ? selectedProfile : dp;
            }
            profiles.clear();
            profiles.add(selectedProfile);
        }
        if (configs.size() >= 2) {
            i = configs.iterator();
            DeviceConfiguration selectedConfiguration = null;
            while (i.hasNext()) {
                DeviceConfiguration dc = (DeviceConfiguration)i.next();
                if (selectedConfiguration == null) {
                    selectedConfiguration = dc;
                    continue;
                }
                DeviceConfiguration deviceConfiguration = selectedConfiguration = Double.parseDouble(selectedConfiguration.getVersion()) > Double.parseDouble(dc.getVersion()) ? selectedConfiguration : dc;
            }
            configs.clear();
            configs.add(selectedConfiguration);
        }
        if (!this.containsProfile(MIDP, "1.0", dpProfiles.iterator())) {
            button2 = ModifyDeviceController.createRadioButton(pg, "MIDP 1.0");
            button2.setEnabled(false);
        }
        if (!this.containsConfiguration(CLDC, "1.0", dpConfigs.iterator())) {
            button2 = ModifyDeviceController.createRadioButton(cg, "CLDC 1.0");
            button2.setEnabled(false);
        }
        int i2 = 0;
        while (i2 < dpProfiles.size()) {
            DeviceProfile dp = (DeviceProfile)dpProfiles.get(i2);
            name = dp.getName();
            version = dp.getVersion();
            button = ModifyDeviceController.createRadioButton(pg, String.valueOf(name) + " " + version);
            button.setData((Object)dp);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ModifyDeviceController.this.selectedProfile = (DeviceProfile)((Button)event.getSource()).getData();
                }
            });
            if (this.containsProfile(name, version, profiles.iterator())) {
                button.setSelection(true);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < dpConfigs.size()) {
            DeviceConfiguration dc = (DeviceConfiguration)dpConfigs.get(i2);
            name = dc.getName();
            version = dc.getVersion();
            button = ModifyDeviceController.createRadioButton(cg, String.valueOf(name) + " " + version);
            button.setData((Object)dc);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ModifyDeviceController.this.selectedConfiguration = (DeviceConfiguration)((Button)event.getSource()).getData();
                }
            });
            if (this.containsConfiguration(name, version, configs.iterator())) {
                button.setSelection(true);
            }
            ++i2;
        }
    }

    private static void createDeviceList(CheckboxTableViewer deviceTableViewer, TargetDevice targetDevice, MtjServiceHandler mtjServiceHandler) {
        private class EListContentProvider
        implements IStructuredContentProvider {
            EListContentProvider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof EList) {
                    return ((EList)o).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        deviceTableViewer.setContentProvider((IContentProvider)new EListContentProvider());
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Device) {
                    Device device = (Device)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return device.getName();
                    }
                    if (columnIndex == 2) {
                        return device.getDescription();
                    }
                }
                return null;
            }
        }
        deviceTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        ModifyDeviceController.createTableColumn(deviceTableViewer.getTable(), 0, 6, "");
        ModifyDeviceController.createTableColumn(deviceTableViewer.getTable(), 1, 20, Messages.ModifyDeviceController_DeviceTableViewerName);
        ModifyDeviceController.createTableColumn(deviceTableViewer.getTable(), 2, 40, Messages.ModifyDeviceController_DeviceTableViewerDescription);
        if (targetDevice != null) {
            EList dl = mtjServiceHandler.getDeviceList(targetDevice.getDevicePlatformName());
            deviceTableViewer.setInput((Object)dl);
            for (Device d : dl) {
                if (!d.getName().equals(targetDevice.getDeviceName())) continue;
                deviceTableViewer.setChecked((Object)d, true);
                break;
            }
        }
    }

    private void createServiceApi() {
        this.optionalApiTableViewer.setContentProvider((IContentProvider)new EListContentProvider());
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ServiceApi) {
                    ServiceApi api = (ServiceApi)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return api.getName();
                    }
                    if (columnIndex == 2) {
                        return api.getVersion();
                    }
                    if (columnIndex == 3) {
                        return api.getDescription();
                    }
                }
                return null;
            }
        }
        this.optionalApiTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        ModifyDeviceController.createTableColumn(this.optionalApiTableViewer.getTable(), 0, 6, "");
        ModifyDeviceController.createTableColumn(this.optionalApiTableViewer.getTable(), 1, 20, Messages.ModifyDeviceController_OptionalApiTableViewerName);
        ModifyDeviceController.createTableColumn(this.optionalApiTableViewer.getTable(), 2, 6, Messages.ModifyDeviceController_OptionalApiTableViewerVersion);
        ModifyDeviceController.createTableColumn(this.optionalApiTableViewer.getTable(), 3, 40, Messages.ModifyDeviceController_OptionalApiTableViewerDescription);
        ModifyDeviceController.removeDuplicates(this.rpd);
        if (this.dprpd != null) {
            this.setApis(this.rpd, this.dprpd);
        } else {
            EList rpApiList = this.rpd.getServiceApis();
            this.optionalApiTableViewer.setInput((Object)rpApiList);
            this.optionalApiTableViewer.setAllChecked(true);
        }
    }

    private static void removeDuplicates(RuntimePlatformDefinition rpd) {
        EList l = rpd.getServiceApis();
        BasicEList removeList = new BasicEList();
        ServiceApi wmaApi = null;
        ServiceApi mmapiApi = null;
        int i = 0;
        while (i < l.size()) {
            ServiceApi api = (ServiceApi)l.get(i);
            if (api.getName().equals(WMA)) {
                if (wmaApi == null) {
                    wmaApi = api;
                } else if (Double.parseDouble(api.getVersion()) > Double.parseDouble(wmaApi.getVersion())) {
                    removeList.add((Object)wmaApi);
                    wmaApi = api;
                } else {
                    removeList.add((Object)api);
                }
            } else if (api.getName().equals(MMAPI)) {
                if (mmapiApi == null) {
                    mmapiApi = api;
                } else if (Double.parseDouble(api.getVersion()) > Double.parseDouble(mmapiApi.getVersion())) {
                    removeList.add((Object)mmapiApi);
                    mmapiApi = api;
                } else {
                    removeList.add((Object)api);
                }
            }
            ++i;
        }
        i = 0;
        while (i < removeList.size()) {
            l.remove(removeList.get(i));
            ++i;
        }
    }

    private void setApis(RuntimePlatformDefinition rpd, RuntimePlatformDefinition dprpd) {
        EList rpApiList = rpd.getServiceApis();
        EList dpApiList = dprpd.getServiceApis();
        this.optionalApiTableViewer.setInput((Object)dpApiList);
        this.optionalApiTableViewer.setAllChecked(false);
        int i = 0;
        while (i < dpApiList.size()) {
            ServiceApi api = (ServiceApi)dpApiList.get(i);
            if (this.getServiceApi(api.getName(), api.getVersion(), rpApiList.iterator()) != null) {
                this.optionalApiTableViewer.setChecked((Object)api, true);
            }
            ++i;
        }
    }

    private ServiceApi getServiceApi(String name, String version, Iterator apiIterator) {
        while (apiIterator.hasNext()) {
            ServiceApi api = (ServiceApi)apiIterator.next();
            if (!name.equals(api.getName()) || !version.equals(api.getVersion())) continue;
            return api;
        }
        return null;
    }

    private static void createTableColumn(Table table, int colIndex, int weight, String header) {
        ColumnWeightData cwd = new ColumnWeightData(weight);
        TableColumn tableColumn = new TableColumn(table, 0, colIndex);
        tableColumn.setResizable(cwd.resizable);
        tableColumn.setText(header);
        TableLayout tableLayout = (TableLayout)table.getLayout();
        tableLayout.addColumnData((ColumnLayoutData)cwd);
    }

    private static ServiceApi[] createServiceApiList(DeviceProfile selectedProfile, RuntimePlatformDefinition rpd, ModifyDeviceComposite c) {
        ServiceApi[] services = ModifyDeviceController.getCleanedServiceApis(rpd.getServiceApis(), selectedProfile.getServiceApis());
        int count = services.length;
        Button[] serviceButtons = new Button[count];
        StringBuffer sb = null;
        String label = null;
        int i = 0;
        while (i < count) {
            sb = new StringBuffer();
            sb.append(services[i].getName());
            sb.append("-");
            sb.append(services[i].getVersion());
            sb.append(" (");
            sb.append(services[i].getDescription());
            sb.append(")");
            label = sb.toString();
            serviceButtons[i] = ModifyDeviceController.createCheckButton((Composite)c.getServiceGroup(), label);
            serviceButtons[i].setSelection(true);
            serviceButtons[i].setData((Object)services[i]);
            ++i;
        }
        return services;
    }

    public static Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static ServiceApi[] getCleanedServiceApis(EList serviceApis, EList profileApis) {
        Vector<ServiceApi> v = new Vector<ServiceApi>();
        ServiceApi tmpApi = null;
        int i = 0;
        while (i < serviceApis.size()) {
            tmpApi = (ServiceApi)serviceApis.get(i);
            v.add(tmpApi);
            ++i;
        }
        Object[] o = v.toArray();
        ServiceApi[] sapis = new ServiceApi[o.length];
        int i2 = 0;
        while (i2 < o.length) {
            sapis[i2] = (ServiceApi)o[i2];
            ++i2;
        }
        return sapis;
    }

    private static String getPlatformTypeName(DevicePlatform dp) {
        if (dp != null) {
            StringTokenizer st = new StringTokenizer(dp.getType().getName(), "_");
            StringBuffer sb = new StringBuffer();
            String s = null;
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                sb.append(s.charAt(0));
                sb.append(s.substring(1).toLowerCase());
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return new String();
    }

    public void handleOK() {
        if (this.rpd != null) {
            EList l = this.rpd.getDeviceConfigurations();
            if (this.selectedConfiguration != null) {
                l.clear();
                l.add((Object)this.selectedConfiguration);
            }
            l = this.rpd.getDeviceProfiles();
            if (this.selectedProfile != null) {
                l.clear();
                l.add((Object)this.selectedProfile);
            }
            l = this.rpd.getServiceApis();
            l.clear();
            Object[] o = this.optionalApiTableViewer.getCheckedElements();
            int i = 0;
            while (i < o.length) {
                l.add(o[i]);
                ++i;
            }
        }
    }

    public static Button createRadioButton(Group parent, String label) {
        Button button = new Button((Composite)parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    class EListContentProvider
    implements IStructuredContentProvider {
        EListContentProvider() {
        }

        public Object[] getElements(Object o) {
            if (o instanceof EList) {
                return ((EList)o).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

