/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplp.nokia.pcsuite.impl;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.impl.DevicesFactoryImpl;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.CdcDeployment;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.model.ResourceDeployment;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.PCSuiteMessages;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.PcsuitePlugin;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.impl.Deployer;

public class DeploymentProviderImpl
extends MtjExtensionImpl
implements DeploymentProvider {
    private Deployer deployer = null;

    public DeploymentProviderImpl() {
        this.setId(PcsuitePlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(PCSuiteMessages.DeploymentProviderImpl_0);
        this.setVendor(PCSuiteMessages.DeploymentProviderImpl_1);
        this.setVersion(PCSuiteMessages.DeploymentProviderImpl_2);
        this.setType(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL);
        this.deployer = new Deployer();
    }

    public String getName() {
        return PCSuiteMessages.DeploymentProviderImpl_3;
    }

    public Device[] getDevices() throws MtjException {
        String[] terminals = this.deployer.getTerminals();
        if (terminals == null) {
            return null;
        }
        Device[] devices = new Device[terminals.length];
        DevicesFactoryImpl factory = new DevicesFactoryImpl();
        int i = 0;
        while (i < devices.length) {
            Device device = factory.createDevice();
            device.setName(terminals[i]);
            device.setVendor(PCSuiteMessages.DeploymentProviderImpl_4);
            device.setDescription(PCSuiteMessages.DeploymentProviderImpl_5);
            device.setCommunicationProtocol(DeviceCommunicationProtocol.get((int)3));
            devices[i] = device;
            ++i;
        }
        return devices;
    }

    public PlatformType getPlatformType() throws MtjException {
        return PlatformType.get((int)3);
    }

    public DeviceCommunicationProtocol[] getSupportedProtocols() throws MtjException {
        DeviceCommunicationProtocol[] dcpList = new DeviceCommunicationProtocol[]{DeviceCommunicationProtocol.get((int)3)};
        return dcpList;
    }

    public void deploy(Deployment deployment, Device[] devices, DeviceCommunicationProtocol transferProtocol, IProgressMonitor monitor) throws MtjException {
        int i = 0;
        while (i < devices.length) {
            if (deployment instanceof MidletDeployment) {
                try {
                    this.deployer.deploy(((MidletDeployment)deployment).getJad(), ((MidletDeployment)deployment).getJar(), devices[i].getName());
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                    throw new MtjException(e.getMessage());
                }
                catch (IOException e) {
                    throw new MtjException(String.valueOf(PCSuiteMessages.DeploymentProviderImpl_6) + e.getMessage());
                }
            } else {
                if (deployment instanceof ResourceDeployment) {
                    return;
                }
                if (deployment instanceof CdcDeployment) {
                    return;
                }
            }
            ++i;
        }
    }

    public DeviceStatus getStatus(Device device) throws MtjException {
        return DeviceStatus.get((int)0);
    }
}

