/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.mtj.extension.smgmt.ui.actions.MainDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ContextMenuActivate
implements IWorkbenchWindowActionDelegate {
    private IMtjProject fTargetProject = null;

    public void run(IAction arg0) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Shell shell = display == null ? new Shell() : display.getActiveShell();
        try {
            if (this.fTargetProject != null) {
                if (this.fTargetProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL) {
                    MainDialog Dlg = new MainDialog(shell, this.fTargetProject);
                    Dlg.open();
                }
            } else {
                MainDialog Dlg = new MainDialog(shell, null);
                Dlg.open();
            }
        }
        catch (MtjException e) {
            ErrorDialog.openError((Shell)shell, (String)SecurityManagmentUIMessages.MidpSecurity_Title, (String)SecurityManagmentUIMessages.ContextMenuActivate_0, (IStatus)new Status(4, "org.eclipse.mtj.core.ui", -1, e.toString(), (Throwable)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            this.fTargetProject = this.getFirstProject(((IStructuredSelection)selection).toList());
        }
    }

    private IMtjProject getFirstProject(List list) {
        IMtjProject firstProject = null;
        for (Object element : list) {
            IResource res;
            if (!(element instanceof IAdaptable) || (res = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
            try {
                firstProject = MtjProject.getMtjProject((IJavaProject)new JavaProject(res.getProject(), null));
            }
            catch (MtjException mtjException) {}
        }
        return firstProject;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
    }
}

