/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.smgmt.ui.eclipse.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.mtj.extension.smgmt.ui.eclipse.preferences.SecurityManagementEditor;
import org.eclipse.mtj.extension.smgmt.ui.utils.SmgmtUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SecurityManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button editButton;
    private Table SecurityToolPathTable;
    private static final int SMgmtDescriptionIndex = 0;
    private static final int SMgmtVendorNameIndex = 1;
    private static final int SMgmtVersionIndex = 2;
    private static final int SMgmtLocationIndex = 3;
    private MtjExtension[] securityList;
    private TableItem lastEnabled = null;

    public SecurityManagementPreferencePage() {
        this.setDescription(String.valueOf(SecurityManagmentUIMessages.SecurityManagementPreferencePage_0) + SecurityManagmentUIMessages.SecurityManagementPreferencePage_1 + SecurityManagmentUIMessages.SecurityManagementPreferencePage_2);
        this.noDefaultAndApplyButton();
        try {
            this.securityList = (SecurityManagement[])SmgmtUtils.getSecurityManagementProvidersList();
        }
        catch (MtjException mtjException) {
            this.securityList = null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        if (this.securityList == null) {
            this.setErrorMessage(SecurityManagmentUIMessages.SecurityManagementPreferencePage_10);
        } else if (this.securityList.length <= 0) {
            this.setErrorMessage(SecurityManagmentUIMessages.SecurityManagementPreferencePage_6);
        }
        Composite mainPageComposite = new Composite(parent, 2048);
        GridLayout c1gridLayout = new GridLayout();
        c1gridLayout.numColumns = 2;
        mainPageComposite.setLayout((Layout)c1gridLayout);
        GridData dataMain = GridUtil.createFill();
        mainPageComposite.setLayoutData((Object)dataMain);
        Composite tableComposite = new Composite(mainPageComposite, 0);
        FillLayout fillLayout = new FillLayout();
        tableComposite.setLayout((Layout)fillLayout);
        GridData gdTableComp = new GridData(1808);
        tableComposite.setLayoutData((Object)gdTableComp);
        this.SecurityToolPathTable = new Table(tableComposite, 68388);
        this.SecurityToolPathTable.setHeaderVisible(true);
        this.SecurityToolPathTable.setLinesVisible(true);
        this.SecurityToolPathTable.setFont(parent.getFont());
        TableColumn SMgmgtDescrition = new TableColumn(this.SecurityToolPathTable, 16384);
        SMgmgtDescrition.setText(SecurityManagmentUIMessages.SecurityManagementPreferencePage_9);
        TableColumn SMgmtVendorName = new TableColumn(this.SecurityToolPathTable, 16384);
        SMgmtVendorName.setText(SecurityManagmentUIMessages.SecurityManagementPreferencePage_3);
        TableColumn SMgmtVersion = new TableColumn(this.SecurityToolPathTable, 16384);
        SMgmtVersion.setText(SecurityManagmentUIMessages.SecurityManagementPreferencePage_5);
        TableColumn SMgmtLocation = new TableColumn(this.SecurityToolPathTable, 16384);
        SMgmtLocation.setText(SecurityManagmentUIMessages.SecurityManagementPreferencePage_4);
        if (this.securityList != null && this.securityList.length > 0) {
            int i = 0;
            while (i < this.securityList.length) {
                TableItem item = new TableItem(this.SecurityToolPathTable, 0);
                item.setText(0, this.securityList[i].getDescription());
                item.setText(1, this.securityList[i].getVendor());
                item.setText(2, this.securityList[i].getVersion());
                try {
                    item.setText(3, ((SecurityManagement)this.securityList[i]).getToolLocation(null));
                }
                catch (MtjException mtjException) {
                    item.setText(3, "");
                }
                if (((SecurityManagement)this.securityList[i]).isActive()) {
                    if (this.lastEnabled != null) {
                        if (this.lastEnabled.equals(item)) {
                            item.setChecked(true);
                        } else {
                            item.setChecked(false);
                        }
                    } else {
                        item.setChecked(true);
                        this.lastEnabled = item;
                    }
                } else {
                    item.setChecked(false);
                }
                ++i;
            }
        }
        SMgmgtDescrition.pack();
        SMgmtVendorName.pack();
        SMgmtVersion.pack();
        SMgmtLocation.pack();
        this.SecurityToolPathTable.pack();
        this.SecurityToolPathTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SecurityManagementPreferencePage.this.SecurityToolPathTable.getSelectionCount() > 0) {
                    SecurityManagementPreferencePage.this.editButton.setEnabled(true);
                }
                if (event.detail == 32) {
                    if (SecurityManagementPreferencePage.this.lastEnabled == null) {
                        ((TableItem)event.item).setChecked(true);
                        SecurityManagementPreferencePage.this.lastEnabled = (TableItem)event.item;
                    } else if (!SecurityManagementPreferencePage.this.lastEnabled.equals((TableItem)event.item)) {
                        SecurityManagementPreferencePage.this.lastEnabled.setChecked(false);
                        ((TableItem)event.item).setChecked(true);
                        SecurityManagementPreferencePage.this.lastEnabled = (TableItem)event.item;
                    }
                }
            }
        });
        Composite rightColumnButtons = new Composite(mainPageComposite, 2048);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 10;
        gd.verticalAlignment = 4;
        rightColumnButtons.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        GridLayout c1gridLayoutButtons = new GridLayout();
        c1gridLayoutButtons.numColumns = 1;
        rightColumnButtons.setLayout((Layout)c1gridLayoutButtons);
        this.editButton = new Button(rightColumnButtons, 8);
        this.editButton.setText(SecurityManagmentUIMessages.SecurityManagementPreferencePage_8);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = SecurityManagementPreferencePage.this.SecurityToolPathTable.getSelection()[0];
                SecurityManagementEditor SME = new SecurityManagementEditor(SecurityManagementPreferencePage.this.getShell(), ti.getText(1), ti.getText(2), ti.getText(3), ti.getText(0));
                SME.open();
                if (SME.getReturnCode() == 0) {
                    ti.setText(3, SME.getPath());
                }
            }
        });
        return mainPageComposite;
    }

    public boolean performOk() {
        boolean okToStore = false;
        int i = 0;
        while (i < this.securityList.length) {
            try {
                ((SecurityManagement)this.securityList[i]).storeToolLocation(this.SecurityToolPathTable.getItem(i).getText(3), null);
                ((SecurityManagement)this.securityList[i]).setActive(this.SecurityToolPathTable.getItem(i).getChecked());
            }
            catch (MtjException e) {
                this.setErrorMessage(SecurityManagmentUIMessages.SecurityManagementPreferencePage_7);
                e.printStackTrace();
            }
            ++i;
        }
        okToStore = SmgmtUtils.storeSecurityManagers(this.securityList);
        if (okToStore) {
            return super.performOk();
        }
        return okToStore;
    }
}

