/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.dialog;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIPlugin;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeploymentManagementDialog
extends TitleAreaDialog {
    private DeploymentManagementDialog dplmDialog = this;
    private String strSelResource = "";
    private Shell shell;
    private Button btnResourceBrowse;
    private Button btnRefresh;
    private Button btnProperties;
    private Button btnDeploy;
    private Button btnSelectProject;
    private Button btnClose;
    private Label lblResource;
    private Label lblDescription;
    private Label lblSelectedProject;
    private Text txtResourceFile;
    protected Combo cboProtocol;
    private String[] resourceFilterExt = null;
    private CheckboxTreeViewer deviceViewer;
    private ProvidersContentProvider contentProvider = new ProvidersContentProvider();
    private ProvidersLabelProvider labelProvider;
    private Object selectedResource;
    private IJavaProject javaProject;
    private List<Device> selectedDevices = new Vector<Device>();
    private IProgressMonitor monitor = null;

    public DeploymentManagementDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.labelProvider = new ProvidersLabelProvider();
    }

    protected Control createDialogArea(Composite parent) {
        this.shell = this.getShell();
        Image image = DeploymentManagementUIPlugin.getImageDescriptor("icons/phone.gif").createImage();
        this.shell.setImage(image);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(result, 0);
        container.setLayoutData((Object)new GridData(1808));
        this.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogTitle);
        this.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogDescription);
        this.setTitleImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage());
        GridLayout gridLayout = new GridLayout();
        container.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.verticalSpacing = 7;
        this.lblResource = new Label(container, 0);
        GridData gd = new GridData(4, 4, false, false);
        this.lblResource.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Resource);
        this.lblResource.setLayoutData((Object)gd);
        this.txtResourceFile = new Text(container, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.txtResourceFile.setLayoutData((Object)gd);
        this.txtResourceFile.setEditable(false);
        this.txtResourceFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentManagementDialog.this.strSelResource = DeploymentManagementDialog.this.txtResourceFile.getText();
            }
        });
        this.btnResourceBrowse = new Button(container, 0);
        this.initializeDialogUnits((Control)this.btnResourceBrowse);
        this.setButtonLayoutData(this.btnResourceBrowse);
        this.btnResourceBrowse.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
        private class OpenResource
        implements SelectionListener {
            OpenResource() {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(DeploymentManagementDialog.this.shell, 4096);
                fileDialog.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToBeDeployed);
                fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                fileDialog.setFilterExtensions(DeploymentManagementDialog.this.resourceFilterExt);
                if (DeploymentManagementDialog.this.strSelResource != "") {
                    fileDialog.setFileName(DeploymentManagementDialog.this.strSelResource);
                }
                if (fileDialog.open() != null) {
                    String separator = "";
                    int length = fileDialog.getFilterPath().trim().length();
                    if (length > 0 && fileDialog.getFilterPath().charAt(length - 1) != File.separatorChar) {
                        separator = File.separator;
                    }
                    DeploymentManagementDialog.this.strSelResource = new Path(String.valueOf(fileDialog.getFilterPath()) + separator + fileDialog.getFileName()).toOSString();
                    DeploymentManagementDialog.this.txtResourceFile.setText(DeploymentManagementDialog.this.strSelResource);
                    DeploymentManagementDialog.this.btnDeploy.setEnabled(true);
                    DeploymentManagementDialog.this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysResourceOnDevice, false);
                }
                DeploymentManagementDialog.this.txtResourceFile.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        }
        this.btnResourceBrowse.addSelectionListener((SelectionListener)new OpenResource());
        Label separator = new Label(container, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 6;
        gd.verticalIndent = 3;
        separator.setLayoutData((Object)gd);
        Composite deviceListArea = new Composite(container, 0);
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 200;
        gd.horizontalSpan = 3;
        deviceListArea.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        deviceListArea.setLayout((Layout)gridLayout);
        Group grpDevices = new Group(deviceListArea, 0);
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Devices);
        gd = new GridData(1808);
        grpDevices.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpDevices.setLayout((Layout)gridLayout);
        Composite deviceTreeArea = new Composite((Composite)grpDevices, 0);
        FillLayout layout2 = new FillLayout();
        deviceTreeArea.setLayout((Layout)layout2);
        gd = new GridData(1808);
        deviceTreeArea.setLayoutData((Object)gd);
        this.deviceViewer = new CheckboxTreeViewer(deviceTreeArea);
        this.addDeviceViewerListeners(this.deviceViewer);
        deviceListArea = new Composite(container, 0);
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.horizontalSpan = 3;
        deviceListArea.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        deviceListArea.setLayout((Layout)gridLayout);
        Group grpDescription = new Group(deviceListArea, 0);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Description);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 130;
        grpDescription.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpDescription.setLayout((Layout)gridLayout);
        this.lblDescription = new Label((Composite)grpDescription, 64);
        gd = new GridData(1808);
        gd.widthHint = 300;
        this.lblDescription.setLayoutData((Object)gd);
        Group grpFilterDevices = new Group(deviceListArea, 0);
        grpFilterDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DevicesFilter);
        gd = new GridData(768);
        gd.heightHint = 50;
        grpFilterDevices.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpFilterDevices.setLayout((Layout)gridLayout);
        Button rbtnPrjDevices = new Button((Composite)grpFilterDevices, 16);
        rbtnPrjDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_ComptibleDevices);
        rbtnPrjDevices.setSelection(true);
        gd = new GridData(768);
        rbtnPrjDevices.setLayoutData((Object)gd);
        Button rbtnAllDevices = new Button((Composite)grpFilterDevices, 16);
        rbtnAllDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_AllDevices);
        gd = new GridData(768);
        rbtnAllDevices.setLayoutData((Object)gd);
        Group grpFilterConnected = new Group(deviceListArea, 0);
        grpFilterConnected.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_StatusFilter);
        gd = new GridData(768);
        gd.heightHint = 50;
        grpFilterConnected.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpFilterConnected.setLayout((Layout)gridLayout);
        Button rbtnConnectedDevices = new Button((Composite)grpFilterConnected, 16);
        rbtnConnectedDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyConnectedDevices);
        rbtnConnectedDevices.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        rbtnConnectedDevices.setLayoutData((Object)gd);
        Button rbtnAlsoDisconnectedDevices = new Button((Composite)grpFilterConnected, 16);
        rbtnAlsoDisconnectedDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_AllDevices);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        rbtnAlsoDisconnectedDevices.setLayoutData((Object)gd);
        this.addRbtnFiltersListeners(rbtnConnectedDevices, rbtnAlsoDisconnectedDevices, rbtnPrjDevices, rbtnAllDevices);
        Group grpSelectedProject = new Group(deviceListArea, 0);
        grpSelectedProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Project);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 40;
        grpSelectedProject.setLayoutData((Object)gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpSelectedProject.setLayout((Layout)gridLayout);
        this.lblSelectedProject = new Label((Composite)grpSelectedProject, 64);
        gd = new GridData(1808);
        this.lblSelectedProject.setLayoutData((Object)gd);
        this.selectedResource = this.getSelectedResource();
        this.btnSelectProject = new Button((Composite)grpSelectedProject, 0);
        this.initializeDialogUnits((Control)this.btnSelectProject);
        this.setButtonLayoutData(this.btnSelectProject);
        this.btnSelectProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Change);
        this.addBtnSelectProjectListeners(this.btnSelectProject);
        this.btnProperties = new Button(container, 0);
        this.initializeDialogUnits((Control)this.btnProperties);
        this.setButtonLayoutData(this.btnProperties);
        this.btnProperties.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Properties);
        this.addBtnPropertiesListeners(this.btnProperties);
        this.btnRefresh = new Button(container, 0);
        this.initializeDialogUnits((Control)this.btnRefresh);
        this.setButtonLayoutData(this.btnRefresh);
        this.btnRefresh.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Refresh);
        this.addBtnRefreshListeners(this.btnRefresh);
        Label label = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.btnDeploy = new Button(container, 0);
        this.initializeDialogUnits((Control)this.btnDeploy);
        this.setButtonLayoutData(this.btnDeploy);
        this.btnDeploy.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Deploy);
        this.addBtnDeployListeners(this.btnDeploy);
        separator = new Label(container, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 6;
        gd.verticalIndent = 3;
        separator.setLayoutData((Object)gd);
        this.contentProvider.setFilters(2, 4, 5);
        this.deviceViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.deviceViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        Vector<DeploymentProvider> providersList = new Vector<DeploymentProvider>();
        MtjExtension[] providers = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
        int i = 0;
        while (i < providers.length) {
            providersList.add((DeploymentProvider)providers[i]);
            ++i;
        }
        this.deviceViewer.setInput(providersList);
        this.setResourceFields(this.selectedResource);
        return result;
    }

    private void addBtnSelectProjectListeners(Button btnSelectProject) {
        btnSelectProject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.javaProject = DeploymentManagementDialog.this.selectProject();
                DeploymentManagementDialog.this.setResourceFields(DeploymentManagementDialog.this.javaProject);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private IJavaProject selectProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_ProjectSelection);
        dialog.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_ChooseTheProject);
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.javaProject});
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void setResourceFields(Object selectedResource) {
        block26: {
            IMtjProject mtjProject = null;
            if (selectedResource instanceof IJavaProject) {
                try {
                    this.javaProject = (IJavaProject)selectedResource;
                    mtjProject = MtjProject.getMtjProject((IJavaProject)this.javaProject);
                }
                catch (MtjException e) {
                    e.printStackTrace();
                }
                if (mtjProject == null) {
                    this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
                } else {
                    this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysOnDevice, false);
                    this.btnDeploy.setEnabled(false);
                }
                this.contentProvider.setJavaProject(this.javaProject);
                try {
                    MidletDeployment midlet = null;
                    if (mtjProject != null) {
                        midlet = (MidletDeployment)mtjProject.getDeployment();
                        this.lblSelectedProject.setText(mtjProject.getProject().getName());
                    } else {
                        this.lblSelectedProject.setText(((IJavaProject)selectedResource).getPath().toString());
                    }
                    if (midlet != null) {
                        this.txtResourceFile.setText(midlet.getJad().getName());
                        this.btnDeploy.setEnabled(true);
                        break block26;
                    }
                    this.txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
                    this.txtResourceFile.selectAll();
                    this.btnDeploy.setEnabled(false);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else if (selectedResource instanceof IProject) {
                this.lblSelectedProject.setText(((IProject)selectedResource).getFullPath().toString());
                this.txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
                this.txtResourceFile.selectAll();
            } else if (selectedResource instanceof IResource) {
                IResource resource = (IResource)selectedResource;
                IProject container = resource.getProject();
                this.javaProject = JavaCore.create((IProject)container);
                if (this.javaProject != null) {
                    try {
                        mtjProject = MtjProject.getMtjProject((IJavaProject)this.javaProject);
                    }
                    catch (MtjException e) {
                        e.printStackTrace();
                    }
                    if (mtjProject == null) {
                        this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
                    } else {
                        this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployeToDevice, false);
                        this.btnDeploy.setEnabled(false);
                    }
                    this.contentProvider.setJavaProject(this.javaProject);
                    try {
                        MidletDeployment midlet = null;
                        if (mtjProject != null) {
                            midlet = (MidletDeployment)mtjProject.getDeployment();
                            this.lblSelectedProject.setText(mtjProject.getProject().getName());
                        } else {
                            this.lblSelectedProject.setText(((IJavaProject)selectedResource).getPath().toString());
                        }
                        if (midlet != null) {
                            this.txtResourceFile.setText(midlet.getJad().getName());
                            this.btnDeploy.setEnabled(true);
                        } else {
                            this.txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
                            this.txtResourceFile.selectAll();
                            this.btnDeploy.setEnabled(false);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                this.lblSelectedProject.setText(container.getFullPath().toString());
                this.txtResourceFile.setText(resource.getFullPath().toString());
            } else {
                this.lblSelectedProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_NoProject);
                this.txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
                this.txtResourceFile.selectAll();
            }
        }
    }

    private void addRbtnFiltersListeners(Button rbtnConnectedDevices, Button rbtnAlsoDisconnectedDevices, Button rbtnPrjDevices, Button rbtnAllDevices) {
        rbtnConnectedDevices.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.contentProvider.setFilters(0, 4, 0);
                DeploymentManagementDialog.this.deviceViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        rbtnAlsoDisconnectedDevices.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.contentProvider.setFilters(0, 3, 0);
                DeploymentManagementDialog.this.deviceViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        rbtnPrjDevices.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.contentProvider.setFilters(2, 0, 0);
                DeploymentManagementDialog.this.deviceViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        rbtnAllDevices.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.contentProvider.setFilters(1, 0, 0);
                DeploymentManagementDialog.this.deviceViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addBtnDeployListeners(Button btnDeploy) {
        btnDeploy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                if (DeploymentManagementDialog.this.selectedResource instanceof IJavaProject) {
                    if (DeploymentManagementDialog.this.selectedResource != null) {
                        IJavaProject javaProject = (IJavaProject)DeploymentManagementDialog.this.selectedResource;
                        try {
                            Deployment deployment = null;
                            IMtjProject mtjProject = MtjProject.getMtjProject((IJavaProject)javaProject);
                            if (mtjProject == null) {
                                DeploymentManagementDialog.this.dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
                                return;
                            }
                            deployment = mtjProject.getDeployment();
                            MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
                            DeploymentProvider dplp = (DeploymentProvider)list[0];
                            Object[] checkedElements = DeploymentManagementDialog.this.deviceViewer.getCheckedElements();
                            DeploymentManagementDialog.this.selectedDevices.clear();
                            int i = 0;
                            while (i < checkedElements.length) {
                                Object current = checkedElements[i];
                                if (current instanceof Device) {
                                    DeploymentManagementDialog.this.selectedDevices.add((Device)current);
                                }
                                ++i;
                            }
                            Device[] toDeploy = new Device[DeploymentManagementDialog.this.selectedDevices.size()];
                            Object[] objectDevices = DeploymentManagementDialog.this.selectedDevices.toArray();
                            int i2 = 0;
                            while (i2 < DeploymentManagementDialog.this.selectedDevices.size()) {
                                toDeploy[i2] = (Device)objectDevices[i2];
                                ++i2;
                            }
                            dplp.deploy(deployment, toDeploy, null, DeploymentManagementDialog.this.monitor);
                        }
                        catch (MtjException ex) {
                            ex.printStackTrace();
                        }
                        catch (CoreException cex) {
                            cex.printStackTrace();
                        }
                    } else {
                        DeploymentManagementDialog.this.dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoResourceSelected, true);
                    }
                } else if (DeploymentManagementDialog.this.selectedResource instanceof IResource && !(resource = (IResource)DeploymentManagementDialog.this.selectedResource).getFileExtension().equalsIgnoreCase("jad")) {
                    DeploymentManagementDialog.this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyMidlets, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addBtnRefreshListeners(Button btnRefresh) {
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.deviceViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addBtnPropertiesListeners(Button btnProperties) {
        btnProperties.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.deviceViewer.getSelection();
                if (DeploymentManagementDialog.this.deviceViewer.getSelection().isEmpty()) {
                    DeploymentManagementDialog.this.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoDeviceOrProviderSelected, true);
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addDeviceViewerListeners(final CheckboxTreeViewer deviceViewer) {
        deviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DeploymentManagementDialog.this.lblDescription.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Object domain : selection) {
                        String value = DeploymentManagementDialog.this.labelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    DeploymentManagementDialog.this.lblDescription.setText(toShow.toString());
                }
            }
        });
        deviceViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object selection = event.getElement();
                if (selection instanceof DeploymentProvider) {
                    if (event.getChecked()) {
                        deviceViewer.expandToLevel(1);
                        deviceViewer.setSubtreeChecked(selection, true);
                    } else {
                        deviceViewer.setSubtreeChecked(selection, false);
                    }
                } else if (selection instanceof Device) {
                    Device checkedDevice = (Device)selection;
                    if (event.getChecked()) {
                        deviceViewer.setChecked(selection, true);
                        DeploymentManagementDialog.this.selectedDevices.add(checkedDevice);
                    } else {
                        deviceViewer.setParentsGrayed(selection, false);
                        DeploymentManagementDialog.this.selectedDevices.remove(checkedDevice);
                    }
                }
            }
        });
        deviceViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    private void addProtocolSelectionListener(Combo cboProtocol) {
        cboProtocol.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        this.btnClose = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        this.btnClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentManagementDialog.this.dplmDialog.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean close() {
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    private void updateStatus(String message, boolean error) {
        if (error) {
            this.setErrorMessage(message);
        } else {
            this.setErrorMessage(null);
            this.setMessage(message);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployResource);
        newShell.setImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage());
    }

    protected Object getSelectedResource() {
        IStructuredSelection structuredSelection;
        Object res = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection) != null) {
            res = structuredSelection.getFirstElement();
        }
        return res;
    }

    protected void cancelPressed() {
        this.close();
    }
}

