/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.preferences.DeployComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DeployController
implements ICheckStateListener {
    private DeployComposite composite;
    private DeploymentProvider[] providers;
    private CheckboxTableViewer providerTableViewer;
    private CheckboxTableViewer deviceTableViewer;
    private Button editProviderButton;
    private Button editDeviceButton;

    public DeployController(DeployComposite composite) {
        this.composite = composite;
        this.deviceTableViewer = composite.getDeviceTableViewer();
        this.providerTableViewer = composite.getProviderTableViewer();
        this.editDeviceButton = composite.getEditDeviceButton();
        this.editProviderButton = composite.getEditProviderButton();
        this.editDeviceButton.setEnabled(false);
        this.editProviderButton.setEnabled(false);
        this.setProviderTable();
        this.setDeviceTable();
        this.addListeners();
        this.updateProvider();
    }

    private void updateProvider() {
        BasicEList list = new BasicEList();
        try {
            private class LoadData
            implements IRunnableWithProgress {
                private BasicEList list;

                public LoadData(BasicEList list) {
                    this.list = list;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(DeploymentManagementUIMessages.DeployController_LoadingDeploymentProviderData, 100);
                    monitor.worked(50);
                    Object[] extension = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
                    this.list.setData(extension.length, extension);
                    monitor.done();
                }
            }
            LoadData op = new LoadData(list);
            new ProgressMonitorDialog(this.composite.getShell()).run(false, false, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.providerTableViewer.setInput((Object)list);
        this.deviceTableViewer.setInput((Object)new Device[0]);
    }

    private void addListeners() {
        this.providerTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private void setProviderTable() {
        DeployController.createTableColumn("", this.providerTableViewer.getTable(), 0, 20);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Name, this.providerTableViewer.getTable(), 1, 160);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Vendor, this.providerTableViewer.getTable(), 2, 100);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Version, this.providerTableViewer.getTable(), 3, 60);
        private class Cp
        implements IStructuredContentProvider {
            Cp() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof BasicEList) {
                    return ((BasicEList)o).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.providerTableViewer.setContentProvider((IContentProvider)new Cp());
        private class Plp
        extends LabelProvider
        implements ITableLabelProvider {
            Plp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof DeploymentProvider) {
                    DeploymentProvider dp = (DeploymentProvider)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return dp.getName();
                    }
                    if (columnIndex == 2) {
                        return dp.getVendor();
                    }
                    if (columnIndex == 3) {
                        return dp.getVersion();
                    }
                }
                return null;
            }
        }
        this.providerTableViewer.setLabelProvider((IBaseLabelProvider)new Plp());
    }

    private void setDeviceTable() {
        DeployController.createTableColumn("", this.deviceTableViewer.getTable(), 0, 20);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Name, this.deviceTableViewer.getTable(), 1, 160);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Vendor, this.deviceTableViewer.getTable(), 2, 60);
        DeployController.createTableColumn(DeploymentManagementUIMessages.DeployController_Version, this.deviceTableViewer.getTable(), 3, 60);
        private class Cp
        implements IStructuredContentProvider {
            Cp() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof Device[]) {
                    return (Device[])o;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.deviceTableViewer.setContentProvider((IContentProvider)new Cp());
        private class Plp
        extends LabelProvider
        implements ITableLabelProvider {
            Plp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Device) {
                    Device d = (Device)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return d.getName();
                    }
                    if (columnIndex == 2) {
                        return d.getVendor();
                    }
                    if (columnIndex == 3) {
                        return d.getVersion();
                    }
                }
                return null;
            }
        }
        this.deviceTableViewer.setLabelProvider((IBaseLabelProvider)new Plp());
    }

    private static TableColumn createTableColumn(String title, Table table, int index, int widthHint) {
        TableColumn tableColumn = new TableColumn(table, 0, index);
        tableColumn.setResizable(true);
        tableColumn.setWidth(widthHint);
        tableColumn.setText(title);
        return tableColumn;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        block5: {
            boolean checkState = event.getChecked();
            Object o = event.getElement();
            if (o instanceof DeploymentProvider) {
                DeploymentProvider dp = (DeploymentProvider)o;
                try {
                    Device[] da = dp.getDevices();
                    if (checkState) {
                        this.deviceTableViewer.setInput((Object)da);
                        break block5;
                    }
                    this.deviceTableViewer.setInput((Object)new Device[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                boolean cfr_ignored_0 = o instanceof Device;
            }
        }
    }
}

