/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class DeploymentPropertyPage
extends PropertyPage {
    private static final String PATH_TITLE = DeploymentManagementUIMessages.DeploymentPropertyPage_Path;
    private static final String OWNER_TITLE = DeploymentManagementUIMessages.DeploymentPropertyPage_OwnerTitle;
    private static final String OWNER_PROPERTY = DeploymentManagementUIMessages.DeploymentPropertyPage_OnwerProperty;
    private static final String DEFAULT_OWNER = DeploymentManagementUIMessages.DeploymentPropertyPage_DefaultOwner;
    private static final int TEXT_FIELD_WIDTH = 50;
    private Text ownerText;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(((IResource)this.getElement()).getFullPath().toString());
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label ownerLabel = new Label(composite, 0);
        ownerLabel.setText(OWNER_TITLE);
        this.ownerText = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.ownerText.setLayoutData((Object)gd);
        try {
            String owner = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", OWNER_PROPERTY));
            this.ownerText.setText(owner != null ? owner : DEFAULT_OWNER);
        }
        catch (CoreException coreException) {
            this.ownerText.setText(DEFAULT_OWNER);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.ownerText.setText(DEFAULT_OWNER);
    }

    public boolean performOk() {
        try {
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("", OWNER_PROPERTY), this.ownerText.getText());
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }
}

