/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dpp.nokia;

import java.util.StringTokenizer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.executable.uei.AbstractUeiDevicePlatformImporter;

public class NokiaSdkDevicePlatformImporter
extends AbstractUeiDevicePlatformImporter {
    private final String UEI_PROP_DEVICE_DESCRIPTION = ".description";
    private final String UEI_PROP_DEVICE_MODEL = ".model";
    private final String vendor = "Nokia";
    private static NokiaSdkDevicePlatformImporter instance;

    private NokiaSdkDevicePlatformImporter() {
        super(false);
    }

    public static NokiaSdkDevicePlatformImporter getDefault() {
        if (instance == null) {
            instance = new NokiaSdkDevicePlatformImporter();
        }
        return instance;
    }

    public String getVendor() {
        return "Nokia";
    }

    public void createDeviceDetails(Device device) {
        String origName = device.getName();
        device.setVendor(this.getVendor());
        device.setVersion(this.getDeviceVersion(origName));
        String deviceDescrKey = String.valueOf(origName) + ".description";
        String description = this.getUeiProperties().getProperty(deviceDescrKey);
        if (description == null) {
            deviceDescrKey = String.valueOf(origName) + ".model";
            description = this.getUeiProperties().getProperty(deviceDescrKey);
            if (description == null) {
                description = "Generic UEI device";
            }
        }
        device.setDescription(description);
    }

    public String getRuntimePlatformDefinitionName(String deviceName) {
        StringBuffer sb = new StringBuffer(this.getVendor());
        sb.append(" ");
        sb.append(this.getStyledDeviceName(deviceName));
        sb.append(" Runtime Platform");
        return sb.toString();
    }

    public DeviceDescription createDeviceDescription(String deviceName) {
        DeviceDescription dd = DevicesFactory.eINSTANCE.createDeviceDescription();
        dd.setIdentifier(String.valueOf(this.getVendor()) + " " + this.getUeiProperties().getProperty(".model"));
        return dd;
    }

    public boolean hasDebugServer() {
        return true;
    }

    public boolean isPredeployRequired() {
        return true;
    }

    public String getLaunchCommand() {
        return "%executable% [%debugPort%|-Xdebug -Xrunjdwp:transport=dt_socket,suspend=y,server=y,address=%debugPort%] -classpath \"%classpath%\" -Xdevice:%device% [%jadfile%|\"-Xdescriptor:%jadfile%\"] [%verbose%|-Xverbose:%verbose%] [%heapsize%|-Xheapsize:%heapsize%] [%securityDomain%|-Xdomain:%securityDomain%] %userSpecifiedArguments%  [%otaurl%|-Xjam:transient=%otaurl%]";
    }

    private String getStyledDeviceName(String deviceName) {
        StringBuffer styledDeviceName = new StringBuffer();
        StringTokenizer st = new StringTokenizer(deviceName, "_");
        while (st.hasMoreTokens()) {
            styledDeviceName.append(st.nextToken().trim());
            styledDeviceName.append(" ");
        }
        return styledDeviceName.toString().trim();
    }

    private String getDeviceVersion(String deviceName) {
        return "1.0.3";
    }
}

