/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplp.nokia.pcsuite.impl;

import com.nokia.phone.deploy.CONA;
import com.nokia.phone.deploy.event.ConnectionLayerEvent;
import com.nokia.phone.deploy.event.TerminalEvent;
import com.nokia.phone.deploy.event.TerminalListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.PCSuiteMessages;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.util.StringManipulator;

public class Deployer {
    private transient TerminalObserver terminalObserver = null;
    private transient boolean connected = false;
    private transient boolean updateTerminalList = false;
    private transient Vector<TerminalListener> terminalListeners = null;
    private static final int TERMINAL_CONNECTED = 0;
    private static final int TERMINAL_DISCONNECTED = 1;
    private int comPort = 1;
    private static boolean OSSupportsDeployment = true;
    private boolean deploying_ = false;

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            OSSupportsDeployment = false;
        }
    }

    public static void main(String[] args) {
        String[] terminals;
        if (!CONA.getInstance().getDllFound()) {
            System.out.println("ConnAPI.dll not found");
            System.exit(0);
        }
        Deployer deployer = new Deployer();
        deployer.openConnectionLayer();
        if (!deployer.connected) {
            System.out.println("connection failed");
            System.exit(0);
        }
        if ((terminals = deployer.getTerminals()).length == 0) {
            System.out.println("no devices found");
            deployer.closeConnectionLayer();
            System.exit(0);
        }
        int i = 0;
        while (i < terminals.length) {
            System.out.println("device found " + terminals[i] + " using " + deployer.getConnectionType(terminals[i]));
            try {
                deployer.deploy(new File("c:\\runtime-workspace\\test\\deployed\\Boids.jad"), new File("c:\\runtime-workspace\\test\\deployed\\Boids.jar"), terminals[i]);
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public Deployer() {
        this.initialize();
    }

    private void initialize() {
        if (this.terminalListeners == null) {
            this.terminalListeners = new Vector();
        }
        this.connected = false;
        this.updateTerminalList = false;
        this.openConnectionLayer();
        if (!this.connected) {
            System.out.println("connection failed");
        }
    }

    public void addTerminalListener(TerminalListener terminalListener) {
        this.terminalListeners.add(terminalListener);
        if (!OSSupportsDeployment) {
            terminalListener.connectionLayerEventOccurred(new ConnectionLayerEvent((Object)this, 0, PCSuiteMessages.Deployer_10));
        } else if (!CONA.getInstance().getDllFound()) {
            terminalListener.connectionLayerEventOccurred(new ConnectionLayerEvent((Object)this, 1, PCSuiteMessages.Deployer_11));
        } else if (this.terminalListeners.size() == 1 && !this.connected && OSSupportsDeployment) {
            this.openConnectionLayer();
        }
        if (!this.connected) {
            terminalListener.connectionLayerEventOccurred(new ConnectionLayerEvent((Object)this, 2, PCSuiteMessages.Deployer_12));
        } else {
            terminalListener.connectionLayerEventOccurred(new ConnectionLayerEvent((Object)this, 3, PCSuiteMessages.Deployer_13));
        }
    }

    public void shutdown() {
        while (this.terminalListeners.size() > 0) {
            this.terminalListeners.remove(0);
        }
        this.closeConnectionLayer();
    }

    public void removeTerminalListener(TerminalListener terminalListener) {
        this.terminalListeners.remove(terminalListener);
        if (this.terminalListeners.size() == 0 && this.connected) {
            this.closeConnectionLayer();
        }
    }

    protected void openConnectionLayer() {
        if (CONA.getInstance().getDllFound() && !this.connected) {
            this.connected = CONA.getInstance().connect();
            if (this.connected) {
                this.updateTerminalList = true;
                this.terminalObserver = new TerminalObserver();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void closeConnectionLayer() {
        this.updateTerminalList = false;
        try {
            Thread.sleep(3050L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.connected) {
            boolean disconnected = CONA.getInstance().disconnect();
            if (!disconnected) {
                this.generateConnectionLayerEvent(4, PCSuiteMessages.Deployer_14);
            }
            this.connected = !disconnected;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String[] getTerminals() {
        if (!this.connected) {
            this.openConnectionLayer();
        }
        if (this.terminalObserver != null) {
            Vector result = new Vector();
            Hashtable openConnections = this.terminalObserver.getTerminals();
            Enumeration keys = openConnections.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
            return result.toArray(new String[0]);
        }
        return new String[0];
    }

    public String getConnectionType(String terminal) {
        if (!this.connected) {
            this.openConnectionLayer();
        }
        if (this.terminalObserver != null) {
            return (String)this.terminalObserver.getTerminals().get(terminal);
        }
        return "";
    }

    public TerminalListener[] getTerminalListeners() {
        return this.terminalListeners.toArray(new TerminalListener[0]);
    }

    private void generateTerminalEvent(int type, String terminalName, String connectionType) {
        TerminalEvent terminalEvent = null;
        switch (type) {
            case 0: {
                terminalEvent = new TerminalEvent((Object)this, terminalName, connectionType);
                int i = 0;
                while (i < this.terminalListeners.size()) {
                    this.terminalListeners.elementAt(i).terminalConnected(terminalEvent);
                    ++i;
                }
                break;
            }
            case 1: {
                terminalEvent = new TerminalEvent((Object)this, terminalName, connectionType);
                int i = 0;
                while (i < this.terminalListeners.size()) {
                    this.terminalListeners.elementAt(i).terminalDisconnected(terminalEvent);
                    ++i;
                }
                break;
            }
        }
    }

    private void generateConnectionLayerEvent(int id, String message) {
        ConnectionLayerEvent connectionLayerEvent = new ConnectionLayerEvent((Object)this, id, message);
        int i = 0;
        while (i < this.terminalListeners.size()) {
            this.terminalListeners.elementAt(i).connectionLayerEventOccurred(connectionLayerEvent);
            ++i;
        }
    }

    public int[] getComPorts() {
        return new int[]{1, 2};
    }

    public int getComPort() {
        return this.comPort;
    }

    public void setComPort(int comPort) {
        if (this.comPort != comPort && this.connected) {
            this.comPort = comPort;
        }
        this.comPort = comPort;
    }

    public void deploy(File jad, File jar, String terminal) throws IOException, UnsatisfiedLinkError {
        if (!CONA.getInstance().getDllFound()) {
            throw new UnsatisfiedLinkError(PCSuiteMessages.Deployer_16);
        }
        if (!this.connected) {
            this.openConnectionLayer();
            if (!this.connected) {
                this.generateConnectionLayerEvent(2, PCSuiteMessages.Deployer_17);
                return;
            }
            this.generateConnectionLayerEvent(3, PCSuiteMessages.Deployer_18);
        }
        int id = this.terminalObserver.getID(terminal);
        if (!jad.exists()) {
            throw new IOException(String.valueOf(PCSuiteMessages.Deployer_19) + jad.getAbsolutePath());
        }
        if (!jar.exists()) {
            throw new IOException(String.valueOf(PCSuiteMessages.Deployer_20) + jar.getAbsolutePath());
        }
        if (id != -1) {
            new MIDletSuiteDeploymentThread(jad, jar, id).start();
        } else {
            this.generateConnectionLayerEvent(7, String.valueOf(PCSuiteMessages.Deployer_21) + terminal);
        }
    }

    private boolean openConnection(int ind) {
        boolean openC = CONA.getInstance().openFileSystem(ind);
        return openC;
    }

    private boolean installFile(String filepath, String filename, String jadfile) {
        boolean binstallfile = false;
        binstallfile = filename.toLowerCase().endsWith(".sis") ? CONA.getInstance().installApplication(filepath, filename, null, 1, true) : CONA.getInstance().installApplication(filepath, filename, jadfile, 2, true);
        return binstallfile;
    }

    private boolean closeConnection() {
        return CONA.getInstance().closeFileSystem();
    }

    private class MIDletSuiteDeploymentThread
    extends Thread {
        private File deployJAD = null;
        private File deployJAR = null;
        private int deployID = -1;

        MIDletSuiteDeploymentThread(File jad, File jar, int id) {
            this.deployJAD = jad;
            this.deployJAR = jar;
            this.deployID = id;
        }

        public void run() {
            boolean success = true;
            String jarfilepath = this.deployJAR.getParentFile().getAbsolutePath();
            String jadfilename = this.deployJAD.getName();
            String jarfilename = this.deployJAR.getName();
            Deployer.this.generateConnectionLayerEvent(8, String.valueOf(PCSuiteMessages.Deployer_23) + this.deployID);
            boolean bopenconnection = Deployer.this.openConnection(this.deployID);
            if (bopenconnection) {
                Deployer.this.generateConnectionLayerEvent(9, String.valueOf(PCSuiteMessages.Deployer_24) + this.deployID);
                String strFilepath = String.valueOf(jarfilepath) + "\\";
                success = Deployer.this.installFile(strFilepath, jarfilename, jadfilename);
                if (success) {
                    Deployer.this.generateConnectionLayerEvent(11, PCSuiteMessages.Deployer_26);
                    Deployer.this.generateConnectionLayerEvent(19, PCSuiteMessages.Deployer_27);
                } else {
                    Deployer.this.generateConnectionLayerEvent(13, String.valueOf(PCSuiteMessages.Deployer_28) + jarfilename);
                    Deployer.this.generateConnectionLayerEvent(12, PCSuiteMessages.Deployer_29);
                }
            } else {
                Deployer.this.generateConnectionLayerEvent(16, String.valueOf(PCSuiteMessages.Deployer_30) + this.deployID);
                Deployer.this.generateConnectionLayerEvent(12, PCSuiteMessages.Deployer_31);
                return;
            }
            Deployer.this.closeConnection();
            Deployer.this.generateConnectionLayerEvent(17, String.valueOf(PCSuiteMessages.Deployer_32) + this.deployID);
        }
    }

    private class TerminalObserver
    implements Runnable {
        Vector allTerminals = new Vector();
        Vector rs232Terminals = new Vector();
        Vector irDATerminals = new Vector();
        Vector usbTerminals = new Vector();
        Vector btTerminals = new Vector();

        TerminalObserver() {
            new Thread(this).start();
        }

        public Hashtable getTerminals() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String terminal = "";
            String connection = "";
            int i = 0;
            while (i < this.rs232Terminals.size()) {
                terminal = (String)this.rs232Terminals.elementAt(i);
                connection = "RS232";
                hashtable.put(terminal, connection);
                ++i;
            }
            i = 0;
            while (i < this.irDATerminals.size()) {
                terminal = (String)this.irDATerminals.elementAt(i);
                connection = "IrDA";
                hashtable.put(terminal, connection);
                ++i;
            }
            i = 0;
            while (i < this.usbTerminals.size()) {
                terminal = (String)this.usbTerminals.elementAt(i);
                connection = "USB";
                hashtable.put(terminal, connection);
                ++i;
            }
            i = 0;
            while (i < this.btTerminals.size()) {
                terminal = (String)this.btTerminals.elementAt(i);
                connection = "Bluetooth";
                hashtable.put(terminal, connection);
                ++i;
            }
            return hashtable;
        }

        public int getID(String terminal) {
            String idString = terminal.substring(terminal.indexOf("(ID:") + 4, terminal.indexOf(")")).trim();
            return Integer.parseInt(idString);
        }

        public void run() {
            while (Deployer.this.updateTerminalList) {
                if (Deployer.this.deploying_) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                CONA.getInstance().updateDeviceList();
                String irDATerminalList = this.getIrDATerminals();
                String rs232TerminalList = this.getRS232Terminals();
                String usbTerminalList = this.getUSBTerminals();
                String btTerminalList = this.getBTTerminals();
                String completeTerminalList = String.valueOf(irDATerminalList) + "," + rs232TerminalList + "," + usbTerminalList + "," + btTerminalList;
                StringTokenizer irDATokenizer = new StringTokenizer(irDATerminalList, ",");
                StringTokenizer rs232Tokenizer = new StringTokenizer(rs232TerminalList, ",");
                StringTokenizer usbTokenizer = new StringTokenizer(usbTerminalList, ",");
                StringTokenizer btTokenizer = new StringTokenizer(btTerminalList, ",");
                StringTokenizer allTerminalsTokenizer = new StringTokenizer(completeTerminalList, ",");
                while (irDATokenizer.hasMoreTokens()) {
                    String irDATerminal = irDATokenizer.nextToken();
                    if (this.isOnTerminalList(this.allTerminals, irDATerminal)) continue;
                    this.allTerminals.add(irDATerminal);
                    this.irDATerminals.add(irDATerminal);
                    Deployer.this.generateTerminalEvent(0, irDATerminal, "IrDA");
                }
                while (rs232Tokenizer.hasMoreTokens()) {
                    String rs232Terminal = rs232Tokenizer.nextToken();
                    if (this.isOnTerminalList(this.allTerminals, rs232Terminal)) continue;
                    this.allTerminals.add(rs232Terminal);
                    this.rs232Terminals.add(rs232Terminal);
                    Deployer.this.generateTerminalEvent(0, rs232Terminal, "RS232");
                }
                while (usbTokenizer.hasMoreTokens()) {
                    String usbTerminal = usbTokenizer.nextToken();
                    if (this.isOnTerminalList(this.allTerminals, usbTerminal)) continue;
                    this.allTerminals.add(usbTerminal);
                    this.usbTerminals.add(usbTerminal);
                    Deployer.this.generateTerminalEvent(0, usbTerminal, "USB");
                }
                while (btTokenizer.hasMoreTokens()) {
                    String btTerminal = btTokenizer.nextToken();
                    if (this.isOnTerminalList(this.allTerminals, btTerminal)) continue;
                    this.allTerminals.add(btTerminal);
                    this.btTerminals.add(btTerminal);
                    Deployer.this.generateTerminalEvent(0, btTerminal, "Bluetooth");
                }
                Vector<String> currentTerminals = new Vector<String>();
                while (allTerminalsTokenizer.hasMoreTokens()) {
                    String terminal = allTerminalsTokenizer.nextToken();
                    currentTerminals.add(terminal);
                }
                int i = 0;
                while (i < this.allTerminals.size()) {
                    String terminal = (String)this.allTerminals.elementAt(i);
                    boolean found = false;
                    int j = 0;
                    while (j < currentTerminals.size()) {
                        String currentTerminal = (String)currentTerminals.elementAt(j);
                        if (currentTerminal.compareTo(terminal) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        if (this.isOnTerminalList(this.irDATerminals, terminal)) {
                            this.removeTerminal(this.allTerminals, terminal);
                            this.removeTerminal(this.irDATerminals, terminal);
                            Deployer.this.generateTerminalEvent(1, terminal, "IrDA");
                        } else if (this.isOnTerminalList(this.rs232Terminals, terminal)) {
                            this.removeTerminal(this.allTerminals, terminal);
                            this.removeTerminal(this.rs232Terminals, terminal);
                            Deployer.this.generateTerminalEvent(1, terminal, "RS232");
                        } else if (this.isOnTerminalList(this.usbTerminals, terminal)) {
                            this.removeTerminal(this.allTerminals, terminal);
                            this.removeTerminal(this.usbTerminals, terminal);
                            Deployer.this.generateTerminalEvent(1, terminal, "USB");
                        } else if (this.isOnTerminalList(this.btTerminals, terminal)) {
                            this.removeTerminal(this.allTerminals, terminal);
                            this.removeTerminal(this.btTerminals, terminal);
                            Deployer.this.generateTerminalEvent(1, terminal, "Bluetooth");
                        }
                        i = -1;
                    }
                    ++i;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private String getRS232Terminals() {
            String devices = CONA.getInstance().getDevices(4);
            if (devices == null) {
                devices = "";
            }
            return StringManipulator.substitute(devices, "E ", "EPOC device ");
        }

        private String getIrDATerminals() {
            String devices = CONA.getInstance().getDevices(2);
            if (devices == null) {
                devices = "";
            }
            return StringManipulator.substitute(devices, "E ", "EPOC device ");
        }

        private String getUSBTerminals() {
            String devices = CONA.getInstance().getDevices(16);
            if (devices == null) {
                devices = "";
            }
            return StringManipulator.substitute(devices, "E ", "EPOC device ");
        }

        private String getBTTerminals() {
            String devices = CONA.getInstance().getDevices(8);
            if (devices == null) {
                devices = "";
            }
            return devices;
        }

        private boolean isOnTerminalList(Vector terminals, String terminal) {
            int i = 0;
            while (i < terminals.size()) {
                if (terminal.compareTo((String)terminals.elementAt(i)) == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private int whichTerminalOnList(Vector terminals, String terminal) {
            int i = 0;
            while (i < terminals.size()) {
                if (terminal.compareTo((String)terminals.elementAt(i)) == 0) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void removeTerminal(Vector terminals, String terminal) {
            int i = 0;
            while (i < terminals.size()) {
                if (terminal.compareTo((String)terminals.elementAt(i)) == 0) {
                    terminals.remove(i);
                }
                ++i;
            }
        }
    }
}

